/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata about a source cited for the generated response.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax"
 * >RetrieveAndGenerate response</a> – in the <code>retrievedReferences</code> field
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax"
 * >InvokeAgent response</a> – in the <code>retrievedReferences</code> field
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrievedReference implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrievedReference.Builder, RetrievedReference> {
    private static final SdkField<RetrievalResultContent> CONTENT_FIELD = SdkField
            .<RetrievalResultContent> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(RetrievedReference::content)).setter(setter(Builder::content))
            .constructor(RetrievalResultContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<RetrievalResultLocation> LOCATION_FIELD = SdkField
            .<RetrievalResultLocation> builder(MarshallingType.SDK_POJO).memberName("location")
            .getter(getter(RetrievedReference::location)).setter(setter(Builder::location))
            .constructor(RetrievalResultLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final SdkField<Map<String, Document>> METADATA_FIELD = SdkField
            .<Map<String, Document>> builder(MarshallingType.MAP)
            .memberName("metadata")
            .getter(getter(RetrievedReference::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.DOCUMENT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, LOCATION_FIELD,
            METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RetrievalResultContent content;

    private final RetrievalResultLocation location;

    private final Map<String, Document> metadata;

    private RetrievedReference(BuilderImpl builder) {
        this.content = builder.content;
        this.location = builder.location;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * Contains the cited text from the data source.
     * </p>
     * 
     * @return Contains the cited text from the data source.
     */
    public final RetrievalResultContent content() {
        return content;
    }

    /**
     * <p>
     * Contains information about the location of the data source.
     * </p>
     * 
     * @return Contains information about the location of the data source.
     */
    public final RetrievalResultLocation location() {
        return location;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Contains metadata attributes and their values for the file in the data source. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-ds.html#kb-ds-metadata">Metadata and
     * filtering</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return Contains metadata attributes and their values for the file in the data source. For more information, see
     *         <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-ds.html#kb-ds-metadata">
     *         Metadata and filtering</a>.
     */
    public final Map<String, Document> metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievedReference)) {
            return false;
        }
        RetrievedReference other = (RetrievedReference) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(location(), other.location())
                && hasMetadata() == other.hasMetadata() && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrievedReference")
                .add("Content", content() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Location", location() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("location", LOCATION_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrievedReference, T> g) {
        return obj -> g.apply((RetrievedReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrievedReference> {
        /**
         * <p>
         * Contains the cited text from the data source.
         * </p>
         * 
         * @param content
         *        Contains the cited text from the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(RetrievalResultContent content);

        /**
         * <p>
         * Contains the cited text from the data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrievalResultContent.Builder} avoiding
         * the need to create one manually via {@link RetrievalResultContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultContent.Builder#build()} is called immediately and
         * its result is passed to {@link #content(RetrievalResultContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link RetrievalResultContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(RetrievalResultContent)
         */
        default Builder content(Consumer<RetrievalResultContent.Builder> content) {
            return content(RetrievalResultContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * Contains information about the location of the data source.
         * </p>
         * 
         * @param location
         *        Contains information about the location of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(RetrievalResultLocation location);

        /**
         * <p>
         * Contains information about the location of the data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrievalResultLocation.Builder} avoiding
         * the need to create one manually via {@link RetrievalResultLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalResultLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #location(RetrievalResultLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link RetrievalResultLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(RetrievalResultLocation)
         */
        default Builder location(Consumer<RetrievalResultLocation.Builder> location) {
            return location(RetrievalResultLocation.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * Contains metadata attributes and their values for the file in the data source. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-ds.html#kb-ds-metadata">Metadata
         * and filtering</a>.
         * </p>
         * 
         * @param metadata
         *        Contains metadata attributes and their values for the file in the data source. For more information,
         *        see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-ds.html#kb-ds-metadata"
         *        >Metadata and filtering</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, Document> metadata);
    }

    static final class BuilderImpl implements Builder {
        private RetrievalResultContent content;

        private RetrievalResultLocation location;

        private Map<String, Document> metadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievedReference model) {
            content(model.content);
            location(model.location);
            metadata(model.metadata);
        }

        public final RetrievalResultContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(RetrievalResultContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(RetrievalResultContent content) {
            this.content = content;
            return this;
        }

        public final RetrievalResultLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        public final void setLocation(RetrievalResultLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(RetrievalResultLocation location) {
            this.location = location;
            return this;
        }

        public final Map<String, Document> getMetadata() {
            if (metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Map<String, Document> metadata) {
            this.metadata = RetrievalResultMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, Document> metadata) {
            this.metadata = RetrievalResultMetadataCopier.copy(metadata);
            return this;
        }

        @Override
        public RetrievedReference build() {
            return new RetrievedReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
