/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An action invocation result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReturnControlResults implements SdkPojo, Serializable,
        ToCopyableBuilder<ReturnControlResults.Builder, ReturnControlResults> {
    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invocationId").getter(getter(ReturnControlResults::invocationId)).setter(setter(Builder::invocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationId").build()).build();

    private static final SdkField<List<InvocationResultMember>> RETURN_CONTROL_INVOCATION_RESULTS_FIELD = SdkField
            .<List<InvocationResultMember>> builder(MarshallingType.LIST)
            .memberName("returnControlInvocationResults")
            .getter(getter(ReturnControlResults::returnControlInvocationResults))
            .setter(setter(Builder::returnControlInvocationResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnControlInvocationResults")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InvocationResultMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(InvocationResultMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_ID_FIELD,
            RETURN_CONTROL_INVOCATION_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String invocationId;

    private final List<InvocationResultMember> returnControlInvocationResults;

    private ReturnControlResults(BuilderImpl builder) {
        this.invocationId = builder.invocationId;
        this.returnControlInvocationResults = builder.returnControlInvocationResults;
    }

    /**
     * <p>
     * The action's invocation ID.
     * </p>
     * 
     * @return The action's invocation ID.
     */
    public final String invocationId() {
        return invocationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReturnControlInvocationResults property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReturnControlInvocationResults() {
        return returnControlInvocationResults != null && !(returnControlInvocationResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The action invocation result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReturnControlInvocationResults} method.
     * </p>
     * 
     * @return The action invocation result.
     */
    public final List<InvocationResultMember> returnControlInvocationResults() {
        return returnControlInvocationResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invocationId());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReturnControlInvocationResults() ? returnControlInvocationResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReturnControlResults)) {
            return false;
        }
        ReturnControlResults other = (ReturnControlResults) obj;
        return Objects.equals(invocationId(), other.invocationId())
                && hasReturnControlInvocationResults() == other.hasReturnControlInvocationResults()
                && Objects.equals(returnControlInvocationResults(), other.returnControlInvocationResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ReturnControlResults")
                .add("InvocationId", invocationId())
                .add("ReturnControlInvocationResults",
                        hasReturnControlInvocationResults() ? returnControlInvocationResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invocationId":
            return Optional.ofNullable(clazz.cast(invocationId()));
        case "returnControlInvocationResults":
            return Optional.ofNullable(clazz.cast(returnControlInvocationResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invocationId", INVOCATION_ID_FIELD);
        map.put("returnControlInvocationResults", RETURN_CONTROL_INVOCATION_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReturnControlResults, T> g) {
        return obj -> g.apply((ReturnControlResults) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReturnControlResults> {
        /**
         * <p>
         * The action's invocation ID.
         * </p>
         * 
         * @param invocationId
         *        The action's invocation ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationId(String invocationId);

        /**
         * <p>
         * The action invocation result.
         * </p>
         * 
         * @param returnControlInvocationResults
         *        The action invocation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnControlInvocationResults(Collection<InvocationResultMember> returnControlInvocationResults);

        /**
         * <p>
         * The action invocation result.
         * </p>
         * 
         * @param returnControlInvocationResults
         *        The action invocation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnControlInvocationResults(InvocationResultMember... returnControlInvocationResults);

        /**
         * <p>
         * The action invocation result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationResultMember.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationResultMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationResultMember.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #returnControlInvocationResults(List<InvocationResultMember>)}.
         * 
         * @param returnControlInvocationResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.InvocationResultMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #returnControlInvocationResults(java.util.Collection<InvocationResultMember>)
         */
        Builder returnControlInvocationResults(Consumer<InvocationResultMember.Builder>... returnControlInvocationResults);
    }

    static final class BuilderImpl implements Builder {
        private String invocationId;

        private List<InvocationResultMember> returnControlInvocationResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReturnControlResults model) {
            invocationId(model.invocationId);
            returnControlInvocationResults(model.returnControlInvocationResults);
        }

        public final String getInvocationId() {
            return invocationId;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final List<InvocationResultMember.Builder> getReturnControlInvocationResults() {
            List<InvocationResultMember.Builder> result = ReturnControlInvocationResultsCopier
                    .copyToBuilder(this.returnControlInvocationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReturnControlInvocationResults(
                Collection<InvocationResultMember.BuilderImpl> returnControlInvocationResults) {
            this.returnControlInvocationResults = ReturnControlInvocationResultsCopier
                    .copyFromBuilder(returnControlInvocationResults);
        }

        @Override
        public final Builder returnControlInvocationResults(Collection<InvocationResultMember> returnControlInvocationResults) {
            this.returnControlInvocationResults = ReturnControlInvocationResultsCopier.copy(returnControlInvocationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder returnControlInvocationResults(InvocationResultMember... returnControlInvocationResults) {
            returnControlInvocationResults(Arrays.asList(returnControlInvocationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder returnControlInvocationResults(
                Consumer<InvocationResultMember.Builder>... returnControlInvocationResults) {
            returnControlInvocationResults(Stream.of(returnControlInvocationResults)
                    .map(c -> InvocationResultMember.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ReturnControlResults build() {
            return new ReturnControlResults(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
