/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the part of the generated text that contains a citation, alongside where it begins and ends.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_ResponseSyntax"
 * >RetrieveAndGenerate response</a> – in the <code>textResponsePart</code> field
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax"
 * >InvokeAgent response</a> – in the <code>textResponsePart</code> field
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextResponsePart implements SdkPojo, Serializable,
        ToCopyableBuilder<TextResponsePart.Builder, TextResponsePart> {
    private static final SdkField<Span> SPAN_FIELD = SdkField.<Span> builder(MarshallingType.SDK_POJO).memberName("span")
            .getter(getter(TextResponsePart::span)).setter(setter(Builder::span)).constructor(Span::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("span").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(TextResponsePart::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPAN_FIELD, TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Span span;

    private final String text;

    private TextResponsePart(BuilderImpl builder) {
        this.span = builder.span;
        this.text = builder.text;
    }

    /**
     * <p>
     * Contains information about where the text with a citation begins and ends in the generated output.
     * </p>
     * 
     * @return Contains information about where the text with a citation begins and ends in the generated output.
     */
    public final Span span() {
        return span;
    }

    /**
     * <p>
     * The part of the generated text that contains a citation.
     * </p>
     * 
     * @return The part of the generated text that contains a citation.
     */
    public final String text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(span());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextResponsePart)) {
            return false;
        }
        TextResponsePart other = (TextResponsePart) obj;
        return Objects.equals(span(), other.span()) && Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextResponsePart").add("Span", span()).add("Text", text()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "span":
            return Optional.ofNullable(clazz.cast(span()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("span", SPAN_FIELD);
        map.put("text", TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextResponsePart, T> g) {
        return obj -> g.apply((TextResponsePart) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextResponsePart> {
        /**
         * <p>
         * Contains information about where the text with a citation begins and ends in the generated output.
         * </p>
         * 
         * @param span
         *        Contains information about where the text with a citation begins and ends in the generated output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder span(Span span);

        /**
         * <p>
         * Contains information about where the text with a citation begins and ends in the generated output.
         * </p>
         * This is a convenience method that creates an instance of the {@link Span.Builder} avoiding the need to create
         * one manually via {@link Span#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Span.Builder#build()} is called immediately and its result is
         * passed to {@link #span(Span)}.
         * 
         * @param span
         *        a consumer that will call methods on {@link Span.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #span(Span)
         */
        default Builder span(Consumer<Span.Builder> span) {
            return span(Span.builder().applyMutation(span).build());
        }

        /**
         * <p>
         * The part of the generated text that contains a citation.
         * </p>
         * 
         * @param text
         *        The part of the generated text that contains a citation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);
    }

    static final class BuilderImpl implements Builder {
        private Span span;

        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(TextResponsePart model) {
            span(model.span);
            text(model.text);
        }

        public final Span.Builder getSpan() {
            return span != null ? span.toBuilder() : null;
        }

        public final void setSpan(Span.BuilderImpl span) {
            this.span = span != null ? span.build() : null;
        }

        @Override
        public final Builder span(Span span) {
            this.span = span;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public TextResponsePart build() {
            return new TextResponsePart(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
