/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for transforming the natural language query into SQL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformationConfiguration.Builder, TransformationConfiguration> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(TransformationConfiguration::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<TextToSqlConfiguration> TEXT_TO_SQL_CONFIGURATION_FIELD = SdkField
            .<TextToSqlConfiguration> builder(MarshallingType.SDK_POJO).memberName("textToSqlConfiguration")
            .getter(getter(TransformationConfiguration::textToSqlConfiguration)).setter(setter(Builder::textToSqlConfiguration))
            .constructor(TextToSqlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textToSqlConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD,
            TEXT_TO_SQL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final TextToSqlConfiguration textToSqlConfiguration;

    private TransformationConfiguration(BuilderImpl builder) {
        this.mode = builder.mode;
        this.textToSqlConfiguration = builder.textToSqlConfiguration;
    }

    /**
     * <p>
     * The mode of the transformation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link QueryTransformationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the transformation.
     * @see QueryTransformationMode
     */
    public final QueryTransformationMode mode() {
        return QueryTransformationMode.fromValue(mode);
    }

    /**
     * <p>
     * The mode of the transformation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link QueryTransformationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the transformation.
     * @see QueryTransformationMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * Specifies configurations for transforming text to SQL.
     * </p>
     * 
     * @return Specifies configurations for transforming text to SQL.
     */
    public final TextToSqlConfiguration textToSqlConfiguration() {
        return textToSqlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(textToSqlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformationConfiguration)) {
            return false;
        }
        TransformationConfiguration other = (TransformationConfiguration) obj;
        return Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(textToSqlConfiguration(), other.textToSqlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransformationConfiguration").add("Mode", modeAsString())
                .add("TextToSqlConfiguration", textToSqlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "textToSqlConfiguration":
            return Optional.ofNullable(clazz.cast(textToSqlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mode", MODE_FIELD);
        map.put("textToSqlConfiguration", TEXT_TO_SQL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformationConfiguration, T> g) {
        return obj -> g.apply((TransformationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformationConfiguration> {
        /**
         * <p>
         * The mode of the transformation.
         * </p>
         * 
         * @param mode
         *        The mode of the transformation.
         * @see QueryTransformationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryTransformationMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The mode of the transformation.
         * </p>
         * 
         * @param mode
         *        The mode of the transformation.
         * @see QueryTransformationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryTransformationMode
         */
        Builder mode(QueryTransformationMode mode);

        /**
         * <p>
         * Specifies configurations for transforming text to SQL.
         * </p>
         * 
         * @param textToSqlConfiguration
         *        Specifies configurations for transforming text to SQL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textToSqlConfiguration(TextToSqlConfiguration textToSqlConfiguration);

        /**
         * <p>
         * Specifies configurations for transforming text to SQL.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextToSqlConfiguration.Builder} avoiding
         * the need to create one manually via {@link TextToSqlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextToSqlConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #textToSqlConfiguration(TextToSqlConfiguration)}.
         * 
         * @param textToSqlConfiguration
         *        a consumer that will call methods on {@link TextToSqlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textToSqlConfiguration(TextToSqlConfiguration)
         */
        default Builder textToSqlConfiguration(Consumer<TextToSqlConfiguration.Builder> textToSqlConfiguration) {
            return textToSqlConfiguration(TextToSqlConfiguration.builder().applyMutation(textToSqlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private TextToSqlConfiguration textToSqlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformationConfiguration model) {
            mode(model.mode);
            textToSqlConfiguration(model.textToSqlConfiguration);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(QueryTransformationMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final TextToSqlConfiguration.Builder getTextToSqlConfiguration() {
            return textToSqlConfiguration != null ? textToSqlConfiguration.toBuilder() : null;
        }

        public final void setTextToSqlConfiguration(TextToSqlConfiguration.BuilderImpl textToSqlConfiguration) {
            this.textToSqlConfiguration = textToSqlConfiguration != null ? textToSqlConfiguration.build() : null;
        }

        @Override
        public final Builder textToSqlConfiguration(TextToSqlConfiguration textToSqlConfiguration) {
            this.textToSqlConfiguration = textToSqlConfiguration;
            return this;
        }

        @Override
        public TransformationConfiguration build() {
            return new TransformationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
