/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A citation event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CitationEvent implements SdkPojo, Serializable, ToCopyableBuilder<CitationEvent.Builder, CitationEvent>,
        RetrieveAndGenerateStreamResponseOutput {
    private static final SdkField<Citation> CITATION_FIELD = SdkField.<Citation> builder(MarshallingType.SDK_POJO)
            .memberName("citation").getter(getter(CitationEvent::citation)).setter(setter(Builder::citation))
            .constructor(Citation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citation").build()).build();

    private static final SdkField<GeneratedResponsePart> GENERATED_RESPONSE_PART_FIELD = SdkField
            .<GeneratedResponsePart> builder(MarshallingType.SDK_POJO).memberName("generatedResponsePart")
            .getter(getter(CitationEvent::generatedResponsePart)).setter(setter(Builder::generatedResponsePart))
            .constructor(GeneratedResponsePart::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedResponsePart").build())
            .build();

    private static final SdkField<List<RetrievedReference>> RETRIEVED_REFERENCES_FIELD = SdkField
            .<List<RetrievedReference>> builder(MarshallingType.LIST)
            .memberName("retrievedReferences")
            .getter(getter(CitationEvent::retrievedReferences))
            .setter(setter(Builder::retrievedReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievedReferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RetrievedReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(RetrievedReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITATION_FIELD,
            GENERATED_RESPONSE_PART_FIELD, RETRIEVED_REFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Citation citation;

    private final GeneratedResponsePart generatedResponsePart;

    private final List<RetrievedReference> retrievedReferences;

    protected CitationEvent(BuilderImpl builder) {
        this.citation = builder.citation;
        this.generatedResponsePart = builder.generatedResponsePart;
        this.retrievedReferences = builder.retrievedReferences;
    }

    /**
     * <p>
     * The citation.
     * </p>
     * 
     * @return The citation.
     * @deprecated Citation is deprecated. Please use GeneratedResponsePart and RetrievedReferences for citation event.
     */
    @Deprecated
    public final Citation citation() {
        return citation;
    }

    /**
     * <p>
     * The generated response to the citation event.
     * </p>
     * 
     * @return The generated response to the citation event.
     */
    public final GeneratedResponsePart generatedResponsePart() {
        return generatedResponsePart;
    }

    /**
     * For responses, this returns true if the service returned a value for the RetrievedReferences property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRetrievedReferences() {
        return retrievedReferences != null && !(retrievedReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The retrieved references of the citation event.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRetrievedReferences} method.
     * </p>
     * 
     * @return The retrieved references of the citation event.
     */
    public final List<RetrievedReference> retrievedReferences() {
        return retrievedReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(citation());
        hashCode = 31 * hashCode + Objects.hashCode(generatedResponsePart());
        hashCode = 31 * hashCode + Objects.hashCode(hasRetrievedReferences() ? retrievedReferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CitationEvent)) {
            return false;
        }
        CitationEvent other = (CitationEvent) obj;
        return Objects.equals(citation(), other.citation())
                && Objects.equals(generatedResponsePart(), other.generatedResponsePart())
                && hasRetrievedReferences() == other.hasRetrievedReferences()
                && Objects.equals(retrievedReferences(), other.retrievedReferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CitationEvent").add("Citation", citation())
                .add("GeneratedResponsePart", generatedResponsePart())
                .add("RetrievedReferences", hasRetrievedReferences() ? retrievedReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "citation":
            return Optional.ofNullable(clazz.cast(citation()));
        case "generatedResponsePart":
            return Optional.ofNullable(clazz.cast(generatedResponsePart()));
        case "retrievedReferences":
            return Optional.ofNullable(clazz.cast(retrievedReferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final CitationEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("citation", CITATION_FIELD);
        map.put("generatedResponsePart", GENERATED_RESPONSE_PART_FIELD);
        map.put("retrievedReferences", RETRIEVED_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CitationEvent, T> g) {
        return obj -> g.apply((CitationEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link CitationEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(RetrieveAndGenerateStreamResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CitationEvent> {
        /**
         * <p>
         * The citation.
         * </p>
         * 
         * @param citation
         *        The citation.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Citation is deprecated. Please use GeneratedResponsePart and RetrievedReferences for citation
         *             event.
         */
        @Deprecated
        Builder citation(Citation citation);

        /**
         * <p>
         * The citation.
         * </p>
         * This is a convenience method that creates an instance of the {@link Citation.Builder} avoiding the need to
         * create one manually via {@link Citation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Citation.Builder#build()} is called immediately and its result is
         * passed to {@link #citation(Citation)}.
         * 
         * @param citation
         *        a consumer that will call methods on {@link Citation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #citation(Citation)
         * @deprecated Citation is deprecated. Please use GeneratedResponsePart and RetrievedReferences for citation
         *             event.
         */
        @Deprecated
        default Builder citation(Consumer<Citation.Builder> citation) {
            return citation(Citation.builder().applyMutation(citation).build());
        }

        /**
         * <p>
         * The generated response to the citation event.
         * </p>
         * 
         * @param generatedResponsePart
         *        The generated response to the citation event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedResponsePart(GeneratedResponsePart generatedResponsePart);

        /**
         * <p>
         * The generated response to the citation event.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeneratedResponsePart.Builder} avoiding
         * the need to create one manually via {@link GeneratedResponsePart#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeneratedResponsePart.Builder#build()} is called immediately and
         * its result is passed to {@link #generatedResponsePart(GeneratedResponsePart)}.
         * 
         * @param generatedResponsePart
         *        a consumer that will call methods on {@link GeneratedResponsePart.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generatedResponsePart(GeneratedResponsePart)
         */
        default Builder generatedResponsePart(Consumer<GeneratedResponsePart.Builder> generatedResponsePart) {
            return generatedResponsePart(GeneratedResponsePart.builder().applyMutation(generatedResponsePart).build());
        }

        /**
         * <p>
         * The retrieved references of the citation event.
         * </p>
         * 
         * @param retrievedReferences
         *        The retrieved references of the citation event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievedReferences(Collection<RetrievedReference> retrievedReferences);

        /**
         * <p>
         * The retrieved references of the citation event.
         * </p>
         * 
         * @param retrievedReferences
         *        The retrieved references of the citation event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrievedReferences(RetrievedReference... retrievedReferences);

        /**
         * <p>
         * The retrieved references of the citation event.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievedReference.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievedReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievedReference.Builder#build()} is
         * called immediately and its result is passed to {@link #retrievedReferences(List<RetrievedReference>)}.
         * 
         * @param retrievedReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.RetrievedReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrievedReferences(java.util.Collection<RetrievedReference>)
         */
        Builder retrievedReferences(Consumer<RetrievedReference.Builder>... retrievedReferences);
    }

    protected static class BuilderImpl implements Builder {
        private Citation citation;

        private GeneratedResponsePart generatedResponsePart;

        private List<RetrievedReference> retrievedReferences = DefaultSdkAutoConstructList.getInstance();

        protected BuilderImpl() {
        }

        protected BuilderImpl(CitationEvent model) {
            citation(model.citation);
            generatedResponsePart(model.generatedResponsePart);
            retrievedReferences(model.retrievedReferences);
        }

        @Deprecated
        public final Citation.Builder getCitation() {
            return citation != null ? citation.toBuilder() : null;
        }

        @Deprecated
        public final void setCitation(Citation.BuilderImpl citation) {
            this.citation = citation != null ? citation.build() : null;
        }

        @Override
        @Deprecated
        public final Builder citation(Citation citation) {
            this.citation = citation;
            return this;
        }

        public final GeneratedResponsePart.Builder getGeneratedResponsePart() {
            return generatedResponsePart != null ? generatedResponsePart.toBuilder() : null;
        }

        public final void setGeneratedResponsePart(GeneratedResponsePart.BuilderImpl generatedResponsePart) {
            this.generatedResponsePart = generatedResponsePart != null ? generatedResponsePart.build() : null;
        }

        @Override
        public final Builder generatedResponsePart(GeneratedResponsePart generatedResponsePart) {
            this.generatedResponsePart = generatedResponsePart;
            return this;
        }

        public final List<RetrievedReference.Builder> getRetrievedReferences() {
            List<RetrievedReference.Builder> result = RetrievedReferencesCopier.copyToBuilder(this.retrievedReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRetrievedReferences(Collection<RetrievedReference.BuilderImpl> retrievedReferences) {
            this.retrievedReferences = RetrievedReferencesCopier.copyFromBuilder(retrievedReferences);
        }

        @Override
        public final Builder retrievedReferences(Collection<RetrievedReference> retrievedReferences) {
            this.retrievedReferences = RetrievedReferencesCopier.copy(retrievedReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievedReferences(RetrievedReference... retrievedReferences) {
            retrievedReferences(Arrays.asList(retrievedReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievedReferences(Consumer<RetrievedReference.Builder>... retrievedReferences) {
            retrievedReferences(Stream.of(retrievedReferences).map(c -> RetrievedReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CitationEvent build() {
            return new CitationEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
