/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the body of the API response.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * In the <code>returnControlInvocationResults</code> field of the <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_RequestSyntax"
 * >InvokeAgent request</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentBody implements SdkPojo, Serializable, ToCopyableBuilder<ContentBody.Builder, ContentBody> {
    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("body")
            .getter(getter(ContentBody::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()).build();

    private static final SdkField<List<ImageInput>> IMAGES_FIELD = SdkField
            .<List<ImageInput>> builder(MarshallingType.LIST)
            .memberName("images")
            .getter(getter(ContentBody::images))
            .setter(setter(Builder::images))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("images").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, IMAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String body;

    private final List<ImageInput> images;

    private ContentBody(BuilderImpl builder) {
        this.body = builder.body;
        this.images = builder.images;
    }

    /**
     * <p>
     * The body of the API response.
     * </p>
     * 
     * @return The body of the API response.
     */
    public final String body() {
        return body;
    }

    /**
     * For responses, this returns true if the service returned a value for the Images property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImages() {
        return images != null && !(images instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists details, including format and source, for the image in the response from the function call. You can specify
     * only one image and the function in the <code>returnControlInvocationResults</code> must be a computer use action.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agent-computer-use.html">Configure an Amazon Bedrock
     * Agent to complete tasks with computer use tools</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImages} method.
     * </p>
     * 
     * @return Lists details, including format and source, for the image in the response from the function call. You can
     *         specify only one image and the function in the <code>returnControlInvocationResults</code> must be a
     *         computer use action. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agent-computer-use.html">Configure an Amazon
     *         Bedrock Agent to complete tasks with computer use tools</a>.
     */
    public final List<ImageInput> images() {
        return images;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(hasImages() ? images() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentBody)) {
            return false;
        }
        ContentBody other = (ContentBody) obj;
        return Objects.equals(body(), other.body()) && hasImages() == other.hasImages()
                && Objects.equals(images(), other.images());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentBody").add("Body", body()).add("Images", hasImages() ? images() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "images":
            return Optional.ofNullable(clazz.cast(images()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("body", BODY_FIELD);
        map.put("images", IMAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentBody, T> g) {
        return obj -> g.apply((ContentBody) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentBody> {
        /**
         * <p>
         * The body of the API response.
         * </p>
         * 
         * @param body
         *        The body of the API response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * Lists details, including format and source, for the image in the response from the function call. You can
         * specify only one image and the function in the <code>returnControlInvocationResults</code> must be a computer
         * use action. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agent-computer-use.html">Configure an Amazon
         * Bedrock Agent to complete tasks with computer use tools</a>.
         * </p>
         * 
         * @param images
         *        Lists details, including format and source, for the image in the response from the function call. You
         *        can specify only one image and the function in the <code>returnControlInvocationResults</code> must be
         *        a computer use action. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agent-computer-use.html">Configure an
         *        Amazon Bedrock Agent to complete tasks with computer use tools</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(Collection<ImageInput> images);

        /**
         * <p>
         * Lists details, including format and source, for the image in the response from the function call. You can
         * specify only one image and the function in the <code>returnControlInvocationResults</code> must be a computer
         * use action. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agent-computer-use.html">Configure an Amazon
         * Bedrock Agent to complete tasks with computer use tools</a>.
         * </p>
         * 
         * @param images
         *        Lists details, including format and source, for the image in the response from the function call. You
         *        can specify only one image and the function in the <code>returnControlInvocationResults</code> must be
         *        a computer use action. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agent-computer-use.html">Configure an
         *        Amazon Bedrock Agent to complete tasks with computer use tools</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(ImageInput... images);

        /**
         * <p>
         * Lists details, including format and source, for the image in the response from the function call. You can
         * specify only one image and the function in the <code>returnControlInvocationResults</code> must be a computer
         * use action. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agent-computer-use.html">Configure an Amazon
         * Bedrock Agent to complete tasks with computer use tools</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.ImageInput.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.ImageInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.ImageInput.Builder#build()} is called
         * immediately and its result is passed to {@link #images(List<ImageInput>)}.
         * 
         * @param images
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ImageInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #images(java.util.Collection<ImageInput>)
         */
        Builder images(Consumer<ImageInput.Builder>... images);
    }

    static final class BuilderImpl implements Builder {
        private String body;

        private List<ImageInput> images = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContentBody model) {
            body(model.body);
            images(model.images);
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final List<ImageInput.Builder> getImages() {
            List<ImageInput.Builder> result = ImageInputsCopier.copyToBuilder(this.images);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImages(Collection<ImageInput.BuilderImpl> images) {
            this.images = ImageInputsCopier.copyFromBuilder(images);
        }

        @Override
        public final Builder images(Collection<ImageInput> images) {
            this.images = ImageInputsCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(ImageInput... images) {
            images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<ImageInput.Builder>... images) {
            images(Stream.of(images).map(c -> ImageInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ContentBody build() {
            return new ContentBody(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
