/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Performance settings for a model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PerformanceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PerformanceConfiguration.Builder, PerformanceConfiguration> {
    private static final SdkField<String> LATENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("latency")
            .getter(getter(PerformanceConfiguration::latencyAsString)).setter(setter(Builder::latency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latency").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATENCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String latency;

    private PerformanceConfiguration(BuilderImpl builder) {
        this.latency = builder.latency;
    }

    /**
     * <p>
     * To use a latency-optimized version of the model, set to <code>optimized</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latency} will
     * return {@link PerformanceConfigLatency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #latencyAsString}.
     * </p>
     * 
     * @return To use a latency-optimized version of the model, set to <code>optimized</code>.
     * @see PerformanceConfigLatency
     */
    public final PerformanceConfigLatency latency() {
        return PerformanceConfigLatency.fromValue(latency);
    }

    /**
     * <p>
     * To use a latency-optimized version of the model, set to <code>optimized</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #latency} will
     * return {@link PerformanceConfigLatency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #latencyAsString}.
     * </p>
     * 
     * @return To use a latency-optimized version of the model, set to <code>optimized</code>.
     * @see PerformanceConfigLatency
     */
    public final String latencyAsString() {
        return latency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(latencyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceConfiguration)) {
            return false;
        }
        PerformanceConfiguration other = (PerformanceConfiguration) obj;
        return Objects.equals(latencyAsString(), other.latencyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PerformanceConfiguration").add("Latency", latencyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "latency":
            return Optional.ofNullable(clazz.cast(latencyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("latency", LATENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PerformanceConfiguration, T> g) {
        return obj -> g.apply((PerformanceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PerformanceConfiguration> {
        /**
         * <p>
         * To use a latency-optimized version of the model, set to <code>optimized</code>.
         * </p>
         * 
         * @param latency
         *        To use a latency-optimized version of the model, set to <code>optimized</code>.
         * @see PerformanceConfigLatency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerformanceConfigLatency
         */
        Builder latency(String latency);

        /**
         * <p>
         * To use a latency-optimized version of the model, set to <code>optimized</code>.
         * </p>
         * 
         * @param latency
         *        To use a latency-optimized version of the model, set to <code>optimized</code>.
         * @see PerformanceConfigLatency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerformanceConfigLatency
         */
        Builder latency(PerformanceConfigLatency latency);
    }

    static final class BuilderImpl implements Builder {
        private String latency;

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceConfiguration model) {
            latency(model.latency);
        }

        public final String getLatency() {
            return latency;
        }

        public final void setLatency(String latency) {
            this.latency = latency;
        }

        @Override
        public final Builder latency(String latency) {
            this.latency = latency;
            return this;
        }

        @Override
        public final Builder latency(PerformanceConfigLatency latency) {
            this.latency(latency == null ? null : latency.toString());
            return this;
        }

        @Override
        public PerformanceConfiguration build() {
            return new PerformanceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
