/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a source for reranking.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RerankSource implements SdkPojo, Serializable, ToCopyableBuilder<RerankSource.Builder, RerankSource> {
    private static final SdkField<RerankDocument> INLINE_DOCUMENT_SOURCE_FIELD = SdkField
            .<RerankDocument> builder(MarshallingType.SDK_POJO).memberName("inlineDocumentSource")
            .getter(getter(RerankSource::inlineDocumentSource)).setter(setter(Builder::inlineDocumentSource))
            .constructor(RerankDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineDocumentSource").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RerankSource::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_DOCUMENT_SOURCE_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RerankDocument inlineDocumentSource;

    private final String type;

    private RerankSource(BuilderImpl builder) {
        this.inlineDocumentSource = builder.inlineDocumentSource;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains an inline definition of a source for reranking.
     * </p>
     * 
     * @return Contains an inline definition of a source for reranking.
     */
    public final RerankDocument inlineDocumentSource() {
        return inlineDocumentSource;
    }

    /**
     * <p>
     * The type of the source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RerankSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the source.
     * @see RerankSourceType
     */
    public final RerankSourceType type() {
        return RerankSourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RerankSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the source.
     * @see RerankSourceType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inlineDocumentSource());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RerankSource)) {
            return false;
        }
        RerankSource other = (RerankSource) obj;
        return Objects.equals(inlineDocumentSource(), other.inlineDocumentSource())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RerankSource")
                .add("InlineDocumentSource", inlineDocumentSource() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inlineDocumentSource":
            return Optional.ofNullable(clazz.cast(inlineDocumentSource()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inlineDocumentSource", INLINE_DOCUMENT_SOURCE_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RerankSource, T> g) {
        return obj -> g.apply((RerankSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RerankSource> {
        /**
         * <p>
         * Contains an inline definition of a source for reranking.
         * </p>
         * 
         * @param inlineDocumentSource
         *        Contains an inline definition of a source for reranking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineDocumentSource(RerankDocument inlineDocumentSource);

        /**
         * <p>
         * Contains an inline definition of a source for reranking.
         * </p>
         * This is a convenience method that creates an instance of the {@link RerankDocument.Builder} avoiding the need
         * to create one manually via {@link RerankDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RerankDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #inlineDocumentSource(RerankDocument)}.
         * 
         * @param inlineDocumentSource
         *        a consumer that will call methods on {@link RerankDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inlineDocumentSource(RerankDocument)
         */
        default Builder inlineDocumentSource(Consumer<RerankDocument.Builder> inlineDocumentSource) {
            return inlineDocumentSource(RerankDocument.builder().applyMutation(inlineDocumentSource).build());
        }

        /**
         * <p>
         * The type of the source.
         * </p>
         * 
         * @param type
         *        The type of the source.
         * @see RerankSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RerankSourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the source.
         * </p>
         * 
         * @param type
         *        The type of the source.
         * @see RerankSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RerankSourceType
         */
        Builder type(RerankSourceType type);
    }

    static final class BuilderImpl implements Builder {
        private RerankDocument inlineDocumentSource;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RerankSource model) {
            inlineDocumentSource(model.inlineDocumentSource);
            type(model.type);
        }

        public final RerankDocument.Builder getInlineDocumentSource() {
            return inlineDocumentSource != null ? inlineDocumentSource.toBuilder() : null;
        }

        public final void setInlineDocumentSource(RerankDocument.BuilderImpl inlineDocumentSource) {
            this.inlineDocumentSource = inlineDocumentSource != null ? inlineDocumentSource.build() : null;
        }

        @Override
        public final Builder inlineDocumentSource(RerankDocument inlineDocumentSource) {
            this.inlineDocumentSource = inlineDocumentSource;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RerankSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public RerankSource build() {
            return new RerankSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
