/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configurations for streaming.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingConfigurations.Builder, StreamingConfigurations> {
    private static final SdkField<Integer> APPLY_GUARDRAIL_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("applyGuardrailInterval").getter(getter(StreamingConfigurations::applyGuardrailInterval))
            .setter(setter(Builder::applyGuardrailInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyGuardrailInterval").build())
            .build();

    private static final SdkField<Boolean> STREAM_FINAL_RESPONSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("streamFinalResponse").getter(getter(StreamingConfigurations::streamFinalResponse))
            .setter(setter(Builder::streamFinalResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamFinalResponse").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLY_GUARDRAIL_INTERVAL_FIELD, STREAM_FINAL_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer applyGuardrailInterval;

    private final Boolean streamFinalResponse;

    private StreamingConfigurations(BuilderImpl builder) {
        this.applyGuardrailInterval = builder.applyGuardrailInterval;
        this.streamFinalResponse = builder.streamFinalResponse;
    }

    /**
     * <p>
     * The guardrail interval to apply as response is generated.
     * </p>
     * 
     * @return The guardrail interval to apply as response is generated.
     */
    public final Integer applyGuardrailInterval() {
        return applyGuardrailInterval;
    }

    /**
     * <p>
     * Specifies whether to enable streaming for the final response. This is set to <code>false</code> by default.
     * </p>
     * 
     * @return Specifies whether to enable streaming for the final response. This is set to <code>false</code> by
     *         default.
     */
    public final Boolean streamFinalResponse() {
        return streamFinalResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applyGuardrailInterval());
        hashCode = 31 * hashCode + Objects.hashCode(streamFinalResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingConfigurations)) {
            return false;
        }
        StreamingConfigurations other = (StreamingConfigurations) obj;
        return Objects.equals(applyGuardrailInterval(), other.applyGuardrailInterval())
                && Objects.equals(streamFinalResponse(), other.streamFinalResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamingConfigurations").add("ApplyGuardrailInterval", applyGuardrailInterval())
                .add("StreamFinalResponse", streamFinalResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applyGuardrailInterval":
            return Optional.ofNullable(clazz.cast(applyGuardrailInterval()));
        case "streamFinalResponse":
            return Optional.ofNullable(clazz.cast(streamFinalResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applyGuardrailInterval", APPLY_GUARDRAIL_INTERVAL_FIELD);
        map.put("streamFinalResponse", STREAM_FINAL_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamingConfigurations, T> g) {
        return obj -> g.apply((StreamingConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingConfigurations> {
        /**
         * <p>
         * The guardrail interval to apply as response is generated.
         * </p>
         * 
         * @param applyGuardrailInterval
         *        The guardrail interval to apply as response is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyGuardrailInterval(Integer applyGuardrailInterval);

        /**
         * <p>
         * Specifies whether to enable streaming for the final response. This is set to <code>false</code> by default.
         * </p>
         * 
         * @param streamFinalResponse
         *        Specifies whether to enable streaming for the final response. This is set to <code>false</code> by
         *        default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamFinalResponse(Boolean streamFinalResponse);
    }

    static final class BuilderImpl implements Builder {
        private Integer applyGuardrailInterval;

        private Boolean streamFinalResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingConfigurations model) {
            applyGuardrailInterval(model.applyGuardrailInterval);
            streamFinalResponse(model.streamFinalResponse);
        }

        public final Integer getApplyGuardrailInterval() {
            return applyGuardrailInterval;
        }

        public final void setApplyGuardrailInterval(Integer applyGuardrailInterval) {
            this.applyGuardrailInterval = applyGuardrailInterval;
        }

        @Override
        public final Builder applyGuardrailInterval(Integer applyGuardrailInterval) {
            this.applyGuardrailInterval = applyGuardrailInterval;
            return this;
        }

        public final Boolean getStreamFinalResponse() {
            return streamFinalResponse;
        }

        public final void setStreamFinalResponse(Boolean streamFinalResponse) {
            this.streamFinalResponse = streamFinalResponse;
        }

        @Override
        public final Builder streamFinalResponse(Boolean streamFinalResponse) {
            this.streamFinalResponse = streamFinalResponse;
            return this;
        }

        @Override
        public StreamingConfigurations build() {
            return new StreamingConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
