/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information of the usage of the foundation model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Usage implements SdkPojo, Serializable, ToCopyableBuilder<Usage.Builder, Usage> {
    private static final SdkField<Integer> INPUT_TOKENS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("inputTokens").getter(getter(Usage::inputTokens)).setter(setter(Builder::inputTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputTokens").build()).build();

    private static final SdkField<Integer> OUTPUT_TOKENS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("outputTokens").getter(getter(Usage::outputTokens)).setter(setter(Builder::outputTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputTokens").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_TOKENS_FIELD,
            OUTPUT_TOKENS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer inputTokens;

    private final Integer outputTokens;

    private Usage(BuilderImpl builder) {
        this.inputTokens = builder.inputTokens;
        this.outputTokens = builder.outputTokens;
    }

    /**
     * <p>
     * Contains information about the input tokens from the foundation model usage.
     * </p>
     * 
     * @return Contains information about the input tokens from the foundation model usage.
     */
    public final Integer inputTokens() {
        return inputTokens;
    }

    /**
     * <p>
     * Contains information about the output tokens from the foundation model usage.
     * </p>
     * 
     * @return Contains information about the output tokens from the foundation model usage.
     */
    public final Integer outputTokens() {
        return outputTokens;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputTokens());
        hashCode = 31 * hashCode + Objects.hashCode(outputTokens());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Usage)) {
            return false;
        }
        Usage other = (Usage) obj;
        return Objects.equals(inputTokens(), other.inputTokens()) && Objects.equals(outputTokens(), other.outputTokens());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Usage").add("InputTokens", inputTokens()).add("OutputTokens", outputTokens()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputTokens":
            return Optional.ofNullable(clazz.cast(inputTokens()));
        case "outputTokens":
            return Optional.ofNullable(clazz.cast(outputTokens()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputTokens", INPUT_TOKENS_FIELD);
        map.put("outputTokens", OUTPUT_TOKENS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Usage, T> g) {
        return obj -> g.apply((Usage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Usage> {
        /**
         * <p>
         * Contains information about the input tokens from the foundation model usage.
         * </p>
         * 
         * @param inputTokens
         *        Contains information about the input tokens from the foundation model usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputTokens(Integer inputTokens);

        /**
         * <p>
         * Contains information about the output tokens from the foundation model usage.
         * </p>
         * 
         * @param outputTokens
         *        Contains information about the output tokens from the foundation model usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputTokens(Integer outputTokens);
    }

    static final class BuilderImpl implements Builder {
        private Integer inputTokens;

        private Integer outputTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(Usage model) {
            inputTokens(model.inputTokens);
            outputTokens(model.outputTokens);
        }

        public final Integer getInputTokens() {
            return inputTokens;
        }

        public final void setInputTokens(Integer inputTokens) {
            this.inputTokens = inputTokens;
        }

        @Override
        public final Builder inputTokens(Integer inputTokens) {
            this.inputTokens = inputTokens;
            return this;
        }

        public final Integer getOutputTokens() {
            return outputTokens;
        }

        public final void setOutputTokens(Integer outputTokens) {
            this.outputTokens = outputTokens;
        }

        @Override
        public final Builder outputTokens(Integer outputTokens) {
            this.outputTokens = outputTokens;
            return this;
        }

        @Override
        public Usage build() {
            return new Usage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
