/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model.inlineagentresponsestream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockagentruntime.model.InlineAgentResponseStream;
import software.amazon.awssdk.services.bedrockagentruntime.model.InlineAgentReturnControlPayload;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvokeInlineAgentResponseHandler;

/**
 * A specialization of {@code software.amazon.awssdk.services.bedrockagentruntime.model.InlineAgentReturnControlPayload}
 * that represents the {@code InlineAgentResponseStream$returnControl} event. Do not use this class directly. Instead,
 * use the static builder methods on
 * {@link software.amazon.awssdk.services.bedrockagentruntime.model.InlineAgentResponseStream}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultReturnControl extends InlineAgentReturnControlPayload {
    private static final long serialVersionUID = 1L;

    DefaultReturnControl(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(InvokeInlineAgentResponseHandler.Visitor visitor) {
        visitor.visitReturnControl(this);
    }

    @Override
    public InlineAgentResponseStream.EventType sdkEventType() {
        return InlineAgentResponseStream.EventType.RETURN_CONTROL;
    }

    public interface Builder extends InlineAgentReturnControlPayload.Builder {
        @Override
        DefaultReturnControl build();
    }

    private static final class BuilderImpl extends InlineAgentReturnControlPayload.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultReturnControl event) {
            super(event);
        }

        @Override
        public DefaultReturnControl build() {
            return new DefaultReturnControl(this);
        }
    }
}
