/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model.optimizedpromptstream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockagentruntime.model.AnalyzePromptEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.OptimizePromptResponseHandler;
import software.amazon.awssdk.services.bedrockagentruntime.model.OptimizedPromptStream;

/**
 * A specialization of {@code software.amazon.awssdk.services.bedrockagentruntime.model.AnalyzePromptEvent} that
 * represents the {@code OptimizedPromptStream$analyzePromptEvent} event. Do not use this class directly. Instead, use
 * the static builder methods on {@link software.amazon.awssdk.services.bedrockagentruntime.model.OptimizedPromptStream}
 * .
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultAnalyzePromptEvent extends AnalyzePromptEvent {
    private static final long serialVersionUID = 1L;

    DefaultAnalyzePromptEvent(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(OptimizePromptResponseHandler.Visitor visitor) {
        visitor.visitAnalyzePromptEvent(this);
    }

    @Override
    public OptimizedPromptStream.EventType sdkEventType() {
        return OptimizedPromptStream.EventType.ANALYZE_PROMPT_EVENT;
    }

    public interface Builder extends AnalyzePromptEvent.Builder {
        @Override
        DefaultAnalyzePromptEvent build();
    }

    private static final class BuilderImpl extends AnalyzePromptEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultAnalyzePromptEvent event) {
            super(event);
        }

        @Override
        public DefaultAnalyzePromptEvent build() {
            return new DefaultAnalyzePromptEvent(this);
        }
    }
}
