/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a field in the input into a node. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html">Track each step in your prompt flow by
 * viewing its trace in Amazon Bedrock</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowTraceNodeInputField implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowTraceNodeInputField.Builder, FlowTraceNodeInputField> {
    private static final SdkField<FlowTraceNodeInputContent> CONTENT_FIELD = SdkField
            .<FlowTraceNodeInputContent> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(FlowTraceNodeInputField::content)).setter(setter(Builder::content))
            .constructor(FlowTraceNodeInputContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> NODE_INPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeInputName").getter(getter(FlowTraceNodeInputField::nodeInputName))
            .setter(setter(Builder::nodeInputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInputName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            NODE_INPUT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FlowTraceNodeInputContent content;

    private final String nodeInputName;

    private FlowTraceNodeInputField(BuilderImpl builder) {
        this.content = builder.content;
        this.nodeInputName = builder.nodeInputName;
    }

    /**
     * <p>
     * The content of the node input.
     * </p>
     * 
     * @return The content of the node input.
     */
    public final FlowTraceNodeInputContent content() {
        return content;
    }

    /**
     * <p>
     * The name of the node input.
     * </p>
     * 
     * @return The name of the node input.
     */
    public final String nodeInputName() {
        return nodeInputName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(nodeInputName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTraceNodeInputField)) {
            return false;
        }
        FlowTraceNodeInputField other = (FlowTraceNodeInputField) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(nodeInputName(), other.nodeInputName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowTraceNodeInputField")
                .add("Content", content() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NodeInputName", nodeInputName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "nodeInputName":
            return Optional.ofNullable(clazz.cast(nodeInputName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("nodeInputName", NODE_INPUT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTraceNodeInputField, T> g) {
        return obj -> g.apply((FlowTraceNodeInputField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowTraceNodeInputField> {
        /**
         * <p>
         * The content of the node input.
         * </p>
         * 
         * @param content
         *        The content of the node input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(FlowTraceNodeInputContent content);

        /**
         * <p>
         * The content of the node input.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowTraceNodeInputContent.Builder}
         * avoiding the need to create one manually via {@link FlowTraceNodeInputContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowTraceNodeInputContent.Builder#build()} is called immediately
         * and its result is passed to {@link #content(FlowTraceNodeInputContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link FlowTraceNodeInputContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(FlowTraceNodeInputContent)
         */
        default Builder content(Consumer<FlowTraceNodeInputContent.Builder> content) {
            return content(FlowTraceNodeInputContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The name of the node input.
         * </p>
         * 
         * @param nodeInputName
         *        The name of the node input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInputName(String nodeInputName);
    }

    static final class BuilderImpl implements Builder {
        private FlowTraceNodeInputContent content;

        private String nodeInputName;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTraceNodeInputField model) {
            content(model.content);
            nodeInputName(model.nodeInputName);
        }

        public final FlowTraceNodeInputContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(FlowTraceNodeInputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(FlowTraceNodeInputContent content) {
            this.content = content;
            return this;
        }

        public final String getNodeInputName() {
            return nodeInputName;
        }

        public final void setNodeInputName(String nodeInputName) {
            this.nodeInputName = nodeInputName;
        }

        @Override
        public final Builder nodeInputName(String nodeInputName) {
            this.nodeInputName = nodeInputName;
            return this;
        }

        @Override
        public FlowTraceNodeInputField build() {
            return new FlowTraceNodeInputField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
