/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the API operation or function that the agent predicts should be called.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * In the <code>returnControl</code> field of the <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax"
 * >InvokeAgent response</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvocationInputMember implements SdkPojo, Serializable,
        ToCopyableBuilder<InvocationInputMember.Builder, InvocationInputMember> {
    private static final SdkField<ApiInvocationInput> API_INVOCATION_INPUT_FIELD = SdkField
            .<ApiInvocationInput> builder(MarshallingType.SDK_POJO).memberName("apiInvocationInput")
            .getter(getter(InvocationInputMember::apiInvocationInput)).setter(setter(Builder::apiInvocationInput))
            .constructor(ApiInvocationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiInvocationInput").build())
            .build();

    private static final SdkField<FunctionInvocationInput> FUNCTION_INVOCATION_INPUT_FIELD = SdkField
            .<FunctionInvocationInput> builder(MarshallingType.SDK_POJO).memberName("functionInvocationInput")
            .getter(getter(InvocationInputMember::functionInvocationInput)).setter(setter(Builder::functionInvocationInput))
            .constructor(FunctionInvocationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionInvocationInput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_INVOCATION_INPUT_FIELD,
            FUNCTION_INVOCATION_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ApiInvocationInput apiInvocationInput;

    private final FunctionInvocationInput functionInvocationInput;

    private final Type type;

    private InvocationInputMember(BuilderImpl builder) {
        this.apiInvocationInput = builder.apiInvocationInput;
        this.functionInvocationInput = builder.functionInvocationInput;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains information about the API operation that the agent predicts should be called.
     * </p>
     * 
     * @return Contains information about the API operation that the agent predicts should be called.
     */
    public final ApiInvocationInput apiInvocationInput() {
        return apiInvocationInput;
    }

    /**
     * <p>
     * Contains information about the function that the agent predicts should be called.
     * </p>
     * 
     * @return Contains information about the function that the agent predicts should be called.
     */
    public final FunctionInvocationInput functionInvocationInput() {
        return functionInvocationInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiInvocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(functionInvocationInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationInputMember)) {
            return false;
        }
        InvocationInputMember other = (InvocationInputMember) obj;
        return Objects.equals(apiInvocationInput(), other.apiInvocationInput())
                && Objects.equals(functionInvocationInput(), other.functionInvocationInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvocationInputMember").add("ApiInvocationInput", apiInvocationInput())
                .add("FunctionInvocationInput", functionInvocationInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiInvocationInput":
            return Optional.ofNullable(clazz.cast(apiInvocationInput()));
        case "functionInvocationInput":
            return Optional.ofNullable(clazz.cast(functionInvocationInput()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #apiInvocationInput()} initialized to the given value.
     *
     * <p>
     * Contains information about the API operation that the agent predicts should be called.
     * </p>
     * 
     * @param apiInvocationInput
     *        Contains information about the API operation that the agent predicts should be called.
     */
    public static InvocationInputMember fromApiInvocationInput(ApiInvocationInput apiInvocationInput) {
        return builder().apiInvocationInput(apiInvocationInput).build();
    }

    /**
     * Create an instance of this class with {@link #apiInvocationInput()} initialized to the given value.
     *
     * <p>
     * Contains information about the API operation that the agent predicts should be called.
     * </p>
     * 
     * @param apiInvocationInput
     *        Contains information about the API operation that the agent predicts should be called.
     */
    public static InvocationInputMember fromApiInvocationInput(Consumer<ApiInvocationInput.Builder> apiInvocationInput) {
        ApiInvocationInput.Builder builder = ApiInvocationInput.builder();
        apiInvocationInput.accept(builder);
        return fromApiInvocationInput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #functionInvocationInput()} initialized to the given value.
     *
     * <p>
     * Contains information about the function that the agent predicts should be called.
     * </p>
     * 
     * @param functionInvocationInput
     *        Contains information about the function that the agent predicts should be called.
     */
    public static InvocationInputMember fromFunctionInvocationInput(FunctionInvocationInput functionInvocationInput) {
        return builder().functionInvocationInput(functionInvocationInput).build();
    }

    /**
     * Create an instance of this class with {@link #functionInvocationInput()} initialized to the given value.
     *
     * <p>
     * Contains information about the function that the agent predicts should be called.
     * </p>
     * 
     * @param functionInvocationInput
     *        Contains information about the function that the agent predicts should be called.
     */
    public static InvocationInputMember fromFunctionInvocationInput(
            Consumer<FunctionInvocationInput.Builder> functionInvocationInput) {
        FunctionInvocationInput.Builder builder = FunctionInvocationInput.builder();
        functionInvocationInput.accept(builder);
        return fromFunctionInvocationInput(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("apiInvocationInput", API_INVOCATION_INPUT_FIELD);
        map.put("functionInvocationInput", FUNCTION_INVOCATION_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvocationInputMember, T> g) {
        return obj -> g.apply((InvocationInputMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvocationInputMember> {
        /**
         * <p>
         * Contains information about the API operation that the agent predicts should be called.
         * </p>
         * 
         * @param apiInvocationInput
         *        Contains information about the API operation that the agent predicts should be called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiInvocationInput(ApiInvocationInput apiInvocationInput);

        /**
         * <p>
         * Contains information about the API operation that the agent predicts should be called.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApiInvocationInput.Builder} avoiding the
         * need to create one manually via {@link ApiInvocationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApiInvocationInput.Builder#build()} is called immediately and its
         * result is passed to {@link #apiInvocationInput(ApiInvocationInput)}.
         * 
         * @param apiInvocationInput
         *        a consumer that will call methods on {@link ApiInvocationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiInvocationInput(ApiInvocationInput)
         */
        default Builder apiInvocationInput(Consumer<ApiInvocationInput.Builder> apiInvocationInput) {
            return apiInvocationInput(ApiInvocationInput.builder().applyMutation(apiInvocationInput).build());
        }

        /**
         * <p>
         * Contains information about the function that the agent predicts should be called.
         * </p>
         * 
         * @param functionInvocationInput
         *        Contains information about the function that the agent predicts should be called.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionInvocationInput(FunctionInvocationInput functionInvocationInput);

        /**
         * <p>
         * Contains information about the function that the agent predicts should be called.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunctionInvocationInput.Builder} avoiding
         * the need to create one manually via {@link FunctionInvocationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionInvocationInput.Builder#build()} is called immediately
         * and its result is passed to {@link #functionInvocationInput(FunctionInvocationInput)}.
         * 
         * @param functionInvocationInput
         *        a consumer that will call methods on {@link FunctionInvocationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionInvocationInput(FunctionInvocationInput)
         */
        default Builder functionInvocationInput(Consumer<FunctionInvocationInput.Builder> functionInvocationInput) {
            return functionInvocationInput(FunctionInvocationInput.builder().applyMutation(functionInvocationInput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ApiInvocationInput apiInvocationInput;

        private FunctionInvocationInput functionInvocationInput;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(InvocationInputMember model) {
            apiInvocationInput(model.apiInvocationInput);
            functionInvocationInput(model.functionInvocationInput);
        }

        public final ApiInvocationInput.Builder getApiInvocationInput() {
            return apiInvocationInput != null ? apiInvocationInput.toBuilder() : null;
        }

        public final void setApiInvocationInput(ApiInvocationInput.BuilderImpl apiInvocationInput) {
            Object oldValue = this.apiInvocationInput;
            this.apiInvocationInput = apiInvocationInput != null ? apiInvocationInput.build() : null;
            handleUnionValueChange(Type.API_INVOCATION_INPUT, oldValue, this.apiInvocationInput);
        }

        @Override
        public final Builder apiInvocationInput(ApiInvocationInput apiInvocationInput) {
            Object oldValue = this.apiInvocationInput;
            this.apiInvocationInput = apiInvocationInput;
            handleUnionValueChange(Type.API_INVOCATION_INPUT, oldValue, this.apiInvocationInput);
            return this;
        }

        public final FunctionInvocationInput.Builder getFunctionInvocationInput() {
            return functionInvocationInput != null ? functionInvocationInput.toBuilder() : null;
        }

        public final void setFunctionInvocationInput(FunctionInvocationInput.BuilderImpl functionInvocationInput) {
            Object oldValue = this.functionInvocationInput;
            this.functionInvocationInput = functionInvocationInput != null ? functionInvocationInput.build() : null;
            handleUnionValueChange(Type.FUNCTION_INVOCATION_INPUT, oldValue, this.functionInvocationInput);
        }

        @Override
        public final Builder functionInvocationInput(FunctionInvocationInput functionInvocationInput) {
            Object oldValue = this.functionInvocationInput;
            this.functionInvocationInput = functionInvocationInput;
            handleUnionValueChange(Type.FUNCTION_INVOCATION_INPUT, oldValue, this.functionInvocationInput);
            return this;
        }

        @Override
        public InvocationInputMember build() {
            return new InvocationInputMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see InvocationInputMember#type()
     */
    public enum Type {
        API_INVOCATION_INPUT,

        FUNCTION_INVOCATION_INPUT,

        UNKNOWN_TO_SDK_VERSION
    }
}
