/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptimizePromptRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<OptimizePromptRequest.Builder, OptimizePromptRequest> {
    private static final SdkField<InputPrompt> INPUT_FIELD = SdkField.<InputPrompt> builder(MarshallingType.SDK_POJO)
            .memberName("input").getter(getter(OptimizePromptRequest::input)).setter(setter(Builder::input))
            .constructor(InputPrompt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> TARGET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetModelId").getter(getter(OptimizePromptRequest::targetModelId))
            .setter(setter(Builder::targetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetModelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD,
            TARGET_MODEL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final InputPrompt input;

    private final String targetModelId;

    private OptimizePromptRequest(BuilderImpl builder) {
        super(builder);
        this.input = builder.input;
        this.targetModelId = builder.targetModelId;
    }

    /**
     * <p>
     * Contains the prompt to optimize.
     * </p>
     * 
     * @return Contains the prompt to optimize.
     */
    public final InputPrompt input() {
        return input;
    }

    /**
     * <p>
     * The unique identifier of the model that you want to optimize the prompt for.
     * </p>
     * 
     * @return The unique identifier of the model that you want to optimize the prompt for.
     */
    public final String targetModelId() {
        return targetModelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(targetModelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizePromptRequest)) {
            return false;
        }
        OptimizePromptRequest other = (OptimizePromptRequest) obj;
        return Objects.equals(input(), other.input()) && Objects.equals(targetModelId(), other.targetModelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptimizePromptRequest").add("Input", input()).add("TargetModelId", targetModelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "targetModelId":
            return Optional.ofNullable(clazz.cast(targetModelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("input", INPUT_FIELD);
        map.put("targetModelId", TARGET_MODEL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizePromptRequest, T> g) {
        return obj -> g.apply((OptimizePromptRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, OptimizePromptRequest> {
        /**
         * <p>
         * Contains the prompt to optimize.
         * </p>
         * 
         * @param input
         *        Contains the prompt to optimize.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(InputPrompt input);

        /**
         * <p>
         * Contains the prompt to optimize.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputPrompt.Builder} avoiding the need to
         * create one manually via {@link InputPrompt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputPrompt.Builder#build()} is called immediately and its result
         * is passed to {@link #input(InputPrompt)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link InputPrompt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(InputPrompt)
         */
        default Builder input(Consumer<InputPrompt.Builder> input) {
            return input(InputPrompt.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * The unique identifier of the model that you want to optimize the prompt for.
         * </p>
         * 
         * @param targetModelId
         *        The unique identifier of the model that you want to optimize the prompt for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetModelId(String targetModelId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private InputPrompt input;

        private String targetModelId;

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizePromptRequest model) {
            super(model);
            input(model.input);
            targetModelId(model.targetModelId);
        }

        public final InputPrompt.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(InputPrompt.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(InputPrompt input) {
            this.input = input;
            return this;
        }

        public final String getTargetModelId() {
            return targetModelId;
        }

        public final void setTargetModelId(String targetModelId) {
            this.targetModelId = targetModelId;
        }

        @Override
        public final Builder targetModelId(String targetModelId) {
            this.targetModelId = targetModelId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public OptimizePromptRequest build() {
            return new OptimizePromptRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
