/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an output field produced by a node during a flow execution.
 * </p>
 * <note>
 * <p>
 * Flow executions is in preview release for Amazon Bedrock and is subject to change.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeOutputField implements SdkPojo, Serializable, ToCopyableBuilder<NodeOutputField.Builder, NodeOutputField> {
    private static final SdkField<NodeExecutionContent> CONTENT_FIELD = SdkField
            .<NodeExecutionContent> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(NodeOutputField::content)).setter(setter(Builder::content)).constructor(NodeExecutionContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(NodeOutputField::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NodeExecutionContent content;

    private final String name;

    private NodeOutputField(BuilderImpl builder) {
        this.content = builder.content;
        this.name = builder.name;
    }

    /**
     * <p>
     * The content of the output field, which can contain text or structured data.
     * </p>
     * 
     * @return The content of the output field, which can contain text or structured data.
     */
    public final NodeExecutionContent content() {
        return content;
    }

    /**
     * <p>
     * The name of the output field as defined in the node's output schema.
     * </p>
     * 
     * @return The name of the output field as defined in the node's output schema.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeOutputField)) {
            return false;
        }
        NodeOutputField other = (NodeOutputField) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeOutputField").add("Content", content() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeOutputField, T> g) {
        return obj -> g.apply((NodeOutputField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeOutputField> {
        /**
         * <p>
         * The content of the output field, which can contain text or structured data.
         * </p>
         * 
         * @param content
         *        The content of the output field, which can contain text or structured data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(NodeExecutionContent content);

        /**
         * <p>
         * The content of the output field, which can contain text or structured data.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeExecutionContent.Builder} avoiding
         * the need to create one manually via {@link NodeExecutionContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeExecutionContent.Builder#build()} is called immediately and
         * its result is passed to {@link #content(NodeExecutionContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link NodeExecutionContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(NodeExecutionContent)
         */
        default Builder content(Consumer<NodeExecutionContent.Builder> content) {
            return content(NodeExecutionContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The name of the output field as defined in the node's output schema.
         * </p>
         * 
         * @param name
         *        The name of the output field as defined in the node's output schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private NodeExecutionContent content;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeOutputField model) {
            content(model.content);
            name(model.name);
        }

        public final NodeExecutionContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(NodeExecutionContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(NodeExecutionContent content) {
            this.content = content;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public NodeOutputField build() {
            return new NodeOutputField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
