/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a document that was reranked.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RerankResult implements SdkPojo, Serializable, ToCopyableBuilder<RerankResult.Builder, RerankResult> {
    private static final SdkField<RerankDocument> DOCUMENT_FIELD = SdkField.<RerankDocument> builder(MarshallingType.SDK_POJO)
            .memberName("document").getter(getter(RerankResult::document)).setter(setter(Builder::document))
            .constructor(RerankDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final SdkField<Integer> INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("index")
            .getter(getter(RerankResult::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()).build();

    private static final SdkField<Float> RELEVANCE_SCORE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("relevanceScore").getter(getter(RerankResult::relevanceScore)).setter(setter(Builder::relevanceScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevanceScore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD, INDEX_FIELD,
            RELEVANCE_SCORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RerankDocument document;

    private final Integer index;

    private final Float relevanceScore;

    private RerankResult(BuilderImpl builder) {
        this.document = builder.document;
        this.index = builder.index;
        this.relevanceScore = builder.relevanceScore;
    }

    /**
     * <p>
     * Contains information about the document.
     * </p>
     * 
     * @return Contains information about the document.
     */
    public final RerankDocument document() {
        return document;
    }

    /**
     * <p>
     * The ranking of the document. The lower a number, the higher the document is ranked.
     * </p>
     * 
     * @return The ranking of the document. The lower a number, the higher the document is ranked.
     */
    public final Integer index() {
        return index;
    }

    /**
     * <p>
     * The relevance score of the document.
     * </p>
     * 
     * @return The relevance score of the document.
     */
    public final Float relevanceScore() {
        return relevanceScore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(relevanceScore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RerankResult)) {
            return false;
        }
        RerankResult other = (RerankResult) obj;
        return Objects.equals(document(), other.document()) && Objects.equals(index(), other.index())
                && Objects.equals(relevanceScore(), other.relevanceScore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RerankResult").add("Document", document() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Index", index()).add("RelevanceScore", relevanceScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        case "index":
            return Optional.ofNullable(clazz.cast(index()));
        case "relevanceScore":
            return Optional.ofNullable(clazz.cast(relevanceScore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("document", DOCUMENT_FIELD);
        map.put("index", INDEX_FIELD);
        map.put("relevanceScore", RELEVANCE_SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RerankResult, T> g) {
        return obj -> g.apply((RerankResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RerankResult> {
        /**
         * <p>
         * Contains information about the document.
         * </p>
         * 
         * @param document
         *        Contains information about the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(RerankDocument document);

        /**
         * <p>
         * Contains information about the document.
         * </p>
         * This is a convenience method that creates an instance of the {@link RerankDocument.Builder} avoiding the need
         * to create one manually via {@link RerankDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RerankDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #document(RerankDocument)}.
         * 
         * @param document
         *        a consumer that will call methods on {@link RerankDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #document(RerankDocument)
         */
        default Builder document(Consumer<RerankDocument.Builder> document) {
            return document(RerankDocument.builder().applyMutation(document).build());
        }

        /**
         * <p>
         * The ranking of the document. The lower a number, the higher the document is ranked.
         * </p>
         * 
         * @param index
         *        The ranking of the document. The lower a number, the higher the document is ranked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Integer index);

        /**
         * <p>
         * The relevance score of the document.
         * </p>
         * 
         * @param relevanceScore
         *        The relevance score of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relevanceScore(Float relevanceScore);
    }

    static final class BuilderImpl implements Builder {
        private RerankDocument document;

        private Integer index;

        private Float relevanceScore;

        private BuilderImpl() {
        }

        private BuilderImpl(RerankResult model) {
            document(model.document);
            index(model.index);
            relevanceScore(model.relevanceScore);
        }

        public final RerankDocument.Builder getDocument() {
            return document != null ? document.toBuilder() : null;
        }

        public final void setDocument(RerankDocument.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(RerankDocument document) {
            this.document = document;
            return this;
        }

        public final Integer getIndex() {
            return index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final Float getRelevanceScore() {
            return relevanceScore;
        }

        public final void setRelevanceScore(Float relevanceScore) {
            this.relevanceScore = relevanceScore;
        }

        @Override
        public final Builder relevanceScore(Float relevanceScore) {
            this.relevanceScore = relevanceScore;
            return this;
        }

        @Override
        public RerankResult build() {
            return new RerankResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
