/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSessionRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<UpdateSessionRequest.Builder, UpdateSessionRequest> {
    private static final SdkField<String> SESSION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionIdentifier").getter(getter(UpdateSessionRequest::sessionIdentifier))
            .setter(setter(Builder::sessionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionIdentifier").build()).build();

    private static final SdkField<Map<String, String>> SESSION_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sessionMetadata")
            .getter(getter(UpdateSessionRequest::sessionMetadata))
            .setter(setter(Builder::sessionMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_IDENTIFIER_FIELD,
            SESSION_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionIdentifier;

    private final Map<String, String> sessionMetadata;

    private UpdateSessionRequest(BuilderImpl builder) {
        super(builder);
        this.sessionIdentifier = builder.sessionIdentifier;
        this.sessionMetadata = builder.sessionMetadata;
    }

    /**
     * <p>
     * The unique identifier of the session to modify. You can specify either the session's <code>sessionId</code> or
     * its Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The unique identifier of the session to modify. You can specify either the session's
     *         <code>sessionId</code> or its Amazon Resource Name (ARN).
     */
    public final String sessionIdentifier() {
        return sessionIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the SessionMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSessionMetadata() {
        return sessionMetadata != null && !(sessionMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs containing attributes to be persisted across the session. For example the user's ID,
     * their language preference, and the type of device they are using.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionMetadata} method.
     * </p>
     * 
     * @return A map of key-value pairs containing attributes to be persisted across the session. For example the user's
     *         ID, their language preference, and the type of device they are using.
     */
    public final Map<String, String> sessionMetadata() {
        return sessionMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasSessionMetadata() ? sessionMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSessionRequest)) {
            return false;
        }
        UpdateSessionRequest other = (UpdateSessionRequest) obj;
        return Objects.equals(sessionIdentifier(), other.sessionIdentifier())
                && hasSessionMetadata() == other.hasSessionMetadata()
                && Objects.equals(sessionMetadata(), other.sessionMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSessionRequest").add("SessionIdentifier", sessionIdentifier())
                .add("SessionMetadata", hasSessionMetadata() ? sessionMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionIdentifier":
            return Optional.ofNullable(clazz.cast(sessionIdentifier()));
        case "sessionMetadata":
            return Optional.ofNullable(clazz.cast(sessionMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionIdentifier", SESSION_IDENTIFIER_FIELD);
        map.put("sessionMetadata", SESSION_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSessionRequest, T> g) {
        return obj -> g.apply((UpdateSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSessionRequest> {
        /**
         * <p>
         * The unique identifier of the session to modify. You can specify either the session's <code>sessionId</code>
         * or its Amazon Resource Name (ARN).
         * </p>
         * 
         * @param sessionIdentifier
         *        The unique identifier of the session to modify. You can specify either the session's
         *        <code>sessionId</code> or its Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionIdentifier(String sessionIdentifier);

        /**
         * <p>
         * A map of key-value pairs containing attributes to be persisted across the session. For example the user's ID,
         * their language preference, and the type of device they are using.
         * </p>
         * 
         * @param sessionMetadata
         *        A map of key-value pairs containing attributes to be persisted across the session. For example the
         *        user's ID, their language preference, and the type of device they are using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionMetadata(Map<String, String> sessionMetadata);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private String sessionIdentifier;

        private Map<String, String> sessionMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSessionRequest model) {
            super(model);
            sessionIdentifier(model.sessionIdentifier);
            sessionMetadata(model.sessionMetadata);
        }

        public final String getSessionIdentifier() {
            return sessionIdentifier;
        }

        public final void setSessionIdentifier(String sessionIdentifier) {
            this.sessionIdentifier = sessionIdentifier;
        }

        @Override
        public final Builder sessionIdentifier(String sessionIdentifier) {
            this.sessionIdentifier = sessionIdentifier;
            return this;
        }

        public final Map<String, String> getSessionMetadata() {
            if (sessionMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return sessionMetadata;
        }

        public final void setSessionMetadata(Map<String, String> sessionMetadata) {
            this.sessionMetadata = SessionMetadataMapCopier.copy(sessionMetadata);
        }

        @Override
        public final Builder sessionMetadata(Map<String, String> sessionMetadata) {
            this.sessionMetadata = SessionMetadataMapCopier.copy(sessionMetadata);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSessionRequest build() {
            return new UpdateSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
