/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for an agent collaborator. The input can be text or an action invocation result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentCollaboratorInputPayload implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentCollaboratorInputPayload.Builder, AgentCollaboratorInputPayload> {
    private static final SdkField<ReturnControlResults> RETURN_CONTROL_RESULTS_FIELD = SdkField
            .<ReturnControlResults> builder(MarshallingType.SDK_POJO).memberName("returnControlResults")
            .getter(getter(AgentCollaboratorInputPayload::returnControlResults)).setter(setter(Builder::returnControlResults))
            .constructor(ReturnControlResults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnControlResults").build())
            .build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(AgentCollaboratorInputPayload::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AgentCollaboratorInputPayload::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_CONTROL_RESULTS_FIELD,
            TEXT_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ReturnControlResults returnControlResults;

    private final String text;

    private final String type;

    private AgentCollaboratorInputPayload(BuilderImpl builder) {
        this.returnControlResults = builder.returnControlResults;
        this.text = builder.text;
        this.type = builder.type;
    }

    /**
     * <p>
     * An action invocation result.
     * </p>
     * 
     * @return An action invocation result.
     */
    public final ReturnControlResults returnControlResults() {
        return returnControlResults;
    }

    /**
     * <p>
     * Input text.
     * </p>
     * 
     * @return Input text.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The input type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The input type.
     * @see PayloadType
     */
    public final PayloadType type() {
        return PayloadType.fromValue(type);
    }

    /**
     * <p>
     * The input type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The input type.
     * @see PayloadType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(returnControlResults());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentCollaboratorInputPayload)) {
            return false;
        }
        AgentCollaboratorInputPayload other = (AgentCollaboratorInputPayload) obj;
        return Objects.equals(returnControlResults(), other.returnControlResults()) && Objects.equals(text(), other.text())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentCollaboratorInputPayload").add("ReturnControlResults", returnControlResults())
                .add("Text", text() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "returnControlResults":
            return Optional.ofNullable(clazz.cast(returnControlResults()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("returnControlResults", RETURN_CONTROL_RESULTS_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentCollaboratorInputPayload, T> g) {
        return obj -> g.apply((AgentCollaboratorInputPayload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentCollaboratorInputPayload> {
        /**
         * <p>
         * An action invocation result.
         * </p>
         * 
         * @param returnControlResults
         *        An action invocation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnControlResults(ReturnControlResults returnControlResults);

        /**
         * <p>
         * An action invocation result.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReturnControlResults.Builder} avoiding
         * the need to create one manually via {@link ReturnControlResults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReturnControlResults.Builder#build()} is called immediately and
         * its result is passed to {@link #returnControlResults(ReturnControlResults)}.
         * 
         * @param returnControlResults
         *        a consumer that will call methods on {@link ReturnControlResults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #returnControlResults(ReturnControlResults)
         */
        default Builder returnControlResults(Consumer<ReturnControlResults.Builder> returnControlResults) {
            return returnControlResults(ReturnControlResults.builder().applyMutation(returnControlResults).build());
        }

        /**
         * <p>
         * Input text.
         * </p>
         * 
         * @param text
         *        Input text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The input type.
         * </p>
         * 
         * @param type
         *        The input type.
         * @see PayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayloadType
         */
        Builder type(String type);

        /**
         * <p>
         * The input type.
         * </p>
         * 
         * @param type
         *        The input type.
         * @see PayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayloadType
         */
        Builder type(PayloadType type);
    }

    static final class BuilderImpl implements Builder {
        private ReturnControlResults returnControlResults;

        private String text;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentCollaboratorInputPayload model) {
            returnControlResults(model.returnControlResults);
            text(model.text);
            type(model.type);
        }

        public final ReturnControlResults.Builder getReturnControlResults() {
            return returnControlResults != null ? returnControlResults.toBuilder() : null;
        }

        public final void setReturnControlResults(ReturnControlResults.BuilderImpl returnControlResults) {
            this.returnControlResults = returnControlResults != null ? returnControlResults.build() : null;
        }

        @Override
        public final Builder returnControlResults(ReturnControlResults returnControlResults) {
            this.returnControlResults = returnControlResults;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PayloadType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public AgentCollaboratorInputPayload build() {
            return new AgentCollaboratorInputPayload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
