/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for response generation based on the knowledge base query results.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax"
 * >RetrieveAndGenerate request</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GenerationConfiguration.Builder, GenerationConfiguration> {
    private static final SdkField<Map<String, Document>> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField
            .<Map<String, Document>> builder(MarshallingType.MAP)
            .memberName("additionalModelRequestFields")
            .getter(getter(GenerationConfiguration::additionalModelRequestFields))
            .setter(setter(Builder::additionalModelRequestFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.DOCUMENT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<GuardrailConfiguration> GUARDRAIL_CONFIGURATION_FIELD = SdkField
            .<GuardrailConfiguration> builder(MarshallingType.SDK_POJO).memberName("guardrailConfiguration")
            .getter(getter(GenerationConfiguration::guardrailConfiguration)).setter(setter(Builder::guardrailConfiguration))
            .constructor(GuardrailConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build())
            .build();

    private static final SdkField<InferenceConfig> INFERENCE_CONFIG_FIELD = SdkField
            .<InferenceConfig> builder(MarshallingType.SDK_POJO).memberName("inferenceConfig")
            .getter(getter(GenerationConfiguration::inferenceConfig)).setter(setter(Builder::inferenceConfig))
            .constructor(InferenceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfig").build()).build();

    private static final SdkField<PerformanceConfiguration> PERFORMANCE_CONFIG_FIELD = SdkField
            .<PerformanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("performanceConfig")
            .getter(getter(GenerationConfiguration::performanceConfig)).setter(setter(Builder::performanceConfig))
            .constructor(PerformanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performanceConfig").build()).build();

    private static final SdkField<PromptTemplate> PROMPT_TEMPLATE_FIELD = SdkField
            .<PromptTemplate> builder(MarshallingType.SDK_POJO).memberName("promptTemplate")
            .getter(getter(GenerationConfiguration::promptTemplate)).setter(setter(Builder::promptTemplate))
            .constructor(PromptTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD, GUARDRAIL_CONFIGURATION_FIELD, INFERENCE_CONFIG_FIELD,
            PERFORMANCE_CONFIG_FIELD, PROMPT_TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, Document> additionalModelRequestFields;

    private final GuardrailConfiguration guardrailConfiguration;

    private final InferenceConfig inferenceConfig;

    private final PerformanceConfiguration performanceConfig;

    private final PromptTemplate promptTemplate;

    private GenerationConfiguration(BuilderImpl builder) {
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.inferenceConfig = builder.inferenceConfig;
        this.performanceConfig = builder.performanceConfig;
        this.promptTemplate = builder.promptTemplate;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalModelRequestFields property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalModelRequestFields() {
        return additionalModelRequestFields != null && !(additionalModelRequestFields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Additional model parameters and corresponding values not included in the textInferenceConfig structure for a
     * knowledge base. This allows users to provide custom model parameters specific to the language model being used.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalModelRequestFields} method.
     * </p>
     * 
     * @return Additional model parameters and corresponding values not included in the textInferenceConfig structure
     *         for a knowledge base. This allows users to provide custom model parameters specific to the language model
     *         being used.
     */
    public final Map<String, Document> additionalModelRequestFields() {
        return additionalModelRequestFields;
    }

    /**
     * <p>
     * The configuration details for the guardrail.
     * </p>
     * 
     * @return The configuration details for the guardrail.
     */
    public final GuardrailConfiguration guardrailConfiguration() {
        return guardrailConfiguration;
    }

    /**
     * <p>
     * Configuration settings for inference when using RetrieveAndGenerate to generate responses while using a knowledge
     * base as a source.
     * </p>
     * 
     * @return Configuration settings for inference when using RetrieveAndGenerate to generate responses while using a
     *         knowledge base as a source.
     */
    public final InferenceConfig inferenceConfig() {
        return inferenceConfig;
    }

    /**
     * <p>
     * The latency configuration for the model.
     * </p>
     * 
     * @return The latency configuration for the model.
     */
    public final PerformanceConfiguration performanceConfig() {
        return performanceConfig;
    }

    /**
     * <p>
     * Contains the template for the prompt that's sent to the model for response generation. Generation prompts must
     * include the <code>$search_results$</code> variable. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html">Use placeholder
     * variables</a> in the user guide.
     * </p>
     * 
     * @return Contains the template for the prompt that's sent to the model for response generation. Generation prompts
     *         must include the <code>$search_results$</code> variable. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html">Use placeholder
     *         variables</a> in the user guide.
     */
    public final PromptTemplate promptTemplate() {
        return promptTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalModelRequestFields() ? additionalModelRequestFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(performanceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(promptTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerationConfiguration)) {
            return false;
        }
        GenerationConfiguration other = (GenerationConfiguration) obj;
        return hasAdditionalModelRequestFields() == other.hasAdditionalModelRequestFields()
                && Objects.equals(additionalModelRequestFields(), other.additionalModelRequestFields())
                && Objects.equals(guardrailConfiguration(), other.guardrailConfiguration())
                && Objects.equals(inferenceConfig(), other.inferenceConfig())
                && Objects.equals(performanceConfig(), other.performanceConfig())
                && Objects.equals(promptTemplate(), other.promptTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerationConfiguration")
                .add("AdditionalModelRequestFields", hasAdditionalModelRequestFields() ? additionalModelRequestFields() : null)
                .add("GuardrailConfiguration", guardrailConfiguration()).add("InferenceConfig", inferenceConfig())
                .add("PerformanceConfig", performanceConfig()).add("PromptTemplate", promptTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalModelRequestFields":
            return Optional.ofNullable(clazz.cast(additionalModelRequestFields()));
        case "guardrailConfiguration":
            return Optional.ofNullable(clazz.cast(guardrailConfiguration()));
        case "inferenceConfig":
            return Optional.ofNullable(clazz.cast(inferenceConfig()));
        case "performanceConfig":
            return Optional.ofNullable(clazz.cast(performanceConfig()));
        case "promptTemplate":
            return Optional.ofNullable(clazz.cast(promptTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("additionalModelRequestFields", ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD);
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("inferenceConfig", INFERENCE_CONFIG_FIELD);
        map.put("performanceConfig", PERFORMANCE_CONFIG_FIELD);
        map.put("promptTemplate", PROMPT_TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerationConfiguration, T> g) {
        return obj -> g.apply((GenerationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GenerationConfiguration> {
        /**
         * <p>
         * Additional model parameters and corresponding values not included in the textInferenceConfig structure for a
         * knowledge base. This allows users to provide custom model parameters specific to the language model being
         * used.
         * </p>
         * 
         * @param additionalModelRequestFields
         *        Additional model parameters and corresponding values not included in the textInferenceConfig structure
         *        for a knowledge base. This allows users to provide custom model parameters specific to the language
         *        model being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalModelRequestFields(Map<String, Document> additionalModelRequestFields);

        /**
         * <p>
         * The configuration details for the guardrail.
         * </p>
         * 
         * @param guardrailConfiguration
         *        The configuration details for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration);

        /**
         * <p>
         * The configuration details for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailConfiguration.Builder} avoiding
         * the need to create one manually via {@link GuardrailConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #guardrailConfiguration(GuardrailConfiguration)}.
         * 
         * @param guardrailConfiguration
         *        a consumer that will call methods on {@link GuardrailConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardrailConfiguration(GuardrailConfiguration)
         */
        default Builder guardrailConfiguration(Consumer<GuardrailConfiguration.Builder> guardrailConfiguration) {
            return guardrailConfiguration(GuardrailConfiguration.builder().applyMutation(guardrailConfiguration).build());
        }

        /**
         * <p>
         * Configuration settings for inference when using RetrieveAndGenerate to generate responses while using a
         * knowledge base as a source.
         * </p>
         * 
         * @param inferenceConfig
         *        Configuration settings for inference when using RetrieveAndGenerate to generate responses while using
         *        a knowledge base as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceConfig(InferenceConfig inferenceConfig);

        /**
         * <p>
         * Configuration settings for inference when using RetrieveAndGenerate to generate responses while using a
         * knowledge base as a source.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceConfig.Builder} avoiding the
         * need to create one manually via {@link InferenceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inferenceConfig(InferenceConfig)}.
         * 
         * @param inferenceConfig
         *        a consumer that will call methods on {@link InferenceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceConfig(InferenceConfig)
         */
        default Builder inferenceConfig(Consumer<InferenceConfig.Builder> inferenceConfig) {
            return inferenceConfig(InferenceConfig.builder().applyMutation(inferenceConfig).build());
        }

        /**
         * <p>
         * The latency configuration for the model.
         * </p>
         * 
         * @param performanceConfig
         *        The latency configuration for the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceConfig(PerformanceConfiguration performanceConfig);

        /**
         * <p>
         * The latency configuration for the model.
         * </p>
         * This is a convenience method that creates an instance of the {@link PerformanceConfiguration.Builder}
         * avoiding the need to create one manually via {@link PerformanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PerformanceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #performanceConfig(PerformanceConfiguration)}.
         * 
         * @param performanceConfig
         *        a consumer that will call methods on {@link PerformanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #performanceConfig(PerformanceConfiguration)
         */
        default Builder performanceConfig(Consumer<PerformanceConfiguration.Builder> performanceConfig) {
            return performanceConfig(PerformanceConfiguration.builder().applyMutation(performanceConfig).build());
        }

        /**
         * <p>
         * Contains the template for the prompt that's sent to the model for response generation. Generation prompts
         * must include the <code>$search_results$</code> variable. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html">Use placeholder
         * variables</a> in the user guide.
         * </p>
         * 
         * @param promptTemplate
         *        Contains the template for the prompt that's sent to the model for response generation. Generation
         *        prompts must include the <code>$search_results$</code> variable. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html">Use placeholder
         *        variables</a> in the user guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptTemplate(PromptTemplate promptTemplate);

        /**
         * <p>
         * Contains the template for the prompt that's sent to the model for response generation. Generation prompts
         * must include the <code>$search_results$</code> variable. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html">Use placeholder
         * variables</a> in the user guide.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptTemplate.Builder} avoiding the need
         * to create one manually via {@link PromptTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #promptTemplate(PromptTemplate)}.
         * 
         * @param promptTemplate
         *        a consumer that will call methods on {@link PromptTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptTemplate(PromptTemplate)
         */
        default Builder promptTemplate(Consumer<PromptTemplate.Builder> promptTemplate) {
            return promptTemplate(PromptTemplate.builder().applyMutation(promptTemplate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Document> additionalModelRequestFields = DefaultSdkAutoConstructMap.getInstance();

        private GuardrailConfiguration guardrailConfiguration;

        private InferenceConfig inferenceConfig;

        private PerformanceConfiguration performanceConfig;

        private PromptTemplate promptTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerationConfiguration model) {
            additionalModelRequestFields(model.additionalModelRequestFields);
            guardrailConfiguration(model.guardrailConfiguration);
            inferenceConfig(model.inferenceConfig);
            performanceConfig(model.performanceConfig);
            promptTemplate(model.promptTemplate);
        }

        public final Map<String, Document> getAdditionalModelRequestFields() {
            if (additionalModelRequestFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
        }

        @Override
        public final Builder additionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
            return this;
        }

        public final GuardrailConfiguration.Builder getGuardrailConfiguration() {
            return guardrailConfiguration != null ? guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfiguration.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final InferenceConfig.Builder getInferenceConfig() {
            return inferenceConfig != null ? inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(InferenceConfig.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(InferenceConfig inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final PerformanceConfiguration.Builder getPerformanceConfig() {
            return performanceConfig != null ? performanceConfig.toBuilder() : null;
        }

        public final void setPerformanceConfig(PerformanceConfiguration.BuilderImpl performanceConfig) {
            this.performanceConfig = performanceConfig != null ? performanceConfig.build() : null;
        }

        @Override
        public final Builder performanceConfig(PerformanceConfiguration performanceConfig) {
            this.performanceConfig = performanceConfig;
            return this;
        }

        public final PromptTemplate.Builder getPromptTemplate() {
            return promptTemplate != null ? promptTemplate.toBuilder() : null;
        }

        public final void setPromptTemplate(PromptTemplate.BuilderImpl promptTemplate) {
            this.promptTemplate = promptTemplate != null ? promptTemplate.build() : null;
        }

        @Override
        public final Builder promptTemplate(PromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        @Override
        public GenerationConfiguration build() {
            return new GenerationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
