/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for transforming text to SQL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextToSqlConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TextToSqlConfiguration.Builder, TextToSqlConfiguration> {
    private static final SdkField<TextToSqlKnowledgeBaseConfiguration> KNOWLEDGE_BASE_CONFIGURATION_FIELD = SdkField
            .<TextToSqlKnowledgeBaseConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("knowledgeBaseConfiguration")
            .getter(getter(TextToSqlConfiguration::knowledgeBaseConfiguration))
            .setter(setter(Builder::knowledgeBaseConfiguration))
            .constructor(TextToSqlKnowledgeBaseConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseConfiguration").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(TextToSqlConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            KNOWLEDGE_BASE_CONFIGURATION_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TextToSqlKnowledgeBaseConfiguration knowledgeBaseConfiguration;

    private final String type;

    private TextToSqlConfiguration(BuilderImpl builder) {
        this.knowledgeBaseConfiguration = builder.knowledgeBaseConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies configurations for a knowledge base to use in transformation.
     * </p>
     * 
     * @return Specifies configurations for a knowledge base to use in transformation.
     */
    public final TextToSqlKnowledgeBaseConfiguration knowledgeBaseConfiguration() {
        return knowledgeBaseConfiguration;
    }

    /**
     * <p>
     * The type of resource to use in transformation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TextToSqlConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource to use in transformation.
     * @see TextToSqlConfigurationType
     */
    public final TextToSqlConfigurationType type() {
        return TextToSqlConfigurationType.fromValue(type);
    }

    /**
     * <p>
     * The type of resource to use in transformation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link TextToSqlConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource to use in transformation.
     * @see TextToSqlConfigurationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextToSqlConfiguration)) {
            return false;
        }
        TextToSqlConfiguration other = (TextToSqlConfiguration) obj;
        return Objects.equals(knowledgeBaseConfiguration(), other.knowledgeBaseConfiguration())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextToSqlConfiguration").add("KnowledgeBaseConfiguration", knowledgeBaseConfiguration())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseConfiguration":
            return Optional.ofNullable(clazz.cast(knowledgeBaseConfiguration()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseConfiguration", KNOWLEDGE_BASE_CONFIGURATION_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextToSqlConfiguration, T> g) {
        return obj -> g.apply((TextToSqlConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextToSqlConfiguration> {
        /**
         * <p>
         * Specifies configurations for a knowledge base to use in transformation.
         * </p>
         * 
         * @param knowledgeBaseConfiguration
         *        Specifies configurations for a knowledge base to use in transformation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseConfiguration(TextToSqlKnowledgeBaseConfiguration knowledgeBaseConfiguration);

        /**
         * <p>
         * Specifies configurations for a knowledge base to use in transformation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TextToSqlKnowledgeBaseConfiguration.Builder} avoiding the need to create one manually via
         * {@link TextToSqlKnowledgeBaseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextToSqlKnowledgeBaseConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #knowledgeBaseConfiguration(TextToSqlKnowledgeBaseConfiguration)}.
         * 
         * @param knowledgeBaseConfiguration
         *        a consumer that will call methods on {@link TextToSqlKnowledgeBaseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBaseConfiguration(TextToSqlKnowledgeBaseConfiguration)
         */
        default Builder knowledgeBaseConfiguration(
                Consumer<TextToSqlKnowledgeBaseConfiguration.Builder> knowledgeBaseConfiguration) {
            return knowledgeBaseConfiguration(TextToSqlKnowledgeBaseConfiguration.builder()
                    .applyMutation(knowledgeBaseConfiguration).build());
        }

        /**
         * <p>
         * The type of resource to use in transformation.
         * </p>
         * 
         * @param type
         *        The type of resource to use in transformation.
         * @see TextToSqlConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TextToSqlConfigurationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of resource to use in transformation.
         * </p>
         * 
         * @param type
         *        The type of resource to use in transformation.
         * @see TextToSqlConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TextToSqlConfigurationType
         */
        Builder type(TextToSqlConfigurationType type);
    }

    static final class BuilderImpl implements Builder {
        private TextToSqlKnowledgeBaseConfiguration knowledgeBaseConfiguration;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(TextToSqlConfiguration model) {
            knowledgeBaseConfiguration(model.knowledgeBaseConfiguration);
            type(model.type);
        }

        public final TextToSqlKnowledgeBaseConfiguration.Builder getKnowledgeBaseConfiguration() {
            return knowledgeBaseConfiguration != null ? knowledgeBaseConfiguration.toBuilder() : null;
        }

        public final void setKnowledgeBaseConfiguration(TextToSqlKnowledgeBaseConfiguration.BuilderImpl knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration != null ? knowledgeBaseConfiguration.build() : null;
        }

        @Override
        public final Builder knowledgeBaseConfiguration(TextToSqlKnowledgeBaseConfiguration knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TextToSqlConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public TextToSqlConfiguration build() {
            return new TextToSqlConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
