/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankQueriesListCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankQuery;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankSource;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankSourcesListCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.RerankingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RerankRequest
extends BedrockAgentRuntimeRequest
implements ToCopyableBuilder<Builder, RerankRequest> {
    private static final SdkField<List<RerankQuery>> QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queries").getter(RerankRequest.getter(RerankRequest::queries)).setter(RerankRequest.setter(Builder::queries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RerankQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RerankSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(RerankRequest.getter(RerankRequest::sources)).setter(RerankRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RerankSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RerankingConfiguration> RERANKING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rerankingConfiguration").getter(RerankRequest.getter(RerankRequest::rerankingConfiguration)).setter(RerankRequest.setter(Builder::rerankingConfiguration)).constructor(RerankingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rerankingConfiguration").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(RerankRequest.getter(RerankRequest::nextToken)).setter(RerankRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERIES_FIELD, SOURCES_FIELD, RERANKING_CONFIGURATION_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RerankRequest.memberNameToFieldInitializer();
    private final List<RerankQuery> queries;
    private final List<RerankSource> sources;
    private final RerankingConfiguration rerankingConfiguration;
    private final String nextToken;

    private RerankRequest(BuilderImpl builder) {
        super(builder);
        this.queries = builder.queries;
        this.sources = builder.sources;
        this.rerankingConfiguration = builder.rerankingConfiguration;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasQueries() {
        return this.queries != null && !(this.queries instanceof SdkAutoConstructList);
    }

    public final List<RerankQuery> queries() {
        return this.queries;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<RerankSource> sources() {
        return this.sources;
    }

    public final RerankingConfiguration rerankingConfiguration() {
        return this.rerankingConfiguration;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueries() ? this.queries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rerankingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RerankRequest)) {
            return false;
        }
        RerankRequest other = (RerankRequest)((Object)obj);
        return this.hasQueries() == other.hasQueries() && Objects.equals(this.queries(), other.queries()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.rerankingConfiguration(), other.rerankingConfiguration()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"RerankRequest").add("Queries", (Object)(this.queries() == null ? null : "*** Sensitive Data Redacted ***")).add("Sources", (Object)(this.sources() == null ? null : "*** Sensitive Data Redacted ***")).add("RerankingConfiguration", (Object)this.rerankingConfiguration()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queries": {
                return Optional.ofNullable(clazz.cast(this.queries()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "rerankingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.rerankingConfiguration()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("queries", QUERIES_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("rerankingConfiguration", RERANKING_CONFIGURATION_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RerankRequest, T> g) {
        return obj -> g.apply((RerankRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeRequest.BuilderImpl
    implements Builder {
        private List<RerankQuery> queries = DefaultSdkAutoConstructList.getInstance();
        private List<RerankSource> sources = DefaultSdkAutoConstructList.getInstance();
        private RerankingConfiguration rerankingConfiguration;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RerankRequest model) {
            super(model);
            this.queries(model.queries);
            this.sources(model.sources);
            this.rerankingConfiguration(model.rerankingConfiguration);
            this.nextToken(model.nextToken);
        }

        public final List<RerankQuery.Builder> getQueries() {
            List<RerankQuery.Builder> result = RerankQueriesListCopier.copyToBuilder(this.queries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueries(Collection<RerankQuery.BuilderImpl> queries) {
            this.queries = RerankQueriesListCopier.copyFromBuilder(queries);
        }

        @Override
        public final Builder queries(Collection<RerankQuery> queries) {
            this.queries = RerankQueriesListCopier.copy(queries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(RerankQuery ... queries) {
            this.queries(Arrays.asList(queries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queries(Consumer<RerankQuery.Builder> ... queries) {
            this.queries(Stream.of(queries).map(c -> (RerankQuery)((RerankQuery.Builder)RerankQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RerankSource.Builder> getSources() {
            List<RerankSource.Builder> result = RerankSourcesListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<RerankSource.BuilderImpl> sources) {
            this.sources = RerankSourcesListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<RerankSource> sources) {
            this.sources = RerankSourcesListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(RerankSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<RerankSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (RerankSource)((RerankSource.Builder)RerankSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RerankingConfiguration.Builder getRerankingConfiguration() {
            return this.rerankingConfiguration != null ? this.rerankingConfiguration.toBuilder() : null;
        }

        public final void setRerankingConfiguration(RerankingConfiguration.BuilderImpl rerankingConfiguration) {
            this.rerankingConfiguration = rerankingConfiguration != null ? rerankingConfiguration.build() : null;
        }

        @Override
        public final Builder rerankingConfiguration(RerankingConfiguration rerankingConfiguration) {
            this.rerankingConfiguration = rerankingConfiguration;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RerankRequest build() {
            return new RerankRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RerankRequest> {
        public Builder queries(Collection<RerankQuery> var1);

        public Builder queries(RerankQuery ... var1);

        public Builder queries(Consumer<RerankQuery.Builder> ... var1);

        public Builder sources(Collection<RerankSource> var1);

        public Builder sources(RerankSource ... var1);

        public Builder sources(Consumer<RerankSource.Builder> ... var1);

        public Builder rerankingConfiguration(RerankingConfiguration var1);

        default public Builder rerankingConfiguration(Consumer<RerankingConfiguration.Builder> rerankingConfiguration) {
            return this.rerankingConfiguration((RerankingConfiguration)((RerankingConfiguration.Builder)RerankingConfiguration.builder().applyMutation(rerankingConfiguration)).build());
        }

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

