/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockagentruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseRetrievalResult;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrieveResponse;

public class RetrievePublisher
implements SdkPublisher<RetrieveResponse> {
    private final BedrockAgentRuntimeAsyncClient client;
    private final RetrieveRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public RetrievePublisher(BedrockAgentRuntimeAsyncClient client, RetrieveRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private RetrievePublisher(BedrockAgentRuntimeAsyncClient client, RetrieveRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new RetrieveResponseFetcher();
    }

    public void subscribe(Subscriber<? super RetrieveResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<KnowledgeBaseRetrievalResult> retrievalResults() {
        Function<RetrieveResponse, Iterator> getIterator = response -> {
            if (response != null && response.retrievalResults() != null) {
                return response.retrievalResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new RetrieveResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class RetrieveResponseFetcher
    implements AsyncPageFetcher<RetrieveResponse> {
        private RetrieveResponseFetcher() {
        }

        public boolean hasNextPage(RetrieveResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<RetrieveResponse> nextPage(RetrieveResponse previousPage) {
            if (previousPage == null) {
                return RetrievePublisher.this.client.retrieve(RetrievePublisher.this.firstRequest);
            }
            return RetrievePublisher.this.client.retrieve((RetrieveRequest)((Object)RetrievePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

