/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.TextToSqlConfigurationType;
import software.amazon.awssdk.services.bedrockagentruntime.model.TextToSqlKnowledgeBaseConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextToSqlConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextToSqlConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(TextToSqlConfiguration.getter(TextToSqlConfiguration::typeAsString)).setter(TextToSqlConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<TextToSqlKnowledgeBaseConfiguration> KNOWLEDGE_BASE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("knowledgeBaseConfiguration").getter(TextToSqlConfiguration.getter(TextToSqlConfiguration::knowledgeBaseConfiguration)).setter(TextToSqlConfiguration.setter(Builder::knowledgeBaseConfiguration)).constructor(TextToSqlKnowledgeBaseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, KNOWLEDGE_BASE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TextToSqlConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final TextToSqlKnowledgeBaseConfiguration knowledgeBaseConfiguration;

    private TextToSqlConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.knowledgeBaseConfiguration = builder.knowledgeBaseConfiguration;
    }

    public final TextToSqlConfigurationType type() {
        return TextToSqlConfigurationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final TextToSqlKnowledgeBaseConfiguration knowledgeBaseConfiguration() {
        return this.knowledgeBaseConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextToSqlConfiguration)) {
            return false;
        }
        TextToSqlConfiguration other = (TextToSqlConfiguration)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.knowledgeBaseConfiguration(), other.knowledgeBaseConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"TextToSqlConfiguration").add("Type", (Object)this.typeAsString()).add("KnowledgeBaseConfiguration", (Object)this.knowledgeBaseConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "knowledgeBaseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("knowledgeBaseConfiguration", KNOWLEDGE_BASE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextToSqlConfiguration, T> g) {
        return obj -> g.apply((TextToSqlConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private TextToSqlKnowledgeBaseConfiguration knowledgeBaseConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TextToSqlConfiguration model) {
            this.type(model.type);
            this.knowledgeBaseConfiguration(model.knowledgeBaseConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TextToSqlConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final TextToSqlKnowledgeBaseConfiguration.Builder getKnowledgeBaseConfiguration() {
            return this.knowledgeBaseConfiguration != null ? this.knowledgeBaseConfiguration.toBuilder() : null;
        }

        public final void setKnowledgeBaseConfiguration(TextToSqlKnowledgeBaseConfiguration.BuilderImpl knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration != null ? knowledgeBaseConfiguration.build() : null;
        }

        @Override
        public final Builder knowledgeBaseConfiguration(TextToSqlKnowledgeBaseConfiguration knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration;
            return this;
        }

        public TextToSqlConfiguration build() {
            return new TextToSqlConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextToSqlConfiguration> {
        public Builder type(String var1);

        public Builder type(TextToSqlConfigurationType var1);

        public Builder knowledgeBaseConfiguration(TextToSqlKnowledgeBaseConfiguration var1);

        default public Builder knowledgeBaseConfiguration(Consumer<TextToSqlKnowledgeBaseConfiguration.Builder> knowledgeBaseConfiguration) {
            return this.knowledgeBaseConfiguration((TextToSqlKnowledgeBaseConfiguration)((TextToSqlKnowledgeBaseConfiguration.Builder)TextToSqlKnowledgeBaseConfiguration.builder().applyMutation(knowledgeBaseConfiguration)).build());
        }
    }
}

