/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.RelayConversationHistory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CollaboratorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CollaboratorConfiguration> {
    private static final SdkField<String> COLLABORATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaboratorName").getter(CollaboratorConfiguration.getter(CollaboratorConfiguration::collaboratorName)).setter(CollaboratorConfiguration.setter(Builder::collaboratorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorName").build()}).build();
    private static final SdkField<String> COLLABORATOR_INSTRUCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaboratorInstruction").getter(CollaboratorConfiguration.getter(CollaboratorConfiguration::collaboratorInstruction)).setter(CollaboratorConfiguration.setter(Builder::collaboratorInstruction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorInstruction").build()}).build();
    private static final SdkField<String> AGENT_ALIAS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentAliasArn").getter(CollaboratorConfiguration.getter(CollaboratorConfiguration::agentAliasArn)).setter(CollaboratorConfiguration.setter(Builder::agentAliasArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasArn").build()}).build();
    private static final SdkField<String> RELAY_CONVERSATION_HISTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relayConversationHistory").getter(CollaboratorConfiguration.getter(CollaboratorConfiguration::relayConversationHistoryAsString)).setter(CollaboratorConfiguration.setter(Builder::relayConversationHistory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relayConversationHistory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATOR_NAME_FIELD, COLLABORATOR_INSTRUCTION_FIELD, AGENT_ALIAS_ARN_FIELD, RELAY_CONVERSATION_HISTORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CollaboratorConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String collaboratorName;
    private final String collaboratorInstruction;
    private final String agentAliasArn;
    private final String relayConversationHistory;

    private CollaboratorConfiguration(BuilderImpl builder) {
        this.collaboratorName = builder.collaboratorName;
        this.collaboratorInstruction = builder.collaboratorInstruction;
        this.agentAliasArn = builder.agentAliasArn;
        this.relayConversationHistory = builder.relayConversationHistory;
    }

    public final String collaboratorName() {
        return this.collaboratorName;
    }

    public final String collaboratorInstruction() {
        return this.collaboratorInstruction;
    }

    public final String agentAliasArn() {
        return this.agentAliasArn;
    }

    public final RelayConversationHistory relayConversationHistory() {
        return RelayConversationHistory.fromValue(this.relayConversationHistory);
    }

    public final String relayConversationHistoryAsString() {
        return this.relayConversationHistory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collaboratorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaboratorInstruction());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.relayConversationHistoryAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollaboratorConfiguration)) {
            return false;
        }
        CollaboratorConfiguration other = (CollaboratorConfiguration)obj;
        return Objects.equals(this.collaboratorName(), other.collaboratorName()) && Objects.equals(this.collaboratorInstruction(), other.collaboratorInstruction()) && Objects.equals(this.agentAliasArn(), other.agentAliasArn()) && Objects.equals(this.relayConversationHistoryAsString(), other.relayConversationHistoryAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CollaboratorConfiguration").add("CollaboratorName", (Object)(this.collaboratorName() == null ? null : "*** Sensitive Data Redacted ***")).add("CollaboratorInstruction", (Object)(this.collaboratorInstruction() == null ? null : "*** Sensitive Data Redacted ***")).add("AgentAliasArn", (Object)this.agentAliasArn()).add("RelayConversationHistory", (Object)this.relayConversationHistoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collaboratorName": {
                return Optional.ofNullable(clazz.cast(this.collaboratorName()));
            }
            case "collaboratorInstruction": {
                return Optional.ofNullable(clazz.cast(this.collaboratorInstruction()));
            }
            case "agentAliasArn": {
                return Optional.ofNullable(clazz.cast(this.agentAliasArn()));
            }
            case "relayConversationHistory": {
                return Optional.ofNullable(clazz.cast(this.relayConversationHistoryAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("collaboratorName", COLLABORATOR_NAME_FIELD);
        map.put("collaboratorInstruction", COLLABORATOR_INSTRUCTION_FIELD);
        map.put("agentAliasArn", AGENT_ALIAS_ARN_FIELD);
        map.put("relayConversationHistory", RELAY_CONVERSATION_HISTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollaboratorConfiguration, T> g) {
        return obj -> g.apply((CollaboratorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String collaboratorName;
        private String collaboratorInstruction;
        private String agentAliasArn;
        private String relayConversationHistory;

        private BuilderImpl() {
        }

        private BuilderImpl(CollaboratorConfiguration model) {
            this.collaboratorName(model.collaboratorName);
            this.collaboratorInstruction(model.collaboratorInstruction);
            this.agentAliasArn(model.agentAliasArn);
            this.relayConversationHistory(model.relayConversationHistory);
        }

        public final String getCollaboratorName() {
            return this.collaboratorName;
        }

        public final void setCollaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
        }

        @Override
        public final Builder collaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
            return this;
        }

        public final String getCollaboratorInstruction() {
            return this.collaboratorInstruction;
        }

        public final void setCollaboratorInstruction(String collaboratorInstruction) {
            this.collaboratorInstruction = collaboratorInstruction;
        }

        @Override
        public final Builder collaboratorInstruction(String collaboratorInstruction) {
            this.collaboratorInstruction = collaboratorInstruction;
            return this;
        }

        public final String getAgentAliasArn() {
            return this.agentAliasArn;
        }

        public final void setAgentAliasArn(String agentAliasArn) {
            this.agentAliasArn = agentAliasArn;
        }

        @Override
        public final Builder agentAliasArn(String agentAliasArn) {
            this.agentAliasArn = agentAliasArn;
            return this;
        }

        public final String getRelayConversationHistory() {
            return this.relayConversationHistory;
        }

        public final void setRelayConversationHistory(String relayConversationHistory) {
            this.relayConversationHistory = relayConversationHistory;
        }

        @Override
        public final Builder relayConversationHistory(String relayConversationHistory) {
            this.relayConversationHistory = relayConversationHistory;
            return this;
        }

        @Override
        public final Builder relayConversationHistory(RelayConversationHistory relayConversationHistory) {
            this.relayConversationHistory(relayConversationHistory == null ? null : relayConversationHistory.toString());
            return this;
        }

        public CollaboratorConfiguration build() {
            return new CollaboratorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CollaboratorConfiguration> {
        public Builder collaboratorName(String var1);

        public Builder collaboratorInstruction(String var1);

        public Builder agentAliasArn(String var1);

        public Builder relayConversationHistory(String var1);

        public Builder relayConversationHistory(RelayConversationHistory var1);
    }
}

