/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An agent collaborator invocation input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentCollaboratorInvocationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentCollaboratorInvocationInput.Builder, AgentCollaboratorInvocationInput> {
    private static final SdkField<String> AGENT_COLLABORATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentCollaboratorName").getter(getter(AgentCollaboratorInvocationInput::agentCollaboratorName))
            .setter(setter(Builder::agentCollaboratorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentCollaboratorName").build())
            .build();

    private static final SdkField<String> AGENT_COLLABORATOR_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentCollaboratorAliasArn").getter(getter(AgentCollaboratorInvocationInput::agentCollaboratorAliasArn))
            .setter(setter(Builder::agentCollaboratorAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentCollaboratorAliasArn").build())
            .build();

    private static final SdkField<AgentCollaboratorInputPayload> INPUT_FIELD = SdkField
            .<AgentCollaboratorInputPayload> builder(MarshallingType.SDK_POJO).memberName("input")
            .getter(getter(AgentCollaboratorInvocationInput::input)).setter(setter(Builder::input))
            .constructor(AgentCollaboratorInputPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_COLLABORATOR_NAME_FIELD,
            AGENT_COLLABORATOR_ALIAS_ARN_FIELD, INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String agentCollaboratorName;

    private final String agentCollaboratorAliasArn;

    private final AgentCollaboratorInputPayload input;

    private AgentCollaboratorInvocationInput(BuilderImpl builder) {
        this.agentCollaboratorName = builder.agentCollaboratorName;
        this.agentCollaboratorAliasArn = builder.agentCollaboratorAliasArn;
        this.input = builder.input;
    }

    /**
     * <p>
     * The collaborator's name.
     * </p>
     * 
     * @return The collaborator's name.
     */
    public final String agentCollaboratorName() {
        return agentCollaboratorName;
    }

    /**
     * <p>
     * The collaborator's alias ARN.
     * </p>
     * 
     * @return The collaborator's alias ARN.
     */
    public final String agentCollaboratorAliasArn() {
        return agentCollaboratorAliasArn;
    }

    /**
     * <p>
     * Text or action invocation result input for the collaborator.
     * </p>
     * 
     * @return Text or action invocation result input for the collaborator.
     */
    public final AgentCollaboratorInputPayload input() {
        return input;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentCollaboratorName());
        hashCode = 31 * hashCode + Objects.hashCode(agentCollaboratorAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentCollaboratorInvocationInput)) {
            return false;
        }
        AgentCollaboratorInvocationInput other = (AgentCollaboratorInvocationInput) obj;
        return Objects.equals(agentCollaboratorName(), other.agentCollaboratorName())
                && Objects.equals(agentCollaboratorAliasArn(), other.agentCollaboratorAliasArn())
                && Objects.equals(input(), other.input());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentCollaboratorInvocationInput").add("AgentCollaboratorName", agentCollaboratorName())
                .add("AgentCollaboratorAliasArn", agentCollaboratorAliasArn()).add("Input", input()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentCollaboratorName":
            return Optional.ofNullable(clazz.cast(agentCollaboratorName()));
        case "agentCollaboratorAliasArn":
            return Optional.ofNullable(clazz.cast(agentCollaboratorAliasArn()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentCollaboratorName", AGENT_COLLABORATOR_NAME_FIELD);
        map.put("agentCollaboratorAliasArn", AGENT_COLLABORATOR_ALIAS_ARN_FIELD);
        map.put("input", INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentCollaboratorInvocationInput, T> g) {
        return obj -> g.apply((AgentCollaboratorInvocationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentCollaboratorInvocationInput> {
        /**
         * <p>
         * The collaborator's name.
         * </p>
         * 
         * @param agentCollaboratorName
         *        The collaborator's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentCollaboratorName(String agentCollaboratorName);

        /**
         * <p>
         * The collaborator's alias ARN.
         * </p>
         * 
         * @param agentCollaboratorAliasArn
         *        The collaborator's alias ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentCollaboratorAliasArn(String agentCollaboratorAliasArn);

        /**
         * <p>
         * Text or action invocation result input for the collaborator.
         * </p>
         * 
         * @param input
         *        Text or action invocation result input for the collaborator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(AgentCollaboratorInputPayload input);

        /**
         * <p>
         * Text or action invocation result input for the collaborator.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentCollaboratorInputPayload.Builder}
         * avoiding the need to create one manually via {@link AgentCollaboratorInputPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentCollaboratorInputPayload.Builder#build()} is called
         * immediately and its result is passed to {@link #input(AgentCollaboratorInputPayload)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link AgentCollaboratorInputPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(AgentCollaboratorInputPayload)
         */
        default Builder input(Consumer<AgentCollaboratorInputPayload.Builder> input) {
            return input(AgentCollaboratorInputPayload.builder().applyMutation(input).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String agentCollaboratorName;

        private String agentCollaboratorAliasArn;

        private AgentCollaboratorInputPayload input;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentCollaboratorInvocationInput model) {
            agentCollaboratorName(model.agentCollaboratorName);
            agentCollaboratorAliasArn(model.agentCollaboratorAliasArn);
            input(model.input);
        }

        public final String getAgentCollaboratorName() {
            return agentCollaboratorName;
        }

        public final void setAgentCollaboratorName(String agentCollaboratorName) {
            this.agentCollaboratorName = agentCollaboratorName;
        }

        @Override
        public final Builder agentCollaboratorName(String agentCollaboratorName) {
            this.agentCollaboratorName = agentCollaboratorName;
            return this;
        }

        public final String getAgentCollaboratorAliasArn() {
            return agentCollaboratorAliasArn;
        }

        public final void setAgentCollaboratorAliasArn(String agentCollaboratorAliasArn) {
            this.agentCollaboratorAliasArn = agentCollaboratorAliasArn;
        }

        @Override
        public final Builder agentCollaboratorAliasArn(String agentCollaboratorAliasArn) {
            this.agentCollaboratorAliasArn = agentCollaboratorAliasArn;
            return this;
        }

        public final AgentCollaboratorInputPayload.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(AgentCollaboratorInputPayload.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(AgentCollaboratorInputPayload input) {
            this.input = input;
            return this;
        }

        @Override
        public AgentCollaboratorInvocationInput build() {
            return new AgentCollaboratorInvocationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
