/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output from an agent collaborator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentCollaboratorInvocationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentCollaboratorInvocationOutput.Builder, AgentCollaboratorInvocationOutput> {
    private static final SdkField<String> AGENT_COLLABORATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentCollaboratorName").getter(getter(AgentCollaboratorInvocationOutput::agentCollaboratorName))
            .setter(setter(Builder::agentCollaboratorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentCollaboratorName").build())
            .build();

    private static final SdkField<String> AGENT_COLLABORATOR_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentCollaboratorAliasArn").getter(getter(AgentCollaboratorInvocationOutput::agentCollaboratorAliasArn))
            .setter(setter(Builder::agentCollaboratorAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentCollaboratorAliasArn").build())
            .build();

    private static final SdkField<AgentCollaboratorOutputPayload> OUTPUT_FIELD = SdkField
            .<AgentCollaboratorOutputPayload> builder(MarshallingType.SDK_POJO).memberName("output")
            .getter(getter(AgentCollaboratorInvocationOutput::output)).setter(setter(Builder::output))
            .constructor(AgentCollaboratorOutputPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final SdkField<Metadata> METADATA_FIELD = SdkField.<Metadata> builder(MarshallingType.SDK_POJO)
            .memberName("metadata").getter(getter(AgentCollaboratorInvocationOutput::metadata)).setter(setter(Builder::metadata))
            .constructor(Metadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_COLLABORATOR_NAME_FIELD,
            AGENT_COLLABORATOR_ALIAS_ARN_FIELD, OUTPUT_FIELD, METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String agentCollaboratorName;

    private final String agentCollaboratorAliasArn;

    private final AgentCollaboratorOutputPayload output;

    private final Metadata metadata;

    private AgentCollaboratorInvocationOutput(BuilderImpl builder) {
        this.agentCollaboratorName = builder.agentCollaboratorName;
        this.agentCollaboratorAliasArn = builder.agentCollaboratorAliasArn;
        this.output = builder.output;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The output's agent collaborator name.
     * </p>
     * 
     * @return The output's agent collaborator name.
     */
    public final String agentCollaboratorName() {
        return agentCollaboratorName;
    }

    /**
     * <p>
     * The output's agent collaborator alias ARN.
     * </p>
     * 
     * @return The output's agent collaborator alias ARN.
     */
    public final String agentCollaboratorAliasArn() {
        return agentCollaboratorAliasArn;
    }

    /**
     * <p>
     * The output's output.
     * </p>
     * 
     * @return The output's output.
     */
    public final AgentCollaboratorOutputPayload output() {
        return output;
    }

    /**
     * <p>
     * Contains information about the output from the agent collaborator.
     * </p>
     * 
     * @return Contains information about the output from the agent collaborator.
     */
    public final Metadata metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentCollaboratorName());
        hashCode = 31 * hashCode + Objects.hashCode(agentCollaboratorAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentCollaboratorInvocationOutput)) {
            return false;
        }
        AgentCollaboratorInvocationOutput other = (AgentCollaboratorInvocationOutput) obj;
        return Objects.equals(agentCollaboratorName(), other.agentCollaboratorName())
                && Objects.equals(agentCollaboratorAliasArn(), other.agentCollaboratorAliasArn())
                && Objects.equals(output(), other.output()) && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentCollaboratorInvocationOutput").add("AgentCollaboratorName", agentCollaboratorName())
                .add("AgentCollaboratorAliasArn", agentCollaboratorAliasArn()).add("Output", output())
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentCollaboratorName":
            return Optional.ofNullable(clazz.cast(agentCollaboratorName()));
        case "agentCollaboratorAliasArn":
            return Optional.ofNullable(clazz.cast(agentCollaboratorAliasArn()));
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentCollaboratorName", AGENT_COLLABORATOR_NAME_FIELD);
        map.put("agentCollaboratorAliasArn", AGENT_COLLABORATOR_ALIAS_ARN_FIELD);
        map.put("output", OUTPUT_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentCollaboratorInvocationOutput, T> g) {
        return obj -> g.apply((AgentCollaboratorInvocationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentCollaboratorInvocationOutput> {
        /**
         * <p>
         * The output's agent collaborator name.
         * </p>
         * 
         * @param agentCollaboratorName
         *        The output's agent collaborator name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentCollaboratorName(String agentCollaboratorName);

        /**
         * <p>
         * The output's agent collaborator alias ARN.
         * </p>
         * 
         * @param agentCollaboratorAliasArn
         *        The output's agent collaborator alias ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentCollaboratorAliasArn(String agentCollaboratorAliasArn);

        /**
         * <p>
         * The output's output.
         * </p>
         * 
         * @param output
         *        The output's output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(AgentCollaboratorOutputPayload output);

        /**
         * <p>
         * The output's output.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentCollaboratorOutputPayload.Builder}
         * avoiding the need to create one manually via {@link AgentCollaboratorOutputPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentCollaboratorOutputPayload.Builder#build()} is called
         * immediately and its result is passed to {@link #output(AgentCollaboratorOutputPayload)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link AgentCollaboratorOutputPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(AgentCollaboratorOutputPayload)
         */
        default Builder output(Consumer<AgentCollaboratorOutputPayload.Builder> output) {
            return output(AgentCollaboratorOutputPayload.builder().applyMutation(output).build());
        }

        /**
         * <p>
         * Contains information about the output from the agent collaborator.
         * </p>
         * 
         * @param metadata
         *        Contains information about the output from the agent collaborator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Metadata metadata);

        /**
         * <p>
         * Contains information about the output from the agent collaborator.
         * </p>
         * This is a convenience method that creates an instance of the {@link Metadata.Builder} avoiding the need to
         * create one manually via {@link Metadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Metadata.Builder#build()} is called immediately and its result is
         * passed to {@link #metadata(Metadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link Metadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(Metadata)
         */
        default Builder metadata(Consumer<Metadata.Builder> metadata) {
            return metadata(Metadata.builder().applyMutation(metadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String agentCollaboratorName;

        private String agentCollaboratorAliasArn;

        private AgentCollaboratorOutputPayload output;

        private Metadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentCollaboratorInvocationOutput model) {
            agentCollaboratorName(model.agentCollaboratorName);
            agentCollaboratorAliasArn(model.agentCollaboratorAliasArn);
            output(model.output);
            metadata(model.metadata);
        }

        public final String getAgentCollaboratorName() {
            return agentCollaboratorName;
        }

        public final void setAgentCollaboratorName(String agentCollaboratorName) {
            this.agentCollaboratorName = agentCollaboratorName;
        }

        @Override
        public final Builder agentCollaboratorName(String agentCollaboratorName) {
            this.agentCollaboratorName = agentCollaboratorName;
            return this;
        }

        public final String getAgentCollaboratorAliasArn() {
            return agentCollaboratorAliasArn;
        }

        public final void setAgentCollaboratorAliasArn(String agentCollaboratorAliasArn) {
            this.agentCollaboratorAliasArn = agentCollaboratorAliasArn;
        }

        @Override
        public final Builder agentCollaboratorAliasArn(String agentCollaboratorAliasArn) {
            this.agentCollaboratorAliasArn = agentCollaboratorAliasArn;
            return this;
        }

        public final AgentCollaboratorOutputPayload.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(AgentCollaboratorOutputPayload.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(AgentCollaboratorOutputPayload output) {
            this.output = output;
            return this;
        }

        public final Metadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(Metadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public AgentCollaboratorInvocationOutput build() {
            return new AgentCollaboratorInvocationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
