/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output from an agent collaborator. The output can be text or an action invocation result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentCollaboratorOutputPayload implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentCollaboratorOutputPayload.Builder, AgentCollaboratorOutputPayload> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(AgentCollaboratorOutputPayload::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(AgentCollaboratorOutputPayload::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<ReturnControlPayload> RETURN_CONTROL_PAYLOAD_FIELD = SdkField
            .<ReturnControlPayload> builder(MarshallingType.SDK_POJO).memberName("returnControlPayload")
            .getter(getter(AgentCollaboratorOutputPayload::returnControlPayload)).setter(setter(Builder::returnControlPayload))
            .constructor(ReturnControlPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnControlPayload").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TEXT_FIELD,
            RETURN_CONTROL_PAYLOAD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String text;

    private final ReturnControlPayload returnControlPayload;

    private AgentCollaboratorOutputPayload(BuilderImpl builder) {
        this.type = builder.type;
        this.text = builder.text;
        this.returnControlPayload = builder.returnControlPayload;
    }

    /**
     * <p>
     * The type of output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of output.
     * @see PayloadType
     */
    public final PayloadType type() {
        return PayloadType.fromValue(type);
    }

    /**
     * <p>
     * The type of output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PayloadType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of output.
     * @see PayloadType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Text output.
     * </p>
     * 
     * @return Text output.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * An action invocation result.
     * </p>
     * 
     * @return An action invocation result.
     */
    public final ReturnControlPayload returnControlPayload() {
        return returnControlPayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(returnControlPayload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentCollaboratorOutputPayload)) {
            return false;
        }
        AgentCollaboratorOutputPayload other = (AgentCollaboratorOutputPayload) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(text(), other.text())
                && Objects.equals(returnControlPayload(), other.returnControlPayload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentCollaboratorOutputPayload").add("Type", typeAsString())
                .add("Text", text() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ReturnControlPayload", returnControlPayload() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "returnControlPayload":
            return Optional.ofNullable(clazz.cast(returnControlPayload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("returnControlPayload", RETURN_CONTROL_PAYLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentCollaboratorOutputPayload, T> g) {
        return obj -> g.apply((AgentCollaboratorOutputPayload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentCollaboratorOutputPayload> {
        /**
         * <p>
         * The type of output.
         * </p>
         * 
         * @param type
         *        The type of output.
         * @see PayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayloadType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of output.
         * </p>
         * 
         * @param type
         *        The type of output.
         * @see PayloadType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayloadType
         */
        Builder type(PayloadType type);

        /**
         * <p>
         * Text output.
         * </p>
         * 
         * @param text
         *        Text output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * An action invocation result.
         * </p>
         * 
         * @param returnControlPayload
         *        An action invocation result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnControlPayload(ReturnControlPayload returnControlPayload);

        /**
         * <p>
         * An action invocation result.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReturnControlPayload.Builder} avoiding
         * the need to create one manually via {@link ReturnControlPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReturnControlPayload.Builder#build()} is called immediately and
         * its result is passed to {@link #returnControlPayload(ReturnControlPayload)}.
         * 
         * @param returnControlPayload
         *        a consumer that will call methods on {@link ReturnControlPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #returnControlPayload(ReturnControlPayload)
         */
        default Builder returnControlPayload(Consumer<ReturnControlPayload.Builder> returnControlPayload) {
            return returnControlPayload(ReturnControlPayload.builder().applyMutation(returnControlPayload).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String text;

        private ReturnControlPayload returnControlPayload;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentCollaboratorOutputPayload model) {
            type(model.type);
            text(model.text);
            returnControlPayload(model.returnControlPayload);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PayloadType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final ReturnControlPayload.Builder getReturnControlPayload() {
            return returnControlPayload != null ? returnControlPayload.toBuilder() : null;
        }

        public final void setReturnControlPayload(ReturnControlPayload.BuilderImpl returnControlPayload) {
            this.returnControlPayload = returnControlPayload != null ? returnControlPayload.build() : null;
        }

        @Override
        public final Builder returnControlPayload(ReturnControlPayload returnControlPayload) {
            this.returnControlPayload = returnControlPayload;
            return this;
        }

        @Override
        public AgentCollaboratorOutputPayload build() {
            return new AgentCollaboratorOutputPayload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
