/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the API operation that the agent predicts should be called.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * In the <code>returnControl</code> field of the <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html#API_agent-runtime_InvokeAgent_ResponseSyntax"
 * >InvokeAgent response</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApiInvocationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ApiInvocationInput.Builder, ApiInvocationInput> {
    private static final SdkField<String> ACTION_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroup").getter(getter(ApiInvocationInput::actionGroup)).setter(setter(Builder::actionGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroup").build()).build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("httpMethod").getter(getter(ApiInvocationInput::httpMethod)).setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpMethod").build()).build();

    private static final SdkField<String> API_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("apiPath").getter(getter(ApiInvocationInput::apiPath)).setter(setter(Builder::apiPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiPath").build()).build();

    private static final SdkField<List<ApiParameter>> PARAMETERS_FIELD = SdkField
            .<List<ApiParameter>> builder(MarshallingType.LIST)
            .memberName("parameters")
            .getter(getter(ApiInvocationInput::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApiParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApiParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ApiRequestBody> REQUEST_BODY_FIELD = SdkField
            .<ApiRequestBody> builder(MarshallingType.SDK_POJO).memberName("requestBody")
            .getter(getter(ApiInvocationInput::requestBody)).setter(setter(Builder::requestBody))
            .constructor(ApiRequestBody::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestBody").build()).build();

    private static final SdkField<String> ACTION_INVOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionInvocationType").getter(getter(ApiInvocationInput::actionInvocationTypeAsString))
            .setter(setter(Builder::actionInvocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionInvocationType").build())
            .build();

    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(ApiInvocationInput::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> COLLABORATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaboratorName").getter(getter(ApiInvocationInput::collaboratorName))
            .setter(setter(Builder::collaboratorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_FIELD,
            HTTP_METHOD_FIELD, API_PATH_FIELD, PARAMETERS_FIELD, REQUEST_BODY_FIELD, ACTION_INVOCATION_TYPE_FIELD,
            AGENT_ID_FIELD, COLLABORATOR_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionGroup;

    private final String httpMethod;

    private final String apiPath;

    private final List<ApiParameter> parameters;

    private final ApiRequestBody requestBody;

    private final String actionInvocationType;

    private final String agentId;

    private final String collaboratorName;

    private ApiInvocationInput(BuilderImpl builder) {
        this.actionGroup = builder.actionGroup;
        this.httpMethod = builder.httpMethod;
        this.apiPath = builder.apiPath;
        this.parameters = builder.parameters;
        this.requestBody = builder.requestBody;
        this.actionInvocationType = builder.actionInvocationType;
        this.agentId = builder.agentId;
        this.collaboratorName = builder.collaboratorName;
    }

    /**
     * <p>
     * The action group that the API operation belongs to.
     * </p>
     * 
     * @return The action group that the API operation belongs to.
     */
    public final String actionGroup() {
        return actionGroup;
    }

    /**
     * <p>
     * The HTTP method of the API operation.
     * </p>
     * 
     * @return The HTTP method of the API operation.
     */
    public final String httpMethod() {
        return httpMethod;
    }

    /**
     * <p>
     * The path to the API operation.
     * </p>
     * 
     * @return The path to the API operation.
     */
    public final String apiPath() {
        return apiPath;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters to provide for the API request, as the agent elicited from the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters to provide for the API request, as the agent elicited from the user.
     */
    public final List<ApiParameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The request body to provide for the API request, as the agent elicited from the user.
     * </p>
     * 
     * @return The request body to provide for the API request, as the agent elicited from the user.
     */
    public final ApiRequestBody requestBody() {
        return requestBody;
    }

    /**
     * <p>
     * Contains information about the API operation to invoke.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionInvocationType} will return {@link ActionInvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionInvocationTypeAsString}.
     * </p>
     * 
     * @return Contains information about the API operation to invoke.
     * @see ActionInvocationType
     */
    public final ActionInvocationType actionInvocationType() {
        return ActionInvocationType.fromValue(actionInvocationType);
    }

    /**
     * <p>
     * Contains information about the API operation to invoke.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionInvocationType} will return {@link ActionInvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionInvocationTypeAsString}.
     * </p>
     * 
     * @return Contains information about the API operation to invoke.
     * @see ActionInvocationType
     */
    public final String actionInvocationTypeAsString() {
        return actionInvocationType;
    }

    /**
     * <p>
     * The agent's ID.
     * </p>
     * 
     * @return The agent's ID.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The agent collaborator's name.
     * </p>
     * 
     * @return The agent collaborator's name.
     */
    public final String collaboratorName() {
        return collaboratorName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionGroup());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(apiPath());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestBody());
        hashCode = 31 * hashCode + Objects.hashCode(actionInvocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(collaboratorName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiInvocationInput)) {
            return false;
        }
        ApiInvocationInput other = (ApiInvocationInput) obj;
        return Objects.equals(actionGroup(), other.actionGroup()) && Objects.equals(httpMethod(), other.httpMethod())
                && Objects.equals(apiPath(), other.apiPath()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(requestBody(), other.requestBody())
                && Objects.equals(actionInvocationTypeAsString(), other.actionInvocationTypeAsString())
                && Objects.equals(agentId(), other.agentId()) && Objects.equals(collaboratorName(), other.collaboratorName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApiInvocationInput").add("ActionGroup", actionGroup()).add("HttpMethod", httpMethod())
                .add("ApiPath", apiPath() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Parameters", hasParameters() ? parameters() : null).add("RequestBody", requestBody())
                .add("ActionInvocationType", actionInvocationTypeAsString()).add("AgentId", agentId())
                .add("CollaboratorName", collaboratorName() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionGroup":
            return Optional.ofNullable(clazz.cast(actionGroup()));
        case "httpMethod":
            return Optional.ofNullable(clazz.cast(httpMethod()));
        case "apiPath":
            return Optional.ofNullable(clazz.cast(apiPath()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "requestBody":
            return Optional.ofNullable(clazz.cast(requestBody()));
        case "actionInvocationType":
            return Optional.ofNullable(clazz.cast(actionInvocationTypeAsString()));
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "collaboratorName":
            return Optional.ofNullable(clazz.cast(collaboratorName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionGroup", ACTION_GROUP_FIELD);
        map.put("httpMethod", HTTP_METHOD_FIELD);
        map.put("apiPath", API_PATH_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("requestBody", REQUEST_BODY_FIELD);
        map.put("actionInvocationType", ACTION_INVOCATION_TYPE_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("collaboratorName", COLLABORATOR_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiInvocationInput, T> g) {
        return obj -> g.apply((ApiInvocationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApiInvocationInput> {
        /**
         * <p>
         * The action group that the API operation belongs to.
         * </p>
         * 
         * @param actionGroup
         *        The action group that the API operation belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroup(String actionGroup);

        /**
         * <p>
         * The HTTP method of the API operation.
         * </p>
         * 
         * @param httpMethod
         *        The HTTP method of the API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * The path to the API operation.
         * </p>
         * 
         * @param apiPath
         *        The path to the API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiPath(String apiPath);

        /**
         * <p>
         * The parameters to provide for the API request, as the agent elicited from the user.
         * </p>
         * 
         * @param parameters
         *        The parameters to provide for the API request, as the agent elicited from the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<ApiParameter> parameters);

        /**
         * <p>
         * The parameters to provide for the API request, as the agent elicited from the user.
         * </p>
         * 
         * @param parameters
         *        The parameters to provide for the API request, as the agent elicited from the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ApiParameter... parameters);

        /**
         * <p>
         * The parameters to provide for the API request, as the agent elicited from the user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.ApiParameter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.ApiParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.ApiParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<ApiParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.ApiParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<ApiParameter>)
         */
        Builder parameters(Consumer<ApiParameter.Builder>... parameters);

        /**
         * <p>
         * The request body to provide for the API request, as the agent elicited from the user.
         * </p>
         * 
         * @param requestBody
         *        The request body to provide for the API request, as the agent elicited from the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestBody(ApiRequestBody requestBody);

        /**
         * <p>
         * The request body to provide for the API request, as the agent elicited from the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApiRequestBody.Builder} avoiding the need
         * to create one manually via {@link ApiRequestBody#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApiRequestBody.Builder#build()} is called immediately and its
         * result is passed to {@link #requestBody(ApiRequestBody)}.
         * 
         * @param requestBody
         *        a consumer that will call methods on {@link ApiRequestBody.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestBody(ApiRequestBody)
         */
        default Builder requestBody(Consumer<ApiRequestBody.Builder> requestBody) {
            return requestBody(ApiRequestBody.builder().applyMutation(requestBody).build());
        }

        /**
         * <p>
         * Contains information about the API operation to invoke.
         * </p>
         * 
         * @param actionInvocationType
         *        Contains information about the API operation to invoke.
         * @see ActionInvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionInvocationType
         */
        Builder actionInvocationType(String actionInvocationType);

        /**
         * <p>
         * Contains information about the API operation to invoke.
         * </p>
         * 
         * @param actionInvocationType
         *        Contains information about the API operation to invoke.
         * @see ActionInvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionInvocationType
         */
        Builder actionInvocationType(ActionInvocationType actionInvocationType);

        /**
         * <p>
         * The agent's ID.
         * </p>
         * 
         * @param agentId
         *        The agent's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The agent collaborator's name.
         * </p>
         * 
         * @param collaboratorName
         *        The agent collaborator's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaboratorName(String collaboratorName);
    }

    static final class BuilderImpl implements Builder {
        private String actionGroup;

        private String httpMethod;

        private String apiPath;

        private List<ApiParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private ApiRequestBody requestBody;

        private String actionInvocationType;

        private String agentId;

        private String collaboratorName;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiInvocationInput model) {
            actionGroup(model.actionGroup);
            httpMethod(model.httpMethod);
            apiPath(model.apiPath);
            parameters(model.parameters);
            requestBody(model.requestBody);
            actionInvocationType(model.actionInvocationType);
            agentId(model.agentId);
            collaboratorName(model.collaboratorName);
        }

        public final String getActionGroup() {
            return actionGroup;
        }

        public final void setActionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
        }

        @Override
        public final Builder actionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
            return this;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final String getApiPath() {
            return apiPath;
        }

        public final void setApiPath(String apiPath) {
            this.apiPath = apiPath;
        }

        @Override
        public final Builder apiPath(String apiPath) {
            this.apiPath = apiPath;
            return this;
        }

        public final List<ApiParameter.Builder> getParameters() {
            List<ApiParameter.Builder> result = ApiParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<ApiParameter.BuilderImpl> parameters) {
            this.parameters = ApiParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<ApiParameter> parameters) {
            this.parameters = ApiParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ApiParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<ApiParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> ApiParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ApiRequestBody.Builder getRequestBody() {
            return requestBody != null ? requestBody.toBuilder() : null;
        }

        public final void setRequestBody(ApiRequestBody.BuilderImpl requestBody) {
            this.requestBody = requestBody != null ? requestBody.build() : null;
        }

        @Override
        public final Builder requestBody(ApiRequestBody requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public final String getActionInvocationType() {
            return actionInvocationType;
        }

        public final void setActionInvocationType(String actionInvocationType) {
            this.actionInvocationType = actionInvocationType;
        }

        @Override
        public final Builder actionInvocationType(String actionInvocationType) {
            this.actionInvocationType = actionInvocationType;
            return this;
        }

        @Override
        public final Builder actionInvocationType(ActionInvocationType actionInvocationType) {
            this.actionInvocationType(actionInvocationType == null ? null : actionInvocationType.toString());
            return this;
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getCollaboratorName() {
            return collaboratorName;
        }

        public final void setCollaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
        }

        @Override
        public final Builder collaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
            return this;
        }

        @Override
        public ApiInvocationInput build() {
            return new ApiInvocationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
