/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for an Amazon Bedrock reranker model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BedrockRerankingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BedrockRerankingConfiguration.Builder, BedrockRerankingConfiguration> {
    private static final SdkField<Integer> NUMBER_OF_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfResults").getter(getter(BedrockRerankingConfiguration::numberOfResults))
            .setter(setter(Builder::numberOfResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfResults").build()).build();

    private static final SdkField<BedrockRerankingModelConfiguration> MODEL_CONFIGURATION_FIELD = SdkField
            .<BedrockRerankingModelConfiguration> builder(MarshallingType.SDK_POJO).memberName("modelConfiguration")
            .getter(getter(BedrockRerankingConfiguration::modelConfiguration)).setter(setter(Builder::modelConfiguration))
            .constructor(BedrockRerankingModelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_RESULTS_FIELD,
            MODEL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer numberOfResults;

    private final BedrockRerankingModelConfiguration modelConfiguration;

    private BedrockRerankingConfiguration(BuilderImpl builder) {
        this.numberOfResults = builder.numberOfResults;
        this.modelConfiguration = builder.modelConfiguration;
    }

    /**
     * <p>
     * The number of results to return after reranking.
     * </p>
     * 
     * @return The number of results to return after reranking.
     */
    public final Integer numberOfResults() {
        return numberOfResults;
    }

    /**
     * <p>
     * Contains configurations for a reranker model.
     * </p>
     * 
     * @return Contains configurations for a reranker model.
     */
    public final BedrockRerankingModelConfiguration modelConfiguration() {
        return modelConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfResults());
        hashCode = 31 * hashCode + Objects.hashCode(modelConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockRerankingConfiguration)) {
            return false;
        }
        BedrockRerankingConfiguration other = (BedrockRerankingConfiguration) obj;
        return Objects.equals(numberOfResults(), other.numberOfResults())
                && Objects.equals(modelConfiguration(), other.modelConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BedrockRerankingConfiguration").add("NumberOfResults", numberOfResults())
                .add("ModelConfiguration", modelConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "numberOfResults":
            return Optional.ofNullable(clazz.cast(numberOfResults()));
        case "modelConfiguration":
            return Optional.ofNullable(clazz.cast(modelConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("numberOfResults", NUMBER_OF_RESULTS_FIELD);
        map.put("modelConfiguration", MODEL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BedrockRerankingConfiguration, T> g) {
        return obj -> g.apply((BedrockRerankingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BedrockRerankingConfiguration> {
        /**
         * <p>
         * The number of results to return after reranking.
         * </p>
         * 
         * @param numberOfResults
         *        The number of results to return after reranking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfResults(Integer numberOfResults);

        /**
         * <p>
         * Contains configurations for a reranker model.
         * </p>
         * 
         * @param modelConfiguration
         *        Contains configurations for a reranker model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelConfiguration(BedrockRerankingModelConfiguration modelConfiguration);

        /**
         * <p>
         * Contains configurations for a reranker model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BedrockRerankingModelConfiguration.Builder} avoiding the need to create one manually via
         * {@link BedrockRerankingModelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BedrockRerankingModelConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #modelConfiguration(BedrockRerankingModelConfiguration)}.
         * 
         * @param modelConfiguration
         *        a consumer that will call methods on {@link BedrockRerankingModelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelConfiguration(BedrockRerankingModelConfiguration)
         */
        default Builder modelConfiguration(Consumer<BedrockRerankingModelConfiguration.Builder> modelConfiguration) {
            return modelConfiguration(BedrockRerankingModelConfiguration.builder().applyMutation(modelConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer numberOfResults;

        private BedrockRerankingModelConfiguration modelConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockRerankingConfiguration model) {
            numberOfResults(model.numberOfResults);
            modelConfiguration(model.modelConfiguration);
        }

        public final Integer getNumberOfResults() {
            return numberOfResults;
        }

        public final void setNumberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
        }

        @Override
        public final Builder numberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
            return this;
        }

        public final BedrockRerankingModelConfiguration.Builder getModelConfiguration() {
            return modelConfiguration != null ? modelConfiguration.toBuilder() : null;
        }

        public final void setModelConfiguration(BedrockRerankingModelConfiguration.BuilderImpl modelConfiguration) {
            this.modelConfiguration = modelConfiguration != null ? modelConfiguration.build() : null;
        }

        @Override
        public final Builder modelConfiguration(BedrockRerankingModelConfiguration modelConfiguration) {
            this.modelConfiguration = modelConfiguration;
            return this;
        }

        @Override
        public BedrockRerankingConfiguration build() {
            return new BedrockRerankingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
