/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This property contains the document to chat with, along with its attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ByteContentDoc implements SdkPojo, Serializable, ToCopyableBuilder<ByteContentDoc.Builder, ByteContentDoc> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(ByteContentDoc::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(ByteContentDoc::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("data").getter(getter(ByteContentDoc::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            CONTENT_TYPE_FIELD, DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final String contentType;

    private final SdkBytes data;

    private ByteContentDoc(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.contentType = builder.contentType;
        this.data = builder.data;
    }

    /**
     * <p>
     * The file name of the document contained in the wrapper object.
     * </p>
     * 
     * @return The file name of the document contained in the wrapper object.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The MIME type of the document contained in the wrapper object.
     * </p>
     * 
     * @return The MIME type of the document contained in the wrapper object.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The byte value of the file to upload, encoded as a Base-64 string.
     * </p>
     * 
     * @return The byte value of the file to upload, encoded as a Base-64 string.
     */
    public final SdkBytes data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteContentDoc)) {
            return false;
        }
        ByteContentDoc other = (ByteContentDoc) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ByteContentDoc")
                .add("Identifier", identifier() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContentType", contentType()).add("Data", data() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        map.put("data", DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ByteContentDoc, T> g) {
        return obj -> g.apply((ByteContentDoc) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ByteContentDoc> {
        /**
         * <p>
         * The file name of the document contained in the wrapper object.
         * </p>
         * 
         * @param identifier
         *        The file name of the document contained in the wrapper object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The MIME type of the document contained in the wrapper object.
         * </p>
         * 
         * @param contentType
         *        The MIME type of the document contained in the wrapper object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The byte value of the file to upload, encoded as a Base-64 string.
         * </p>
         * 
         * @param data
         *        The byte value of the file to upload, encoded as a Base-64 string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(SdkBytes data);
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private String contentType;

        private SdkBytes data;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteContentDoc model) {
            identifier(model.identifier);
            contentType(model.contentType);
            data(model.data);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final ByteBuffer getData() {
            return data == null ? null : data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            data(data == null ? null : SdkBytes.fromByteBuffer(data));
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        @Override
        public ByteContentDoc build() {
            return new ByteContentDoc(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
