/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the JSON-formatted string returned by the API invoked by the code interpreter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeInterpreterInvocationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeInterpreterInvocationOutput.Builder, CodeInterpreterInvocationOutput> {
    private static final SdkField<String> EXECUTION_OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionOutput").getter(getter(CodeInterpreterInvocationOutput::executionOutput))
            .setter(setter(Builder::executionOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionOutput").build()).build();

    private static final SdkField<String> EXECUTION_ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionError").getter(getter(CodeInterpreterInvocationOutput::executionError))
            .setter(setter(Builder::executionError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionError").build()).build();

    private static final SdkField<List<String>> FILES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("files")
            .getter(getter(CodeInterpreterInvocationOutput::files))
            .setter(setter(Builder::files))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> EXECUTION_TIMEOUT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("executionTimeout").getter(getter(CodeInterpreterInvocationOutput::executionTimeout))
            .setter(setter(Builder::executionTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTimeout").build()).build();

    private static final SdkField<Metadata> METADATA_FIELD = SdkField.<Metadata> builder(MarshallingType.SDK_POJO)
            .memberName("metadata").getter(getter(CodeInterpreterInvocationOutput::metadata)).setter(setter(Builder::metadata))
            .constructor(Metadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_OUTPUT_FIELD,
            EXECUTION_ERROR_FIELD, FILES_FIELD, EXECUTION_TIMEOUT_FIELD, METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String executionOutput;

    private final String executionError;

    private final List<String> files;

    private final Boolean executionTimeout;

    private final Metadata metadata;

    private CodeInterpreterInvocationOutput(BuilderImpl builder) {
        this.executionOutput = builder.executionOutput;
        this.executionError = builder.executionError;
        this.files = builder.files;
        this.executionTimeout = builder.executionTimeout;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * Contains the successful output returned from code execution
     * </p>
     * 
     * @return Contains the successful output returned from code execution
     */
    public final String executionOutput() {
        return executionOutput;
    }

    /**
     * <p>
     * Contains the error returned from code execution.
     * </p>
     * 
     * @return Contains the error returned from code execution.
     */
    public final String executionError() {
        return executionError;
    }

    /**
     * For responses, this returns true if the service returned a value for the Files property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFiles() {
        return files != null && !(files instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains output files, if generated by code execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFiles} method.
     * </p>
     * 
     * @return Contains output files, if generated by code execution.
     */
    public final List<String> files() {
        return files;
    }

    /**
     * <p>
     * Indicates if the execution of the code timed out.
     * </p>
     * 
     * @return Indicates if the execution of the code timed out.
     */
    public final Boolean executionTimeout() {
        return executionTimeout;
    }

    /**
     * <p>
     * Contains information about the output from the code interpreter.
     * </p>
     * 
     * @return Contains information about the output from the code interpreter.
     */
    public final Metadata metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionOutput());
        hashCode = 31 * hashCode + Objects.hashCode(executionError());
        hashCode = 31 * hashCode + Objects.hashCode(hasFiles() ? files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeInterpreterInvocationOutput)) {
            return false;
        }
        CodeInterpreterInvocationOutput other = (CodeInterpreterInvocationOutput) obj;
        return Objects.equals(executionOutput(), other.executionOutput())
                && Objects.equals(executionError(), other.executionError()) && hasFiles() == other.hasFiles()
                && Objects.equals(files(), other.files()) && Objects.equals(executionTimeout(), other.executionTimeout())
                && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeInterpreterInvocationOutput").add("ExecutionOutput", executionOutput())
                .add("ExecutionError", executionError()).add("Files", hasFiles() ? files() : null)
                .add("ExecutionTimeout", executionTimeout())
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionOutput":
            return Optional.ofNullable(clazz.cast(executionOutput()));
        case "executionError":
            return Optional.ofNullable(clazz.cast(executionError()));
        case "files":
            return Optional.ofNullable(clazz.cast(files()));
        case "executionTimeout":
            return Optional.ofNullable(clazz.cast(executionTimeout()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionOutput", EXECUTION_OUTPUT_FIELD);
        map.put("executionError", EXECUTION_ERROR_FIELD);
        map.put("files", FILES_FIELD);
        map.put("executionTimeout", EXECUTION_TIMEOUT_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeInterpreterInvocationOutput, T> g) {
        return obj -> g.apply((CodeInterpreterInvocationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeInterpreterInvocationOutput> {
        /**
         * <p>
         * Contains the successful output returned from code execution
         * </p>
         * 
         * @param executionOutput
         *        Contains the successful output returned from code execution
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionOutput(String executionOutput);

        /**
         * <p>
         * Contains the error returned from code execution.
         * </p>
         * 
         * @param executionError
         *        Contains the error returned from code execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionError(String executionError);

        /**
         * <p>
         * Contains output files, if generated by code execution.
         * </p>
         * 
         * @param files
         *        Contains output files, if generated by code execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(Collection<String> files);

        /**
         * <p>
         * Contains output files, if generated by code execution.
         * </p>
         * 
         * @param files
         *        Contains output files, if generated by code execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(String... files);

        /**
         * <p>
         * Indicates if the execution of the code timed out.
         * </p>
         * 
         * @param executionTimeout
         *        Indicates if the execution of the code timed out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTimeout(Boolean executionTimeout);

        /**
         * <p>
         * Contains information about the output from the code interpreter.
         * </p>
         * 
         * @param metadata
         *        Contains information about the output from the code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Metadata metadata);

        /**
         * <p>
         * Contains information about the output from the code interpreter.
         * </p>
         * This is a convenience method that creates an instance of the {@link Metadata.Builder} avoiding the need to
         * create one manually via {@link Metadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Metadata.Builder#build()} is called immediately and its result is
         * passed to {@link #metadata(Metadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link Metadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(Metadata)
         */
        default Builder metadata(Consumer<Metadata.Builder> metadata) {
            return metadata(Metadata.builder().applyMutation(metadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String executionOutput;

        private String executionError;

        private List<String> files = DefaultSdkAutoConstructList.getInstance();

        private Boolean executionTimeout;

        private Metadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeInterpreterInvocationOutput model) {
            executionOutput(model.executionOutput);
            executionError(model.executionError);
            files(model.files);
            executionTimeout(model.executionTimeout);
            metadata(model.metadata);
        }

        public final String getExecutionOutput() {
            return executionOutput;
        }

        public final void setExecutionOutput(String executionOutput) {
            this.executionOutput = executionOutput;
        }

        @Override
        public final Builder executionOutput(String executionOutput) {
            this.executionOutput = executionOutput;
            return this;
        }

        public final String getExecutionError() {
            return executionError;
        }

        public final void setExecutionError(String executionError) {
            this.executionError = executionError;
        }

        @Override
        public final Builder executionError(String executionError) {
            this.executionError = executionError;
            return this;
        }

        public final Collection<String> getFiles() {
            if (files instanceof SdkAutoConstructList) {
                return null;
            }
            return files;
        }

        public final void setFiles(Collection<String> files) {
            this.files = FilesCopier.copy(files);
        }

        @Override
        public final Builder files(Collection<String> files) {
            this.files = FilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(String... files) {
            files(Arrays.asList(files));
            return this;
        }

        public final Boolean getExecutionTimeout() {
            return executionTimeout;
        }

        public final void setExecutionTimeout(Boolean executionTimeout) {
            this.executionTimeout = executionTimeout;
        }

        @Override
        public final Builder executionTimeout(Boolean executionTimeout) {
            this.executionTimeout = executionTimeout;
            return this;
        }

        public final Metadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(Metadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public CodeInterpreterInvocationOutput build() {
            return new CodeInterpreterInvocationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
