/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInvocationResponse extends BedrockAgentRuntimeResponse implements
        ToCopyableBuilder<CreateInvocationResponse.Builder, CreateInvocationResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(CreateInvocationResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invocationId").getter(getter(CreateInvocationResponse::invocationId))
            .setter(setter(Builder::invocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CreateInvocationResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            INVOCATION_ID_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionId;

    private final String invocationId;

    private final Instant createdAt;

    private CreateInvocationResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.invocationId = builder.invocationId;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The unique identifier for the session associated with the invocation.
     * </p>
     * 
     * @return The unique identifier for the session associated with the invocation.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The unique identifier for the invocation.
     * </p>
     * 
     * @return The unique identifier for the invocation.
     */
    public final String invocationId() {
        return invocationId;
    }

    /**
     * <p>
     * The timestamp for when the invocation was created.
     * </p>
     * 
     * @return The timestamp for when the invocation was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(invocationId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvocationResponse)) {
            return false;
        }
        CreateInvocationResponse other = (CreateInvocationResponse) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(invocationId(), other.invocationId())
                && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInvocationResponse").add("SessionId", sessionId()).add("InvocationId", invocationId())
                .add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "invocationId":
            return Optional.ofNullable(clazz.cast(invocationId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("invocationId", INVOCATION_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInvocationResponse, T> g) {
        return obj -> g.apply((CreateInvocationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateInvocationResponse> {
        /**
         * <p>
         * The unique identifier for the session associated with the invocation.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier for the session associated with the invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The unique identifier for the invocation.
         * </p>
         * 
         * @param invocationId
         *        The unique identifier for the invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationId(String invocationId);

        /**
         * <p>
         * The timestamp for when the invocation was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp for when the invocation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeResponse.BuilderImpl implements Builder {
        private String sessionId;

        private String invocationId;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvocationResponse model) {
            super(model);
            sessionId(model.sessionId);
            invocationId(model.invocationId);
            createdAt(model.createdAt);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getInvocationId() {
            return invocationId;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public CreateInvocationResponse build() {
            return new CreateInvocationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
