/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultInvokeFlowVisitorBuilder implements InvokeFlowResponseHandler.Visitor.Builder {
    private Consumer<FlowResponseStream> onDefault;

    private Consumer<FlowOutputEvent> onFlowOutputEvent;

    private Consumer<FlowCompletionEvent> onFlowCompletionEvent;

    private Consumer<FlowTraceEvent> onFlowTraceEvent;

    private Consumer<FlowMultiTurnInputRequestEvent> onFlowMultiTurnInputRequestEvent;

    @Override
    public InvokeFlowResponseHandler.Visitor.Builder onDefault(Consumer<FlowResponseStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public InvokeFlowResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public InvokeFlowResponseHandler.Visitor.Builder onFlowOutputEvent(Consumer<FlowOutputEvent> c) {
        this.onFlowOutputEvent = c;
        return this;
    }

    @Override
    public InvokeFlowResponseHandler.Visitor.Builder onFlowCompletionEvent(Consumer<FlowCompletionEvent> c) {
        this.onFlowCompletionEvent = c;
        return this;
    }

    @Override
    public InvokeFlowResponseHandler.Visitor.Builder onFlowTraceEvent(Consumer<FlowTraceEvent> c) {
        this.onFlowTraceEvent = c;
        return this;
    }

    @Override
    public InvokeFlowResponseHandler.Visitor.Builder onFlowMultiTurnInputRequestEvent(Consumer<FlowMultiTurnInputRequestEvent> c) {
        this.onFlowMultiTurnInputRequestEvent = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements InvokeFlowResponseHandler.Visitor {
        private final Consumer<FlowResponseStream> onDefault;

        private final Consumer<FlowOutputEvent> onFlowOutputEvent;

        private final Consumer<FlowCompletionEvent> onFlowCompletionEvent;

        private final Consumer<FlowTraceEvent> onFlowTraceEvent;

        private final Consumer<FlowMultiTurnInputRequestEvent> onFlowMultiTurnInputRequestEvent;

        VisitorFromBuilder(DefaultInvokeFlowVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : InvokeFlowResponseHandler.Visitor.super::visitDefault;
            this.onFlowOutputEvent = builder.onFlowOutputEvent != null ? builder.onFlowOutputEvent
                    : InvokeFlowResponseHandler.Visitor.super::visitFlowOutputEvent;
            this.onFlowCompletionEvent = builder.onFlowCompletionEvent != null ? builder.onFlowCompletionEvent
                    : InvokeFlowResponseHandler.Visitor.super::visitFlowCompletionEvent;
            this.onFlowTraceEvent = builder.onFlowTraceEvent != null ? builder.onFlowTraceEvent
                    : InvokeFlowResponseHandler.Visitor.super::visitFlowTraceEvent;
            this.onFlowMultiTurnInputRequestEvent = builder.onFlowMultiTurnInputRequestEvent != null ? builder.onFlowMultiTurnInputRequestEvent
                    : InvokeFlowResponseHandler.Visitor.super::visitFlowMultiTurnInputRequestEvent;
        }

        @Override
        public void visitDefault(FlowResponseStream event) {
            onDefault.accept(event);
        }

        @Override
        public void visitFlowOutputEvent(FlowOutputEvent event) {
            onFlowOutputEvent.accept(event);
        }

        @Override
        public void visitFlowCompletionEvent(FlowCompletionEvent event) {
            onFlowCompletionEvent.accept(event);
        }

        @Override
        public void visitFlowTraceEvent(FlowTraceEvent event) {
            onFlowTraceEvent.accept(event);
        }

        @Override
        public void visitFlowMultiTurnInputRequestEvent(FlowMultiTurnInputRequestEvent event) {
            onFlowMultiTurnInputRequestEvent.accept(event);
        }
    }
}
