/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultInvokeInlineAgentVisitorBuilder implements InvokeInlineAgentResponseHandler.Visitor.Builder {
    private Consumer<InlineAgentResponseStream> onDefault;

    private Consumer<InlineAgentPayloadPart> onChunk;

    private Consumer<InlineAgentTracePart> onTrace;

    private Consumer<InlineAgentReturnControlPayload> onReturnControl;

    private Consumer<InlineAgentFilePart> onFiles;

    @Override
    public InvokeInlineAgentResponseHandler.Visitor.Builder onDefault(Consumer<InlineAgentResponseStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public InvokeInlineAgentResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public InvokeInlineAgentResponseHandler.Visitor.Builder onChunk(Consumer<InlineAgentPayloadPart> c) {
        this.onChunk = c;
        return this;
    }

    @Override
    public InvokeInlineAgentResponseHandler.Visitor.Builder onTrace(Consumer<InlineAgentTracePart> c) {
        this.onTrace = c;
        return this;
    }

    @Override
    public InvokeInlineAgentResponseHandler.Visitor.Builder onReturnControl(Consumer<InlineAgentReturnControlPayload> c) {
        this.onReturnControl = c;
        return this;
    }

    @Override
    public InvokeInlineAgentResponseHandler.Visitor.Builder onFiles(Consumer<InlineAgentFilePart> c) {
        this.onFiles = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements InvokeInlineAgentResponseHandler.Visitor {
        private final Consumer<InlineAgentResponseStream> onDefault;

        private final Consumer<InlineAgentPayloadPart> onChunk;

        private final Consumer<InlineAgentTracePart> onTrace;

        private final Consumer<InlineAgentReturnControlPayload> onReturnControl;

        private final Consumer<InlineAgentFilePart> onFiles;

        VisitorFromBuilder(DefaultInvokeInlineAgentVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : InvokeInlineAgentResponseHandler.Visitor.super::visitDefault;
            this.onChunk = builder.onChunk != null ? builder.onChunk : InvokeInlineAgentResponseHandler.Visitor.super::visitChunk;
            this.onTrace = builder.onTrace != null ? builder.onTrace : InvokeInlineAgentResponseHandler.Visitor.super::visitTrace;
            this.onReturnControl = builder.onReturnControl != null ? builder.onReturnControl
                    : InvokeInlineAgentResponseHandler.Visitor.super::visitReturnControl;
            this.onFiles = builder.onFiles != null ? builder.onFiles : InvokeInlineAgentResponseHandler.Visitor.super::visitFiles;
        }

        @Override
        public void visitDefault(InlineAgentResponseStream event) {
            onDefault.accept(event);
        }

        @Override
        public void visitChunk(InlineAgentPayloadPart event) {
            onChunk.accept(event);
        }

        @Override
        public void visitTrace(InlineAgentTracePart event) {
            onTrace.accept(event);
        }

        @Override
        public void visitReturnControl(InlineAgentReturnControlPayload event) {
            onReturnControl.accept(event);
        }

        @Override
        public void visitFiles(InlineAgentFilePart event) {
            onFiles.accept(event);
        }
    }
}
