/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultOptimizePromptVisitorBuilder implements OptimizePromptResponseHandler.Visitor.Builder {
    private Consumer<OptimizedPromptStream> onDefault;

    private Consumer<OptimizedPromptEvent> onOptimizedPromptEvent;

    private Consumer<AnalyzePromptEvent> onAnalyzePromptEvent;

    @Override
    public OptimizePromptResponseHandler.Visitor.Builder onDefault(Consumer<OptimizedPromptStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public OptimizePromptResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public OptimizePromptResponseHandler.Visitor.Builder onOptimizedPromptEvent(Consumer<OptimizedPromptEvent> c) {
        this.onOptimizedPromptEvent = c;
        return this;
    }

    @Override
    public OptimizePromptResponseHandler.Visitor.Builder onAnalyzePromptEvent(Consumer<AnalyzePromptEvent> c) {
        this.onAnalyzePromptEvent = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements OptimizePromptResponseHandler.Visitor {
        private final Consumer<OptimizedPromptStream> onDefault;

        private final Consumer<OptimizedPromptEvent> onOptimizedPromptEvent;

        private final Consumer<AnalyzePromptEvent> onAnalyzePromptEvent;

        VisitorFromBuilder(DefaultOptimizePromptVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : OptimizePromptResponseHandler.Visitor.super::visitDefault;
            this.onOptimizedPromptEvent = builder.onOptimizedPromptEvent != null ? builder.onOptimizedPromptEvent
                    : OptimizePromptResponseHandler.Visitor.super::visitOptimizedPromptEvent;
            this.onAnalyzePromptEvent = builder.onAnalyzePromptEvent != null ? builder.onAnalyzePromptEvent
                    : OptimizePromptResponseHandler.Visitor.super::visitAnalyzePromptEvent;
        }

        @Override
        public void visitDefault(OptimizedPromptStream event) {
            onDefault.accept(event);
        }

        @Override
        public void visitOptimizedPromptEvent(OptimizedPromptEvent event) {
            onOptimizedPromptEvent.accept(event);
        }

        @Override
        public void visitAnalyzePromptEvent(AnalyzePromptEvent event) {
            onAnalyzePromptEvent.accept(event);
        }
    }
}
