/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The unique external source of the content contained in the wrapper object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalSource implements SdkPojo, Serializable, ToCopyableBuilder<ExternalSource.Builder, ExternalSource> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceType").getter(getter(ExternalSource::sourceTypeAsString)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()).build();

    private static final SdkField<S3ObjectDoc> S3_LOCATION_FIELD = SdkField.<S3ObjectDoc> builder(MarshallingType.SDK_POJO)
            .memberName("s3Location").getter(getter(ExternalSource::s3Location)).setter(setter(Builder::s3Location))
            .constructor(S3ObjectDoc::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()).build();

    private static final SdkField<ByteContentDoc> BYTE_CONTENT_FIELD = SdkField
            .<ByteContentDoc> builder(MarshallingType.SDK_POJO).memberName("byteContent")
            .getter(getter(ExternalSource::byteContent)).setter(setter(Builder::byteContent))
            .constructor(ByteContentDoc::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("byteContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD,
            S3_LOCATION_FIELD, BYTE_CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceType;

    private final S3ObjectDoc s3Location;

    private final ByteContentDoc byteContent;

    private ExternalSource(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.s3Location = builder.s3Location;
        this.byteContent = builder.byteContent;
    }

    /**
     * <p>
     * The source type of the external source wrapper object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link ExternalSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The source type of the external source wrapper object.
     * @see ExternalSourceType
     */
    public final ExternalSourceType sourceType() {
        return ExternalSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The source type of the external source wrapper object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link ExternalSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The source type of the external source wrapper object.
     * @see ExternalSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * The S3 location of the external source wrapper object.
     * </p>
     * 
     * @return The S3 location of the external source wrapper object.
     */
    public final S3ObjectDoc s3Location() {
        return s3Location;
    }

    /**
     * <p>
     * The identifier, contentType, and data of the external source wrapper object.
     * </p>
     * 
     * @return The identifier, contentType, and data of the external source wrapper object.
     */
    public final ByteContentDoc byteContent() {
        return byteContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(byteContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalSource)) {
            return false;
        }
        ExternalSource other = (ExternalSource) obj;
        return Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(s3Location(), other.s3Location()) && Objects.equals(byteContent(), other.byteContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalSource").add("SourceType", sourceTypeAsString()).add("S3Location", s3Location())
                .add("ByteContent", byteContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "s3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        case "byteContent":
            return Optional.ofNullable(clazz.cast(byteContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceType", SOURCE_TYPE_FIELD);
        map.put("s3Location", S3_LOCATION_FIELD);
        map.put("byteContent", BYTE_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExternalSource, T> g) {
        return obj -> g.apply((ExternalSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalSource> {
        /**
         * <p>
         * The source type of the external source wrapper object.
         * </p>
         * 
         * @param sourceType
         *        The source type of the external source wrapper object.
         * @see ExternalSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExternalSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The source type of the external source wrapper object.
         * </p>
         * 
         * @param sourceType
         *        The source type of the external source wrapper object.
         * @see ExternalSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExternalSourceType
         */
        Builder sourceType(ExternalSourceType sourceType);

        /**
         * <p>
         * The S3 location of the external source wrapper object.
         * </p>
         * 
         * @param s3Location
         *        The S3 location of the external source wrapper object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(S3ObjectDoc s3Location);

        /**
         * <p>
         * The S3 location of the external source wrapper object.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ObjectDoc.Builder} avoiding the need to
         * create one manually via {@link S3ObjectDoc#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ObjectDoc.Builder#build()} is called immediately and its result
         * is passed to {@link #s3Location(S3ObjectDoc)}.
         * 
         * @param s3Location
         *        a consumer that will call methods on {@link S3ObjectDoc.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Location(S3ObjectDoc)
         */
        default Builder s3Location(Consumer<S3ObjectDoc.Builder> s3Location) {
            return s3Location(S3ObjectDoc.builder().applyMutation(s3Location).build());
        }

        /**
         * <p>
         * The identifier, contentType, and data of the external source wrapper object.
         * </p>
         * 
         * @param byteContent
         *        The identifier, contentType, and data of the external source wrapper object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteContent(ByteContentDoc byteContent);

        /**
         * <p>
         * The identifier, contentType, and data of the external source wrapper object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ByteContentDoc.Builder} avoiding the need
         * to create one manually via {@link ByteContentDoc#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ByteContentDoc.Builder#build()} is called immediately and its
         * result is passed to {@link #byteContent(ByteContentDoc)}.
         * 
         * @param byteContent
         *        a consumer that will call methods on {@link ByteContentDoc.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #byteContent(ByteContentDoc)
         */
        default Builder byteContent(Consumer<ByteContentDoc.Builder> byteContent) {
            return byteContent(ByteContentDoc.builder().applyMutation(byteContent).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sourceType;

        private S3ObjectDoc s3Location;

        private ByteContentDoc byteContent;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalSource model) {
            sourceType(model.sourceType);
            s3Location(model.s3Location);
            byteContent(model.byteContent);
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(ExternalSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final S3ObjectDoc.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        public final void setS3Location(S3ObjectDoc.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(S3ObjectDoc s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final ByteContentDoc.Builder getByteContent() {
            return byteContent != null ? byteContent.toBuilder() : null;
        }

        public final void setByteContent(ByteContentDoc.BuilderImpl byteContent) {
            this.byteContent = byteContent != null ? byteContent.build() : null;
        }

        @Override
        public final Builder byteContent(ByteContentDoc byteContent) {
            this.byteContent = byteContent;
            return this;
        }

        @Override
        public ExternalSource build() {
            return new ExternalSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
