/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a flow execution, including its status, timestamps, and identifiers.
 * </p>
 * <note>
 * <p>
 * Flow executions is in preview release for Amazon Bedrock and is subject to change.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowExecutionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowExecutionSummary.Builder, FlowExecutionSummary> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionArn").getter(getter(FlowExecutionSummary::executionArn)).setter(setter(Builder::executionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()).build();

    private static final SdkField<String> FLOW_ALIAS_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowAliasIdentifier").getter(getter(FlowExecutionSummary::flowAliasIdentifier))
            .setter(setter(Builder::flowAliasIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowAliasIdentifier").build())
            .build();

    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowIdentifier").getter(getter(FlowExecutionSummary::flowIdentifier))
            .setter(setter(Builder::flowIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowIdentifier").build()).build();

    private static final SdkField<String> FLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowVersion").getter(getter(FlowExecutionSummary::flowVersion)).setter(setter(Builder::flowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(FlowExecutionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(FlowExecutionSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(FlowExecutionSummary::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD,
            FLOW_ALIAS_IDENTIFIER_FIELD, FLOW_IDENTIFIER_FIELD, FLOW_VERSION_FIELD, STATUS_FIELD, CREATED_AT_FIELD,
            ENDED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String executionArn;

    private final String flowAliasIdentifier;

    private final String flowIdentifier;

    private final String flowVersion;

    private final String status;

    private final Instant createdAt;

    private final Instant endedAt;

    private FlowExecutionSummary(BuilderImpl builder) {
        this.executionArn = builder.executionArn;
        this.flowAliasIdentifier = builder.flowAliasIdentifier;
        this.flowIdentifier = builder.flowIdentifier;
        this.flowVersion = builder.flowVersion;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.endedAt = builder.endedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the flow execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies the flow execution.
     */
    public final String executionArn() {
        return executionArn;
    }

    /**
     * <p>
     * The unique identifier of the flow alias used for the execution.
     * </p>
     * 
     * @return The unique identifier of the flow alias used for the execution.
     */
    public final String flowAliasIdentifier() {
        return flowAliasIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the flow.
     * </p>
     * 
     * @return The unique identifier of the flow.
     */
    public final String flowIdentifier() {
        return flowIdentifier;
    }

    /**
     * <p>
     * The version of the flow used for the execution.
     * </p>
     * 
     * @return The version of the flow used for the execution.
     */
    public final String flowVersion() {
        return flowVersion;
    }

    /**
     * <p>
     * The current status of the flow execution.
     * </p>
     * <p>
     * Flow executions time out after 24 hours.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the flow execution.</p>
     *         <p>
     *         Flow executions time out after 24 hours.
     * @see FlowExecutionStatus
     */
    public final FlowExecutionStatus status() {
        return FlowExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the flow execution.
     * </p>
     * <p>
     * Flow executions time out after 24 hours.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the flow execution.</p>
     *         <p>
     *         Flow executions time out after 24 hours.
     * @see FlowExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the flow execution was created.
     * </p>
     * 
     * @return The timestamp when the flow execution was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the flow execution ended. This field is only populated when the execution has completed,
     * failed, timed out, or been aborted.
     * </p>
     * 
     * @return The timestamp when the flow execution ended. This field is only populated when the execution has
     *         completed, failed, timed out, or been aborted.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowAliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(flowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowExecutionSummary)) {
            return false;
        }
        FlowExecutionSummary other = (FlowExecutionSummary) obj;
        return Objects.equals(executionArn(), other.executionArn())
                && Objects.equals(flowAliasIdentifier(), other.flowAliasIdentifier())
                && Objects.equals(flowIdentifier(), other.flowIdentifier()) && Objects.equals(flowVersion(), other.flowVersion())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(endedAt(), other.endedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowExecutionSummary").add("ExecutionArn", executionArn())
                .add("FlowAliasIdentifier", flowAliasIdentifier()).add("FlowIdentifier", flowIdentifier())
                .add("FlowVersion", flowVersion()).add("Status", statusAsString()).add("CreatedAt", createdAt())
                .add("EndedAt", endedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionArn":
            return Optional.ofNullable(clazz.cast(executionArn()));
        case "flowAliasIdentifier":
            return Optional.ofNullable(clazz.cast(flowAliasIdentifier()));
        case "flowIdentifier":
            return Optional.ofNullable(clazz.cast(flowIdentifier()));
        case "flowVersion":
            return Optional.ofNullable(clazz.cast(flowVersion()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionArn", EXECUTION_ARN_FIELD);
        map.put("flowAliasIdentifier", FLOW_ALIAS_IDENTIFIER_FIELD);
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("flowVersion", FLOW_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowExecutionSummary, T> g) {
        return obj -> g.apply((FlowExecutionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowExecutionSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the flow execution.
         * </p>
         * 
         * @param executionArn
         *        The Amazon Resource Name (ARN) that uniquely identifies the flow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionArn(String executionArn);

        /**
         * <p>
         * The unique identifier of the flow alias used for the execution.
         * </p>
         * 
         * @param flowAliasIdentifier
         *        The unique identifier of the flow alias used for the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowAliasIdentifier(String flowAliasIdentifier);

        /**
         * <p>
         * The unique identifier of the flow.
         * </p>
         * 
         * @param flowIdentifier
         *        The unique identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowIdentifier(String flowIdentifier);

        /**
         * <p>
         * The version of the flow used for the execution.
         * </p>
         * 
         * @param flowVersion
         *        The version of the flow used for the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowVersion(String flowVersion);

        /**
         * <p>
         * The current status of the flow execution.
         * </p>
         * <p>
         * Flow executions time out after 24 hours.
         * </p>
         * 
         * @param status
         *        The current status of the flow execution.</p>
         *        <p>
         *        Flow executions time out after 24 hours.
         * @see FlowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the flow execution.
         * </p>
         * <p>
         * Flow executions time out after 24 hours.
         * </p>
         * 
         * @param status
         *        The current status of the flow execution.</p>
         *        <p>
         *        Flow executions time out after 24 hours.
         * @see FlowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowExecutionStatus
         */
        Builder status(FlowExecutionStatus status);

        /**
         * <p>
         * The timestamp when the flow execution was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the flow execution was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the flow execution ended. This field is only populated when the execution has completed,
         * failed, timed out, or been aborted.
         * </p>
         * 
         * @param endedAt
         *        The timestamp when the flow execution ended. This field is only populated when the execution has
         *        completed, failed, timed out, or been aborted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);
    }

    static final class BuilderImpl implements Builder {
        private String executionArn;

        private String flowAliasIdentifier;

        private String flowIdentifier;

        private String flowVersion;

        private String status;

        private Instant createdAt;

        private Instant endedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowExecutionSummary model) {
            executionArn(model.executionArn);
            flowAliasIdentifier(model.flowAliasIdentifier);
            flowIdentifier(model.flowIdentifier);
            flowVersion(model.flowVersion);
            status(model.status);
            createdAt(model.createdAt);
            endedAt(model.endedAt);
        }

        public final String getExecutionArn() {
            return executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final String getFlowAliasIdentifier() {
            return flowAliasIdentifier;
        }

        public final void setFlowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
        }

        @Override
        public final Builder flowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
            return this;
        }

        public final String getFlowIdentifier() {
            return flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final String getFlowVersion() {
            return flowVersion;
        }

        public final void setFlowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
        }

        @Override
        public final Builder flowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlowExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        @Override
        public FlowExecutionSummary build() {
            return new FlowExecutionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
