/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an input into the prompt flow and where to send it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowInput implements SdkPojo, Serializable, ToCopyableBuilder<FlowInput.Builder, FlowInput> {
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(FlowInput::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final SdkField<String> NODE_OUTPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeOutputName").getter(getter(FlowInput::nodeOutputName)).setter(setter(Builder::nodeOutputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeOutputName").build()).build();

    private static final SdkField<FlowInputContent> CONTENT_FIELD = SdkField.<FlowInputContent> builder(MarshallingType.SDK_POJO)
            .memberName("content").getter(getter(FlowInput::content)).setter(setter(Builder::content))
            .constructor(FlowInputContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> NODE_INPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeInputName").getter(getter(FlowInput::nodeInputName)).setter(setter(Builder::nodeInputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInputName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_NAME_FIELD,
            NODE_OUTPUT_NAME_FIELD, CONTENT_FIELD, NODE_INPUT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodeName;

    private final String nodeOutputName;

    private final FlowInputContent content;

    private final String nodeInputName;

    private FlowInput(BuilderImpl builder) {
        this.nodeName = builder.nodeName;
        this.nodeOutputName = builder.nodeOutputName;
        this.content = builder.content;
        this.nodeInputName = builder.nodeInputName;
    }

    /**
     * <p>
     * The name of the flow input node that begins the prompt flow.
     * </p>
     * 
     * @return The name of the flow input node that begins the prompt flow.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * The name of the output from the flow input node that begins the prompt flow.
     * </p>
     * 
     * @return The name of the output from the flow input node that begins the prompt flow.
     */
    public final String nodeOutputName() {
        return nodeOutputName;
    }

    /**
     * <p>
     * Contains information about an input into the prompt flow.
     * </p>
     * 
     * @return Contains information about an input into the prompt flow.
     */
    public final FlowInputContent content() {
        return content;
    }

    /**
     * <p>
     * The name of the input from the flow input node.
     * </p>
     * 
     * @return The name of the input from the flow input node.
     */
    public final String nodeInputName() {
        return nodeInputName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(nodeOutputName());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(nodeInputName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowInput)) {
            return false;
        }
        FlowInput other = (FlowInput) obj;
        return Objects.equals(nodeName(), other.nodeName()) && Objects.equals(nodeOutputName(), other.nodeOutputName())
                && Objects.equals(content(), other.content()) && Objects.equals(nodeInputName(), other.nodeInputName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowInput").add("NodeName", nodeName()).add("NodeOutputName", nodeOutputName())
                .add("Content", content() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NodeInputName", nodeInputName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "nodeOutputName":
            return Optional.ofNullable(clazz.cast(nodeOutputName()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "nodeInputName":
            return Optional.ofNullable(clazz.cast(nodeInputName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodeName", NODE_NAME_FIELD);
        map.put("nodeOutputName", NODE_OUTPUT_NAME_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("nodeInputName", NODE_INPUT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowInput, T> g) {
        return obj -> g.apply((FlowInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowInput> {
        /**
         * <p>
         * The name of the flow input node that begins the prompt flow.
         * </p>
         * 
         * @param nodeName
         *        The name of the flow input node that begins the prompt flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * The name of the output from the flow input node that begins the prompt flow.
         * </p>
         * 
         * @param nodeOutputName
         *        The name of the output from the flow input node that begins the prompt flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeOutputName(String nodeOutputName);

        /**
         * <p>
         * Contains information about an input into the prompt flow.
         * </p>
         * 
         * @param content
         *        Contains information about an input into the prompt flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(FlowInputContent content);

        /**
         * <p>
         * Contains information about an input into the prompt flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowInputContent.Builder} avoiding the
         * need to create one manually via {@link FlowInputContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowInputContent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(FlowInputContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link FlowInputContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(FlowInputContent)
         */
        default Builder content(Consumer<FlowInputContent.Builder> content) {
            return content(FlowInputContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The name of the input from the flow input node.
         * </p>
         * 
         * @param nodeInputName
         *        The name of the input from the flow input node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInputName(String nodeInputName);
    }

    static final class BuilderImpl implements Builder {
        private String nodeName;

        private String nodeOutputName;

        private FlowInputContent content;

        private String nodeInputName;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowInput model) {
            nodeName(model.nodeName);
            nodeOutputName(model.nodeOutputName);
            content(model.content);
            nodeInputName(model.nodeInputName);
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getNodeOutputName() {
            return nodeOutputName;
        }

        public final void setNodeOutputName(String nodeOutputName) {
            this.nodeOutputName = nodeOutputName;
        }

        @Override
        public final Builder nodeOutputName(String nodeOutputName) {
            this.nodeOutputName = nodeOutputName;
            return this;
        }

        public final FlowInputContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(FlowInputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(FlowInputContent content) {
            this.content = content;
            return this;
        }

        public final String getNodeInputName() {
            return nodeInputName;
        }

        public final void setNodeInputName(String nodeInputName) {
            this.nodeInputName = nodeInputName;
        }

        @Override
        public final Builder nodeInputName(String nodeInputName) {
            this.nodeInputName = nodeInputName;
            return this;
        }

        @Override
        public FlowInput build() {
            return new FlowInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
