/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Response object from the flow multi-turn node requesting additional information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FlowMultiTurnInputRequestEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowMultiTurnInputRequestEvent.Builder, FlowMultiTurnInputRequestEvent>, FlowResponseStream {
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(FlowMultiTurnInputRequestEvent::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeType").getter(getter(FlowMultiTurnInputRequestEvent::nodeTypeAsString))
            .setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeType").build()).build();

    private static final SdkField<FlowMultiTurnInputContent> CONTENT_FIELD = SdkField
            .<FlowMultiTurnInputContent> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(FlowMultiTurnInputRequestEvent::content)).setter(setter(Builder::content))
            .constructor(FlowMultiTurnInputContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_NAME_FIELD,
            NODE_TYPE_FIELD, CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodeName;

    private final String nodeType;

    private final FlowMultiTurnInputContent content;

    protected FlowMultiTurnInputRequestEvent(BuilderImpl builder) {
        this.nodeName = builder.nodeName;
        this.nodeType = builder.nodeType;
        this.content = builder.content;
    }

    /**
     * <p>
     * The name of the node in the flow that is requesting the input.
     * </p>
     * 
     * @return The name of the node in the flow that is requesting the input.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * The type of the node in the flow that is requesting the input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeType} will
     * return {@link NodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nodeTypeAsString}.
     * </p>
     * 
     * @return The type of the node in the flow that is requesting the input.
     * @see NodeType
     */
    public final NodeType nodeType() {
        return NodeType.fromValue(nodeType);
    }

    /**
     * <p>
     * The type of the node in the flow that is requesting the input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeType} will
     * return {@link NodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nodeTypeAsString}.
     * </p>
     * 
     * @return The type of the node in the flow that is requesting the input.
     * @see NodeType
     */
    public final String nodeTypeAsString() {
        return nodeType;
    }

    /**
     * <p>
     * The content payload containing the input request details for the multi-turn interaction.
     * </p>
     * 
     * @return The content payload containing the input request details for the multi-turn interaction.
     */
    public final FlowMultiTurnInputContent content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(nodeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowMultiTurnInputRequestEvent)) {
            return false;
        }
        FlowMultiTurnInputRequestEvent other = (FlowMultiTurnInputRequestEvent) obj;
        return Objects.equals(nodeName(), other.nodeName()) && Objects.equals(nodeTypeAsString(), other.nodeTypeAsString())
                && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowMultiTurnInputRequestEvent").add("NodeName", nodeName()).add("NodeType", nodeTypeAsString())
                .add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "nodeType":
            return Optional.ofNullable(clazz.cast(nodeTypeAsString()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final FlowMultiTurnInputRequestEvent copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodeName", NODE_NAME_FIELD);
        map.put("nodeType", NODE_TYPE_FIELD);
        map.put("content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowMultiTurnInputRequestEvent, T> g) {
        return obj -> g.apply((FlowMultiTurnInputRequestEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link FlowMultiTurnInputRequestEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(InvokeFlowResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowMultiTurnInputRequestEvent> {
        /**
         * <p>
         * The name of the node in the flow that is requesting the input.
         * </p>
         * 
         * @param nodeName
         *        The name of the node in the flow that is requesting the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * The type of the node in the flow that is requesting the input.
         * </p>
         * 
         * @param nodeType
         *        The type of the node in the flow that is requesting the input.
         * @see NodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeType
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The type of the node in the flow that is requesting the input.
         * </p>
         * 
         * @param nodeType
         *        The type of the node in the flow that is requesting the input.
         * @see NodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeType
         */
        Builder nodeType(NodeType nodeType);

        /**
         * <p>
         * The content payload containing the input request details for the multi-turn interaction.
         * </p>
         * 
         * @param content
         *        The content payload containing the input request details for the multi-turn interaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(FlowMultiTurnInputContent content);

        /**
         * <p>
         * The content payload containing the input request details for the multi-turn interaction.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowMultiTurnInputContent.Builder}
         * avoiding the need to create one manually via {@link FlowMultiTurnInputContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowMultiTurnInputContent.Builder#build()} is called immediately
         * and its result is passed to {@link #content(FlowMultiTurnInputContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link FlowMultiTurnInputContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(FlowMultiTurnInputContent)
         */
        default Builder content(Consumer<FlowMultiTurnInputContent.Builder> content) {
            return content(FlowMultiTurnInputContent.builder().applyMutation(content).build());
        }
    }

    protected static class BuilderImpl implements Builder {
        private String nodeName;

        private String nodeType;

        private FlowMultiTurnInputContent content;

        protected BuilderImpl() {
        }

        protected BuilderImpl(FlowMultiTurnInputRequestEvent model) {
            nodeName(model.nodeName);
            nodeType(model.nodeType);
            content(model.content);
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        @Override
        public final Builder nodeType(NodeType nodeType) {
            this.nodeType(nodeType == null ? null : nodeType.toString());
            return this;
        }

        public final FlowMultiTurnInputContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(FlowMultiTurnInputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(FlowMultiTurnInputContent content) {
            this.content = content;
            return this;
        }

        @Override
        public FlowMultiTurnInputRequestEvent build() {
            return new FlowMultiTurnInputRequestEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
