/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an input or output for a node in the flow. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html">Track each step in your prompt flow by
 * viewing its trace in Amazon Bedrock</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowTrace implements SdkPojo, Serializable, ToCopyableBuilder<FlowTrace.Builder, FlowTrace> {
    private static final SdkField<FlowTraceNodeInputEvent> NODE_INPUT_TRACE_FIELD = SdkField
            .<FlowTraceNodeInputEvent> builder(MarshallingType.SDK_POJO).memberName("nodeInputTrace")
            .getter(getter(FlowTrace::nodeInputTrace)).setter(setter(Builder::nodeInputTrace))
            .constructor(FlowTraceNodeInputEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInputTrace").build()).build();

    private static final SdkField<FlowTraceNodeOutputEvent> NODE_OUTPUT_TRACE_FIELD = SdkField
            .<FlowTraceNodeOutputEvent> builder(MarshallingType.SDK_POJO).memberName("nodeOutputTrace")
            .getter(getter(FlowTrace::nodeOutputTrace)).setter(setter(Builder::nodeOutputTrace))
            .constructor(FlowTraceNodeOutputEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeOutputTrace").build()).build();

    private static final SdkField<FlowTraceConditionNodeResultEvent> CONDITION_NODE_RESULT_TRACE_FIELD = SdkField
            .<FlowTraceConditionNodeResultEvent> builder(MarshallingType.SDK_POJO).memberName("conditionNodeResultTrace")
            .getter(getter(FlowTrace::conditionNodeResultTrace)).setter(setter(Builder::conditionNodeResultTrace))
            .constructor(FlowTraceConditionNodeResultEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionNodeResultTrace").build())
            .build();

    private static final SdkField<FlowTraceNodeActionEvent> NODE_ACTION_TRACE_FIELD = SdkField
            .<FlowTraceNodeActionEvent> builder(MarshallingType.SDK_POJO).memberName("nodeActionTrace")
            .getter(getter(FlowTrace::nodeActionTrace)).setter(setter(Builder::nodeActionTrace))
            .constructor(FlowTraceNodeActionEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeActionTrace").build()).build();

    private static final SdkField<FlowTraceDependencyEvent> NODE_DEPENDENCY_TRACE_FIELD = SdkField
            .<FlowTraceDependencyEvent> builder(MarshallingType.SDK_POJO).memberName("nodeDependencyTrace")
            .getter(getter(FlowTrace::nodeDependencyTrace)).setter(setter(Builder::nodeDependencyTrace))
            .constructor(FlowTraceDependencyEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeDependencyTrace").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_INPUT_TRACE_FIELD,
            NODE_OUTPUT_TRACE_FIELD, CONDITION_NODE_RESULT_TRACE_FIELD, NODE_ACTION_TRACE_FIELD, NODE_DEPENDENCY_TRACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FlowTraceNodeInputEvent nodeInputTrace;

    private final FlowTraceNodeOutputEvent nodeOutputTrace;

    private final FlowTraceConditionNodeResultEvent conditionNodeResultTrace;

    private final FlowTraceNodeActionEvent nodeActionTrace;

    private final FlowTraceDependencyEvent nodeDependencyTrace;

    private final Type type;

    private FlowTrace(BuilderImpl builder) {
        this.nodeInputTrace = builder.nodeInputTrace;
        this.nodeOutputTrace = builder.nodeOutputTrace;
        this.conditionNodeResultTrace = builder.conditionNodeResultTrace;
        this.nodeActionTrace = builder.nodeActionTrace;
        this.nodeDependencyTrace = builder.nodeDependencyTrace;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains information about the input into a node.
     * </p>
     * 
     * @return Contains information about the input into a node.
     */
    public final FlowTraceNodeInputEvent nodeInputTrace() {
        return nodeInputTrace;
    }

    /**
     * <p>
     * Contains information about the output from a node.
     * </p>
     * 
     * @return Contains information about the output from a node.
     */
    public final FlowTraceNodeOutputEvent nodeOutputTrace() {
        return nodeOutputTrace;
    }

    /**
     * <p>
     * Contains information about an output from a condition node.
     * </p>
     * 
     * @return Contains information about an output from a condition node.
     */
    public final FlowTraceConditionNodeResultEvent conditionNodeResultTrace() {
        return conditionNodeResultTrace;
    }

    /**
     * <p>
     * Contains information about an action (operation) called by a node.
     * </p>
     * 
     * @return Contains information about an action (operation) called by a node.
     */
    public final FlowTraceNodeActionEvent nodeActionTrace() {
        return nodeActionTrace;
    }

    /**
     * <p>
     * Contains information about an internal trace of a node.
     * </p>
     * 
     * @return Contains information about an internal trace of a node.
     */
    public final FlowTraceDependencyEvent nodeDependencyTrace() {
        return nodeDependencyTrace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeInputTrace());
        hashCode = 31 * hashCode + Objects.hashCode(nodeOutputTrace());
        hashCode = 31 * hashCode + Objects.hashCode(conditionNodeResultTrace());
        hashCode = 31 * hashCode + Objects.hashCode(nodeActionTrace());
        hashCode = 31 * hashCode + Objects.hashCode(nodeDependencyTrace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTrace)) {
            return false;
        }
        FlowTrace other = (FlowTrace) obj;
        return Objects.equals(nodeInputTrace(), other.nodeInputTrace())
                && Objects.equals(nodeOutputTrace(), other.nodeOutputTrace())
                && Objects.equals(conditionNodeResultTrace(), other.conditionNodeResultTrace())
                && Objects.equals(nodeActionTrace(), other.nodeActionTrace())
                && Objects.equals(nodeDependencyTrace(), other.nodeDependencyTrace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowTrace")
                .add("NodeInputTrace", nodeInputTrace() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NodeOutputTrace", nodeOutputTrace() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConditionNodeResultTrace", conditionNodeResultTrace() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NodeActionTrace", nodeActionTrace() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NodeDependencyTrace", nodeDependencyTrace() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeInputTrace":
            return Optional.ofNullable(clazz.cast(nodeInputTrace()));
        case "nodeOutputTrace":
            return Optional.ofNullable(clazz.cast(nodeOutputTrace()));
        case "conditionNodeResultTrace":
            return Optional.ofNullable(clazz.cast(conditionNodeResultTrace()));
        case "nodeActionTrace":
            return Optional.ofNullable(clazz.cast(nodeActionTrace()));
        case "nodeDependencyTrace":
            return Optional.ofNullable(clazz.cast(nodeDependencyTrace()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #nodeInputTrace()} initialized to the given value.
     *
     * <p>
     * Contains information about the input into a node.
     * </p>
     * 
     * @param nodeInputTrace
     *        Contains information about the input into a node.
     */
    public static FlowTrace fromNodeInputTrace(FlowTraceNodeInputEvent nodeInputTrace) {
        return builder().nodeInputTrace(nodeInputTrace).build();
    }

    /**
     * Create an instance of this class with {@link #nodeInputTrace()} initialized to the given value.
     *
     * <p>
     * Contains information about the input into a node.
     * </p>
     * 
     * @param nodeInputTrace
     *        Contains information about the input into a node.
     */
    public static FlowTrace fromNodeInputTrace(Consumer<FlowTraceNodeInputEvent.Builder> nodeInputTrace) {
        FlowTraceNodeInputEvent.Builder builder = FlowTraceNodeInputEvent.builder();
        nodeInputTrace.accept(builder);
        return fromNodeInputTrace(builder.build());
    }

    /**
     * Create an instance of this class with {@link #nodeOutputTrace()} initialized to the given value.
     *
     * <p>
     * Contains information about the output from a node.
     * </p>
     * 
     * @param nodeOutputTrace
     *        Contains information about the output from a node.
     */
    public static FlowTrace fromNodeOutputTrace(FlowTraceNodeOutputEvent nodeOutputTrace) {
        return builder().nodeOutputTrace(nodeOutputTrace).build();
    }

    /**
     * Create an instance of this class with {@link #nodeOutputTrace()} initialized to the given value.
     *
     * <p>
     * Contains information about the output from a node.
     * </p>
     * 
     * @param nodeOutputTrace
     *        Contains information about the output from a node.
     */
    public static FlowTrace fromNodeOutputTrace(Consumer<FlowTraceNodeOutputEvent.Builder> nodeOutputTrace) {
        FlowTraceNodeOutputEvent.Builder builder = FlowTraceNodeOutputEvent.builder();
        nodeOutputTrace.accept(builder);
        return fromNodeOutputTrace(builder.build());
    }

    /**
     * Create an instance of this class with {@link #conditionNodeResultTrace()} initialized to the given value.
     *
     * <p>
     * Contains information about an output from a condition node.
     * </p>
     * 
     * @param conditionNodeResultTrace
     *        Contains information about an output from a condition node.
     */
    public static FlowTrace fromConditionNodeResultTrace(FlowTraceConditionNodeResultEvent conditionNodeResultTrace) {
        return builder().conditionNodeResultTrace(conditionNodeResultTrace).build();
    }

    /**
     * Create an instance of this class with {@link #conditionNodeResultTrace()} initialized to the given value.
     *
     * <p>
     * Contains information about an output from a condition node.
     * </p>
     * 
     * @param conditionNodeResultTrace
     *        Contains information about an output from a condition node.
     */
    public static FlowTrace fromConditionNodeResultTrace(
            Consumer<FlowTraceConditionNodeResultEvent.Builder> conditionNodeResultTrace) {
        FlowTraceConditionNodeResultEvent.Builder builder = FlowTraceConditionNodeResultEvent.builder();
        conditionNodeResultTrace.accept(builder);
        return fromConditionNodeResultTrace(builder.build());
    }

    /**
     * Create an instance of this class with {@link #nodeActionTrace()} initialized to the given value.
     *
     * <p>
     * Contains information about an action (operation) called by a node.
     * </p>
     * 
     * @param nodeActionTrace
     *        Contains information about an action (operation) called by a node.
     */
    public static FlowTrace fromNodeActionTrace(FlowTraceNodeActionEvent nodeActionTrace) {
        return builder().nodeActionTrace(nodeActionTrace).build();
    }

    /**
     * Create an instance of this class with {@link #nodeActionTrace()} initialized to the given value.
     *
     * <p>
     * Contains information about an action (operation) called by a node.
     * </p>
     * 
     * @param nodeActionTrace
     *        Contains information about an action (operation) called by a node.
     */
    public static FlowTrace fromNodeActionTrace(Consumer<FlowTraceNodeActionEvent.Builder> nodeActionTrace) {
        FlowTraceNodeActionEvent.Builder builder = FlowTraceNodeActionEvent.builder();
        nodeActionTrace.accept(builder);
        return fromNodeActionTrace(builder.build());
    }

    /**
     * Create an instance of this class with {@link #nodeDependencyTrace()} initialized to the given value.
     *
     * <p>
     * Contains information about an internal trace of a node.
     * </p>
     * 
     * @param nodeDependencyTrace
     *        Contains information about an internal trace of a node.
     */
    public static FlowTrace fromNodeDependencyTrace(FlowTraceDependencyEvent nodeDependencyTrace) {
        return builder().nodeDependencyTrace(nodeDependencyTrace).build();
    }

    /**
     * Create an instance of this class with {@link #nodeDependencyTrace()} initialized to the given value.
     *
     * <p>
     * Contains information about an internal trace of a node.
     * </p>
     * 
     * @param nodeDependencyTrace
     *        Contains information about an internal trace of a node.
     */
    public static FlowTrace fromNodeDependencyTrace(Consumer<FlowTraceDependencyEvent.Builder> nodeDependencyTrace) {
        FlowTraceDependencyEvent.Builder builder = FlowTraceDependencyEvent.builder();
        nodeDependencyTrace.accept(builder);
        return fromNodeDependencyTrace(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodeInputTrace", NODE_INPUT_TRACE_FIELD);
        map.put("nodeOutputTrace", NODE_OUTPUT_TRACE_FIELD);
        map.put("conditionNodeResultTrace", CONDITION_NODE_RESULT_TRACE_FIELD);
        map.put("nodeActionTrace", NODE_ACTION_TRACE_FIELD);
        map.put("nodeDependencyTrace", NODE_DEPENDENCY_TRACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTrace, T> g) {
        return obj -> g.apply((FlowTrace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowTrace> {
        /**
         * <p>
         * Contains information about the input into a node.
         * </p>
         * 
         * @param nodeInputTrace
         *        Contains information about the input into a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInputTrace(FlowTraceNodeInputEvent nodeInputTrace);

        /**
         * <p>
         * Contains information about the input into a node.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowTraceNodeInputEvent.Builder} avoiding
         * the need to create one manually via {@link FlowTraceNodeInputEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowTraceNodeInputEvent.Builder#build()} is called immediately
         * and its result is passed to {@link #nodeInputTrace(FlowTraceNodeInputEvent)}.
         * 
         * @param nodeInputTrace
         *        a consumer that will call methods on {@link FlowTraceNodeInputEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeInputTrace(FlowTraceNodeInputEvent)
         */
        default Builder nodeInputTrace(Consumer<FlowTraceNodeInputEvent.Builder> nodeInputTrace) {
            return nodeInputTrace(FlowTraceNodeInputEvent.builder().applyMutation(nodeInputTrace).build());
        }

        /**
         * <p>
         * Contains information about the output from a node.
         * </p>
         * 
         * @param nodeOutputTrace
         *        Contains information about the output from a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeOutputTrace(FlowTraceNodeOutputEvent nodeOutputTrace);

        /**
         * <p>
         * Contains information about the output from a node.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowTraceNodeOutputEvent.Builder}
         * avoiding the need to create one manually via {@link FlowTraceNodeOutputEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowTraceNodeOutputEvent.Builder#build()} is called immediately
         * and its result is passed to {@link #nodeOutputTrace(FlowTraceNodeOutputEvent)}.
         * 
         * @param nodeOutputTrace
         *        a consumer that will call methods on {@link FlowTraceNodeOutputEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeOutputTrace(FlowTraceNodeOutputEvent)
         */
        default Builder nodeOutputTrace(Consumer<FlowTraceNodeOutputEvent.Builder> nodeOutputTrace) {
            return nodeOutputTrace(FlowTraceNodeOutputEvent.builder().applyMutation(nodeOutputTrace).build());
        }

        /**
         * <p>
         * Contains information about an output from a condition node.
         * </p>
         * 
         * @param conditionNodeResultTrace
         *        Contains information about an output from a condition node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionNodeResultTrace(FlowTraceConditionNodeResultEvent conditionNodeResultTrace);

        /**
         * <p>
         * Contains information about an output from a condition node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FlowTraceConditionNodeResultEvent.Builder} avoiding the need to create one manually via
         * {@link FlowTraceConditionNodeResultEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowTraceConditionNodeResultEvent.Builder#build()} is called
         * immediately and its result is passed to {@link #conditionNodeResultTrace(FlowTraceConditionNodeResultEvent)}.
         * 
         * @param conditionNodeResultTrace
         *        a consumer that will call methods on {@link FlowTraceConditionNodeResultEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditionNodeResultTrace(FlowTraceConditionNodeResultEvent)
         */
        default Builder conditionNodeResultTrace(Consumer<FlowTraceConditionNodeResultEvent.Builder> conditionNodeResultTrace) {
            return conditionNodeResultTrace(FlowTraceConditionNodeResultEvent.builder().applyMutation(conditionNodeResultTrace)
                    .build());
        }

        /**
         * <p>
         * Contains information about an action (operation) called by a node.
         * </p>
         * 
         * @param nodeActionTrace
         *        Contains information about an action (operation) called by a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeActionTrace(FlowTraceNodeActionEvent nodeActionTrace);

        /**
         * <p>
         * Contains information about an action (operation) called by a node.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowTraceNodeActionEvent.Builder}
         * avoiding the need to create one manually via {@link FlowTraceNodeActionEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowTraceNodeActionEvent.Builder#build()} is called immediately
         * and its result is passed to {@link #nodeActionTrace(FlowTraceNodeActionEvent)}.
         * 
         * @param nodeActionTrace
         *        a consumer that will call methods on {@link FlowTraceNodeActionEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeActionTrace(FlowTraceNodeActionEvent)
         */
        default Builder nodeActionTrace(Consumer<FlowTraceNodeActionEvent.Builder> nodeActionTrace) {
            return nodeActionTrace(FlowTraceNodeActionEvent.builder().applyMutation(nodeActionTrace).build());
        }

        /**
         * <p>
         * Contains information about an internal trace of a node.
         * </p>
         * 
         * @param nodeDependencyTrace
         *        Contains information about an internal trace of a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeDependencyTrace(FlowTraceDependencyEvent nodeDependencyTrace);

        /**
         * <p>
         * Contains information about an internal trace of a node.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowTraceDependencyEvent.Builder}
         * avoiding the need to create one manually via {@link FlowTraceDependencyEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowTraceDependencyEvent.Builder#build()} is called immediately
         * and its result is passed to {@link #nodeDependencyTrace(FlowTraceDependencyEvent)}.
         * 
         * @param nodeDependencyTrace
         *        a consumer that will call methods on {@link FlowTraceDependencyEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeDependencyTrace(FlowTraceDependencyEvent)
         */
        default Builder nodeDependencyTrace(Consumer<FlowTraceDependencyEvent.Builder> nodeDependencyTrace) {
            return nodeDependencyTrace(FlowTraceDependencyEvent.builder().applyMutation(nodeDependencyTrace).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FlowTraceNodeInputEvent nodeInputTrace;

        private FlowTraceNodeOutputEvent nodeOutputTrace;

        private FlowTraceConditionNodeResultEvent conditionNodeResultTrace;

        private FlowTraceNodeActionEvent nodeActionTrace;

        private FlowTraceDependencyEvent nodeDependencyTrace;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTrace model) {
            nodeInputTrace(model.nodeInputTrace);
            nodeOutputTrace(model.nodeOutputTrace);
            conditionNodeResultTrace(model.conditionNodeResultTrace);
            nodeActionTrace(model.nodeActionTrace);
            nodeDependencyTrace(model.nodeDependencyTrace);
        }

        public final FlowTraceNodeInputEvent.Builder getNodeInputTrace() {
            return nodeInputTrace != null ? nodeInputTrace.toBuilder() : null;
        }

        public final void setNodeInputTrace(FlowTraceNodeInputEvent.BuilderImpl nodeInputTrace) {
            Object oldValue = this.nodeInputTrace;
            this.nodeInputTrace = nodeInputTrace != null ? nodeInputTrace.build() : null;
            handleUnionValueChange(Type.NODE_INPUT_TRACE, oldValue, this.nodeInputTrace);
        }

        @Override
        public final Builder nodeInputTrace(FlowTraceNodeInputEvent nodeInputTrace) {
            Object oldValue = this.nodeInputTrace;
            this.nodeInputTrace = nodeInputTrace;
            handleUnionValueChange(Type.NODE_INPUT_TRACE, oldValue, this.nodeInputTrace);
            return this;
        }

        public final FlowTraceNodeOutputEvent.Builder getNodeOutputTrace() {
            return nodeOutputTrace != null ? nodeOutputTrace.toBuilder() : null;
        }

        public final void setNodeOutputTrace(FlowTraceNodeOutputEvent.BuilderImpl nodeOutputTrace) {
            Object oldValue = this.nodeOutputTrace;
            this.nodeOutputTrace = nodeOutputTrace != null ? nodeOutputTrace.build() : null;
            handleUnionValueChange(Type.NODE_OUTPUT_TRACE, oldValue, this.nodeOutputTrace);
        }

        @Override
        public final Builder nodeOutputTrace(FlowTraceNodeOutputEvent nodeOutputTrace) {
            Object oldValue = this.nodeOutputTrace;
            this.nodeOutputTrace = nodeOutputTrace;
            handleUnionValueChange(Type.NODE_OUTPUT_TRACE, oldValue, this.nodeOutputTrace);
            return this;
        }

        public final FlowTraceConditionNodeResultEvent.Builder getConditionNodeResultTrace() {
            return conditionNodeResultTrace != null ? conditionNodeResultTrace.toBuilder() : null;
        }

        public final void setConditionNodeResultTrace(FlowTraceConditionNodeResultEvent.BuilderImpl conditionNodeResultTrace) {
            Object oldValue = this.conditionNodeResultTrace;
            this.conditionNodeResultTrace = conditionNodeResultTrace != null ? conditionNodeResultTrace.build() : null;
            handleUnionValueChange(Type.CONDITION_NODE_RESULT_TRACE, oldValue, this.conditionNodeResultTrace);
        }

        @Override
        public final Builder conditionNodeResultTrace(FlowTraceConditionNodeResultEvent conditionNodeResultTrace) {
            Object oldValue = this.conditionNodeResultTrace;
            this.conditionNodeResultTrace = conditionNodeResultTrace;
            handleUnionValueChange(Type.CONDITION_NODE_RESULT_TRACE, oldValue, this.conditionNodeResultTrace);
            return this;
        }

        public final FlowTraceNodeActionEvent.Builder getNodeActionTrace() {
            return nodeActionTrace != null ? nodeActionTrace.toBuilder() : null;
        }

        public final void setNodeActionTrace(FlowTraceNodeActionEvent.BuilderImpl nodeActionTrace) {
            Object oldValue = this.nodeActionTrace;
            this.nodeActionTrace = nodeActionTrace != null ? nodeActionTrace.build() : null;
            handleUnionValueChange(Type.NODE_ACTION_TRACE, oldValue, this.nodeActionTrace);
        }

        @Override
        public final Builder nodeActionTrace(FlowTraceNodeActionEvent nodeActionTrace) {
            Object oldValue = this.nodeActionTrace;
            this.nodeActionTrace = nodeActionTrace;
            handleUnionValueChange(Type.NODE_ACTION_TRACE, oldValue, this.nodeActionTrace);
            return this;
        }

        public final FlowTraceDependencyEvent.Builder getNodeDependencyTrace() {
            return nodeDependencyTrace != null ? nodeDependencyTrace.toBuilder() : null;
        }

        public final void setNodeDependencyTrace(FlowTraceDependencyEvent.BuilderImpl nodeDependencyTrace) {
            Object oldValue = this.nodeDependencyTrace;
            this.nodeDependencyTrace = nodeDependencyTrace != null ? nodeDependencyTrace.build() : null;
            handleUnionValueChange(Type.NODE_DEPENDENCY_TRACE, oldValue, this.nodeDependencyTrace);
        }

        @Override
        public final Builder nodeDependencyTrace(FlowTraceDependencyEvent nodeDependencyTrace) {
            Object oldValue = this.nodeDependencyTrace;
            this.nodeDependencyTrace = nodeDependencyTrace;
            handleUnionValueChange(Type.NODE_DEPENDENCY_TRACE, oldValue, this.nodeDependencyTrace);
            return this;
        }

        @Override
        public FlowTrace build() {
            return new FlowTrace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FlowTrace#type()
     */
    public enum Type {
        NODE_INPUT_TRACE,

        NODE_OUTPUT_TRACE,

        CONDITION_NODE_RESULT_TRACE,

        NODE_ACTION_TRACE,

        NODE_DEPENDENCY_TRACE,

        UNKNOWN_TO_SDK_VERSION
    }
}
