/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an item in the execution chain for flow trace node input tracking.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowTraceNodeInputExecutionChainItem implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowTraceNodeInputExecutionChainItem.Builder, FlowTraceNodeInputExecutionChainItem> {
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(FlowTraceNodeInputExecutionChainItem::nodeName))
            .setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final SdkField<Integer> INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("index")
            .getter(getter(FlowTraceNodeInputExecutionChainItem::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FlowTraceNodeInputExecutionChainItem::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_NAME_FIELD, INDEX_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodeName;

    private final Integer index;

    private final String type;

    private FlowTraceNodeInputExecutionChainItem(BuilderImpl builder) {
        this.nodeName = builder.nodeName;
        this.index = builder.index;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the node in the execution chain.
     * </p>
     * 
     * @return The name of the node in the execution chain.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * The index position of this item in the execution chain.
     * </p>
     * 
     * @return The index position of this item in the execution chain.
     */
    public final Integer index() {
        return index;
    }

    /**
     * <p>
     * The type of execution chain item. Supported values are Iterator and Loop.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowControlNodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of execution chain item. Supported values are Iterator and Loop.
     * @see FlowControlNodeType
     */
    public final FlowControlNodeType type() {
        return FlowControlNodeType.fromValue(type);
    }

    /**
     * <p>
     * The type of execution chain item. Supported values are Iterator and Loop.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowControlNodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of execution chain item. Supported values are Iterator and Loop.
     * @see FlowControlNodeType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTraceNodeInputExecutionChainItem)) {
            return false;
        }
        FlowTraceNodeInputExecutionChainItem other = (FlowTraceNodeInputExecutionChainItem) obj;
        return Objects.equals(nodeName(), other.nodeName()) && Objects.equals(index(), other.index())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowTraceNodeInputExecutionChainItem").add("NodeName", nodeName()).add("Index", index())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "index":
            return Optional.ofNullable(clazz.cast(index()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodeName", NODE_NAME_FIELD);
        map.put("index", INDEX_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTraceNodeInputExecutionChainItem, T> g) {
        return obj -> g.apply((FlowTraceNodeInputExecutionChainItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowTraceNodeInputExecutionChainItem> {
        /**
         * <p>
         * The name of the node in the execution chain.
         * </p>
         * 
         * @param nodeName
         *        The name of the node in the execution chain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * The index position of this item in the execution chain.
         * </p>
         * 
         * @param index
         *        The index position of this item in the execution chain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Integer index);

        /**
         * <p>
         * The type of execution chain item. Supported values are Iterator and Loop.
         * </p>
         * 
         * @param type
         *        The type of execution chain item. Supported values are Iterator and Loop.
         * @see FlowControlNodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowControlNodeType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of execution chain item. Supported values are Iterator and Loop.
         * </p>
         * 
         * @param type
         *        The type of execution chain item. Supported values are Iterator and Loop.
         * @see FlowControlNodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowControlNodeType
         */
        Builder type(FlowControlNodeType type);
    }

    static final class BuilderImpl implements Builder {
        private String nodeName;

        private Integer index;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTraceNodeInputExecutionChainItem model) {
            nodeName(model.nodeName);
            index(model.index);
            type(model.type);
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final Integer getIndex() {
            return index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowControlNodeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public FlowTraceNodeInputExecutionChainItem build() {
            return new FlowTraceNodeInputExecutionChainItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
