/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a field in the input into a node. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html">Track each step in your prompt flow by
 * viewing its trace in Amazon Bedrock</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowTraceNodeInputField implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowTraceNodeInputField.Builder, FlowTraceNodeInputField> {
    private static final SdkField<String> NODE_INPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeInputName").getter(getter(FlowTraceNodeInputField::nodeInputName))
            .setter(setter(Builder::nodeInputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeInputName").build()).build();

    private static final SdkField<FlowTraceNodeInputContent> CONTENT_FIELD = SdkField
            .<FlowTraceNodeInputContent> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(FlowTraceNodeInputField::content)).setter(setter(Builder::content))
            .constructor(FlowTraceNodeInputContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<FlowTraceNodeInputSource> SOURCE_FIELD = SdkField
            .<FlowTraceNodeInputSource> builder(MarshallingType.SDK_POJO).memberName("source")
            .getter(getter(FlowTraceNodeInputField::source)).setter(setter(Builder::source))
            .constructor(FlowTraceNodeInputSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FlowTraceNodeInputField::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("category").getter(getter(FlowTraceNodeInputField::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()).build();

    private static final SdkField<List<FlowTraceNodeInputExecutionChainItem>> EXECUTION_CHAIN_FIELD = SdkField
            .<List<FlowTraceNodeInputExecutionChainItem>> builder(MarshallingType.LIST)
            .memberName("executionChain")
            .getter(getter(FlowTraceNodeInputField::executionChain))
            .setter(setter(Builder::executionChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionChain").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowTraceNodeInputExecutionChainItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowTraceNodeInputExecutionChainItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_INPUT_NAME_FIELD,
            CONTENT_FIELD, SOURCE_FIELD, TYPE_FIELD, CATEGORY_FIELD, EXECUTION_CHAIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodeInputName;

    private final FlowTraceNodeInputContent content;

    private final FlowTraceNodeInputSource source;

    private final String type;

    private final String category;

    private final List<FlowTraceNodeInputExecutionChainItem> executionChain;

    private FlowTraceNodeInputField(BuilderImpl builder) {
        this.nodeInputName = builder.nodeInputName;
        this.content = builder.content;
        this.source = builder.source;
        this.type = builder.type;
        this.category = builder.category;
        this.executionChain = builder.executionChain;
    }

    /**
     * <p>
     * The name of the node input.
     * </p>
     * 
     * @return The name of the node input.
     */
    public final String nodeInputName() {
        return nodeInputName;
    }

    /**
     * <p>
     * The content of the node input.
     * </p>
     * 
     * @return The content of the node input.
     */
    public final FlowTraceNodeInputContent content() {
        return content;
    }

    /**
     * <p>
     * The source node that provides input data to this field.
     * </p>
     * 
     * @return The source node that provides input data to this field.
     */
    public final FlowTraceNodeInputSource source() {
        return source;
    }

    /**
     * <p>
     * The data type of the input field for compatibility validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowNodeIODataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The data type of the input field for compatibility validation.
     * @see FlowNodeIODataType
     */
    public final FlowNodeIODataType type() {
        return FlowNodeIODataType.fromValue(type);
    }

    /**
     * <p>
     * The data type of the input field for compatibility validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowNodeIODataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The data type of the input field for compatibility validation.
     * @see FlowNodeIODataType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The category of the input field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link FlowNodeInputCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the input field.
     * @see FlowNodeInputCategory
     */
    public final FlowNodeInputCategory category() {
        return FlowNodeInputCategory.fromValue(category);
    }

    /**
     * <p>
     * The category of the input field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link FlowNodeInputCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of the input field.
     * @see FlowNodeInputCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExecutionChain property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExecutionChain() {
        return executionChain != null && !(executionChain instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The execution path through nested nodes like iterators and loops.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutionChain} method.
     * </p>
     * 
     * @return The execution path through nested nodes like iterators and loops.
     */
    public final List<FlowTraceNodeInputExecutionChainItem> executionChain() {
        return executionChain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeInputName());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasExecutionChain() ? executionChain() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTraceNodeInputField)) {
            return false;
        }
        FlowTraceNodeInputField other = (FlowTraceNodeInputField) obj;
        return Objects.equals(nodeInputName(), other.nodeInputName()) && Objects.equals(content(), other.content())
                && Objects.equals(source(), other.source()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(categoryAsString(), other.categoryAsString())
                && hasExecutionChain() == other.hasExecutionChain() && Objects.equals(executionChain(), other.executionChain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowTraceNodeInputField").add("NodeInputName", nodeInputName())
                .add("Content", content() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Source", source() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("Category", categoryAsString())
                .add("ExecutionChain", executionChain() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeInputName":
            return Optional.ofNullable(clazz.cast(nodeInputName()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "executionChain":
            return Optional.ofNullable(clazz.cast(executionChain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodeInputName", NODE_INPUT_NAME_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("category", CATEGORY_FIELD);
        map.put("executionChain", EXECUTION_CHAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTraceNodeInputField, T> g) {
        return obj -> g.apply((FlowTraceNodeInputField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowTraceNodeInputField> {
        /**
         * <p>
         * The name of the node input.
         * </p>
         * 
         * @param nodeInputName
         *        The name of the node input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInputName(String nodeInputName);

        /**
         * <p>
         * The content of the node input.
         * </p>
         * 
         * @param content
         *        The content of the node input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(FlowTraceNodeInputContent content);

        /**
         * <p>
         * The content of the node input.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowTraceNodeInputContent.Builder}
         * avoiding the need to create one manually via {@link FlowTraceNodeInputContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowTraceNodeInputContent.Builder#build()} is called immediately
         * and its result is passed to {@link #content(FlowTraceNodeInputContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link FlowTraceNodeInputContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(FlowTraceNodeInputContent)
         */
        default Builder content(Consumer<FlowTraceNodeInputContent.Builder> content) {
            return content(FlowTraceNodeInputContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The source node that provides input data to this field.
         * </p>
         * 
         * @param source
         *        The source node that provides input data to this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(FlowTraceNodeInputSource source);

        /**
         * <p>
         * The source node that provides input data to this field.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowTraceNodeInputSource.Builder}
         * avoiding the need to create one manually via {@link FlowTraceNodeInputSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowTraceNodeInputSource.Builder#build()} is called immediately
         * and its result is passed to {@link #source(FlowTraceNodeInputSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link FlowTraceNodeInputSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(FlowTraceNodeInputSource)
         */
        default Builder source(Consumer<FlowTraceNodeInputSource.Builder> source) {
            return source(FlowTraceNodeInputSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The data type of the input field for compatibility validation.
         * </p>
         * 
         * @param type
         *        The data type of the input field for compatibility validation.
         * @see FlowNodeIODataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowNodeIODataType
         */
        Builder type(String type);

        /**
         * <p>
         * The data type of the input field for compatibility validation.
         * </p>
         * 
         * @param type
         *        The data type of the input field for compatibility validation.
         * @see FlowNodeIODataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowNodeIODataType
         */
        Builder type(FlowNodeIODataType type);

        /**
         * <p>
         * The category of the input field.
         * </p>
         * 
         * @param category
         *        The category of the input field.
         * @see FlowNodeInputCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowNodeInputCategory
         */
        Builder category(String category);

        /**
         * <p>
         * The category of the input field.
         * </p>
         * 
         * @param category
         *        The category of the input field.
         * @see FlowNodeInputCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowNodeInputCategory
         */
        Builder category(FlowNodeInputCategory category);

        /**
         * <p>
         * The execution path through nested nodes like iterators and loops.
         * </p>
         * 
         * @param executionChain
         *        The execution path through nested nodes like iterators and loops.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionChain(Collection<FlowTraceNodeInputExecutionChainItem> executionChain);

        /**
         * <p>
         * The execution path through nested nodes like iterators and loops.
         * </p>
         * 
         * @param executionChain
         *        The execution path through nested nodes like iterators and loops.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionChain(FlowTraceNodeInputExecutionChainItem... executionChain);

        /**
         * <p>
         * The execution path through nested nodes like iterators and loops.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeInputExecutionChainItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeInputExecutionChainItem#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeInputExecutionChainItem.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #executionChain(List<FlowTraceNodeInputExecutionChainItem>)}.
         * 
         * @param executionChain
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeInputExecutionChainItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionChain(java.util.Collection<FlowTraceNodeInputExecutionChainItem>)
         */
        Builder executionChain(Consumer<FlowTraceNodeInputExecutionChainItem.Builder>... executionChain);
    }

    static final class BuilderImpl implements Builder {
        private String nodeInputName;

        private FlowTraceNodeInputContent content;

        private FlowTraceNodeInputSource source;

        private String type;

        private String category;

        private List<FlowTraceNodeInputExecutionChainItem> executionChain = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTraceNodeInputField model) {
            nodeInputName(model.nodeInputName);
            content(model.content);
            source(model.source);
            type(model.type);
            category(model.category);
            executionChain(model.executionChain);
        }

        public final String getNodeInputName() {
            return nodeInputName;
        }

        public final void setNodeInputName(String nodeInputName) {
            this.nodeInputName = nodeInputName;
        }

        @Override
        public final Builder nodeInputName(String nodeInputName) {
            this.nodeInputName = nodeInputName;
            return this;
        }

        public final FlowTraceNodeInputContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(FlowTraceNodeInputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(FlowTraceNodeInputContent content) {
            this.content = content;
            return this;
        }

        public final FlowTraceNodeInputSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(FlowTraceNodeInputSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(FlowTraceNodeInputSource source) {
            this.source = source;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowNodeIODataType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(FlowNodeInputCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final List<FlowTraceNodeInputExecutionChainItem.Builder> getExecutionChain() {
            List<FlowTraceNodeInputExecutionChainItem.Builder> result = FlowTraceNodeInputExecutionChainCopier
                    .copyToBuilder(this.executionChain);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExecutionChain(Collection<FlowTraceNodeInputExecutionChainItem.BuilderImpl> executionChain) {
            this.executionChain = FlowTraceNodeInputExecutionChainCopier.copyFromBuilder(executionChain);
        }

        @Override
        public final Builder executionChain(Collection<FlowTraceNodeInputExecutionChainItem> executionChain) {
            this.executionChain = FlowTraceNodeInputExecutionChainCopier.copy(executionChain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionChain(FlowTraceNodeInputExecutionChainItem... executionChain) {
            executionChain(Arrays.asList(executionChain));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionChain(Consumer<FlowTraceNodeInputExecutionChainItem.Builder>... executionChain) {
            executionChain(Stream.of(executionChain)
                    .map(c -> FlowTraceNodeInputExecutionChainItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FlowTraceNodeInputField build() {
            return new FlowTraceNodeInputField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
