/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the source of input data for a flow trace node field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowTraceNodeInputSource implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowTraceNodeInputSource.Builder, FlowTraceNodeInputSource> {
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(FlowTraceNodeInputSource::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final SdkField<String> OUTPUT_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputFieldName").getter(getter(FlowTraceNodeInputSource::outputFieldName))
            .setter(setter(Builder::outputFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFieldName").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expression").getter(getter(FlowTraceNodeInputSource::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_NAME_FIELD,
            OUTPUT_FIELD_NAME_FIELD, EXPRESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodeName;

    private final String outputFieldName;

    private final String expression;

    private FlowTraceNodeInputSource(BuilderImpl builder) {
        this.nodeName = builder.nodeName;
        this.outputFieldName = builder.outputFieldName;
        this.expression = builder.expression;
    }

    /**
     * <p>
     * The name of the source node that provides the input data.
     * </p>
     * 
     * @return The name of the source node that provides the input data.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * The name of the output field from the source node.
     * </p>
     * 
     * @return The name of the output field from the source node.
     */
    public final String outputFieldName() {
        return outputFieldName;
    }

    /**
     * <p>
     * The expression used to extract data from the source.
     * </p>
     * 
     * @return The expression used to extract data from the source.
     */
    public final String expression() {
        return expression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(outputFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTraceNodeInputSource)) {
            return false;
        }
        FlowTraceNodeInputSource other = (FlowTraceNodeInputSource) obj;
        return Objects.equals(nodeName(), other.nodeName()) && Objects.equals(outputFieldName(), other.outputFieldName())
                && Objects.equals(expression(), other.expression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowTraceNodeInputSource").add("NodeName", nodeName()).add("OutputFieldName", outputFieldName())
                .add("Expression", expression() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "outputFieldName":
            return Optional.ofNullable(clazz.cast(outputFieldName()));
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodeName", NODE_NAME_FIELD);
        map.put("outputFieldName", OUTPUT_FIELD_NAME_FIELD);
        map.put("expression", EXPRESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTraceNodeInputSource, T> g) {
        return obj -> g.apply((FlowTraceNodeInputSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowTraceNodeInputSource> {
        /**
         * <p>
         * The name of the source node that provides the input data.
         * </p>
         * 
         * @param nodeName
         *        The name of the source node that provides the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * The name of the output field from the source node.
         * </p>
         * 
         * @param outputFieldName
         *        The name of the output field from the source node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputFieldName(String outputFieldName);

        /**
         * <p>
         * The expression used to extract data from the source.
         * </p>
         * 
         * @param expression
         *        The expression used to extract data from the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);
    }

    static final class BuilderImpl implements Builder {
        private String nodeName;

        private String outputFieldName;

        private String expression;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTraceNodeInputSource model) {
            nodeName(model.nodeName);
            outputFieldName(model.outputFieldName);
            expression(model.expression);
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getOutputFieldName() {
            return outputFieldName;
        }

        public final void setOutputFieldName(String outputFieldName) {
            this.outputFieldName = outputFieldName;
        }

        @Override
        public final Builder outputFieldName(String outputFieldName) {
            this.outputFieldName = outputFieldName;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        @Override
        public FlowTraceNodeInputSource build() {
            return new FlowTraceNodeInputSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
