/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFlowExecutionResponse extends BedrockAgentRuntimeResponse implements
        ToCopyableBuilder<GetFlowExecutionResponse.Builder, GetFlowExecutionResponse> {
    private static final SdkField<String> EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionArn").getter(getter(GetFlowExecutionResponse::executionArn))
            .setter(setter(Builder::executionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetFlowExecutionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(GetFlowExecutionResponse::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(GetFlowExecutionResponse::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<FlowExecutionError>> ERRORS_FIELD = SdkField
            .<List<FlowExecutionError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(GetFlowExecutionResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowExecutionError> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowExecutionError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FLOW_ALIAS_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowAliasIdentifier").getter(getter(GetFlowExecutionResponse::flowAliasIdentifier))
            .setter(setter(Builder::flowAliasIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowAliasIdentifier").build())
            .build();

    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowIdentifier").getter(getter(GetFlowExecutionResponse::flowIdentifier))
            .setter(setter(Builder::flowIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowIdentifier").build()).build();

    private static final SdkField<String> FLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowVersion").getter(getter(GetFlowExecutionResponse::flowVersion)).setter(setter(Builder::flowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ARN_FIELD,
            STATUS_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, ERRORS_FIELD, FLOW_ALIAS_IDENTIFIER_FIELD, FLOW_IDENTIFIER_FIELD,
            FLOW_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String executionArn;

    private final String status;

    private final Instant startedAt;

    private final Instant endedAt;

    private final List<FlowExecutionError> errors;

    private final String flowAliasIdentifier;

    private final String flowIdentifier;

    private final String flowVersion;

    private GetFlowExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionArn = builder.executionArn;
        this.status = builder.status;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.errors = builder.errors;
        this.flowAliasIdentifier = builder.flowAliasIdentifier;
        this.flowIdentifier = builder.flowIdentifier;
        this.flowVersion = builder.flowVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the flow execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies the flow execution.
     */
    public final String executionArn() {
        return executionArn;
    }

    /**
     * <p>
     * The current status of the flow execution.
     * </p>
     * <p>
     * Flow executions time out after 24 hours.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the flow execution.</p>
     *         <p>
     *         Flow executions time out after 24 hours.
     * @see FlowExecutionStatus
     */
    public final FlowExecutionStatus status() {
        return FlowExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the flow execution.
     * </p>
     * <p>
     * Flow executions time out after 24 hours.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the flow execution.</p>
     *         <p>
     *         Flow executions time out after 24 hours.
     * @see FlowExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the flow execution started.
     * </p>
     * 
     * @return The timestamp when the flow execution started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The timestamp when the flow execution ended. This field is only populated when the execution has completed,
     * failed, timed out, or been aborted.
     * </p>
     * 
     * @return The timestamp when the flow execution ended. This field is only populated when the execution has
     *         completed, failed, timed out, or been aborted.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors that occurred during the flow execution. Each error includes an error code, message, and the
     * node where the error occurred, if applicable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of errors that occurred during the flow execution. Each error includes an error code, message, and
     *         the node where the error occurred, if applicable.
     */
    public final List<FlowExecutionError> errors() {
        return errors;
    }

    /**
     * <p>
     * The unique identifier of the flow alias used for the execution.
     * </p>
     * 
     * @return The unique identifier of the flow alias used for the execution.
     */
    public final String flowAliasIdentifier() {
        return flowAliasIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the flow.
     * </p>
     * 
     * @return The unique identifier of the flow.
     */
    public final String flowIdentifier() {
        return flowIdentifier;
    }

    /**
     * <p>
     * The version of the flow used for the execution.
     * </p>
     * 
     * @return The version of the flow used for the execution.
     */
    public final String flowVersion() {
        return flowVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(flowAliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(flowVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFlowExecutionResponse)) {
            return false;
        }
        GetFlowExecutionResponse other = (GetFlowExecutionResponse) obj;
        return Objects.equals(executionArn(), other.executionArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(startedAt(), other.startedAt()) && Objects.equals(endedAt(), other.endedAt())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && Objects.equals(flowAliasIdentifier(), other.flowAliasIdentifier())
                && Objects.equals(flowIdentifier(), other.flowIdentifier()) && Objects.equals(flowVersion(), other.flowVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFlowExecutionResponse").add("ExecutionArn", executionArn()).add("Status", statusAsString())
                .add("StartedAt", startedAt()).add("EndedAt", endedAt()).add("Errors", hasErrors() ? errors() : null)
                .add("FlowAliasIdentifier", flowAliasIdentifier()).add("FlowIdentifier", flowIdentifier())
                .add("FlowVersion", flowVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionArn":
            return Optional.ofNullable(clazz.cast(executionArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "flowAliasIdentifier":
            return Optional.ofNullable(clazz.cast(flowAliasIdentifier()));
        case "flowIdentifier":
            return Optional.ofNullable(clazz.cast(flowIdentifier()));
        case "flowVersion":
            return Optional.ofNullable(clazz.cast(flowVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionArn", EXECUTION_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("errors", ERRORS_FIELD);
        map.put("flowAliasIdentifier", FLOW_ALIAS_IDENTIFIER_FIELD);
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("flowVersion", FLOW_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFlowExecutionResponse, T> g) {
        return obj -> g.apply((GetFlowExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetFlowExecutionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the flow execution.
         * </p>
         * 
         * @param executionArn
         *        The Amazon Resource Name (ARN) that uniquely identifies the flow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionArn(String executionArn);

        /**
         * <p>
         * The current status of the flow execution.
         * </p>
         * <p>
         * Flow executions time out after 24 hours.
         * </p>
         * 
         * @param status
         *        The current status of the flow execution.</p>
         *        <p>
         *        Flow executions time out after 24 hours.
         * @see FlowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the flow execution.
         * </p>
         * <p>
         * Flow executions time out after 24 hours.
         * </p>
         * 
         * @param status
         *        The current status of the flow execution.</p>
         *        <p>
         *        Flow executions time out after 24 hours.
         * @see FlowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowExecutionStatus
         */
        Builder status(FlowExecutionStatus status);

        /**
         * <p>
         * The timestamp when the flow execution started.
         * </p>
         * 
         * @param startedAt
         *        The timestamp when the flow execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The timestamp when the flow execution ended. This field is only populated when the execution has completed,
         * failed, timed out, or been aborted.
         * </p>
         * 
         * @param endedAt
         *        The timestamp when the flow execution ended. This field is only populated when the execution has
         *        completed, failed, timed out, or been aborted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * A list of errors that occurred during the flow execution. Each error includes an error code, message, and the
         * node where the error occurred, if applicable.
         * </p>
         * 
         * @param errors
         *        A list of errors that occurred during the flow execution. Each error includes an error code, message,
         *        and the node where the error occurred, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<FlowExecutionError> errors);

        /**
         * <p>
         * A list of errors that occurred during the flow execution. Each error includes an error code, message, and the
         * node where the error occurred, if applicable.
         * </p>
         * 
         * @param errors
         *        A list of errors that occurred during the flow execution. Each error includes an error code, message,
         *        and the node where the error occurred, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(FlowExecutionError... errors);

        /**
         * <p>
         * A list of errors that occurred during the flow execution. Each error includes an error code, message, and the
         * node where the error occurred, if applicable.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionError.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionError.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<FlowExecutionError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<FlowExecutionError>)
         */
        Builder errors(Consumer<FlowExecutionError.Builder>... errors);

        /**
         * <p>
         * The unique identifier of the flow alias used for the execution.
         * </p>
         * 
         * @param flowAliasIdentifier
         *        The unique identifier of the flow alias used for the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowAliasIdentifier(String flowAliasIdentifier);

        /**
         * <p>
         * The unique identifier of the flow.
         * </p>
         * 
         * @param flowIdentifier
         *        The unique identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowIdentifier(String flowIdentifier);

        /**
         * <p>
         * The version of the flow used for the execution.
         * </p>
         * 
         * @param flowVersion
         *        The version of the flow used for the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowVersion(String flowVersion);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeResponse.BuilderImpl implements Builder {
        private String executionArn;

        private String status;

        private Instant startedAt;

        private Instant endedAt;

        private List<FlowExecutionError> errors = DefaultSdkAutoConstructList.getInstance();

        private String flowAliasIdentifier;

        private String flowIdentifier;

        private String flowVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFlowExecutionResponse model) {
            super(model);
            executionArn(model.executionArn);
            status(model.status);
            startedAt(model.startedAt);
            endedAt(model.endedAt);
            errors(model.errors);
            flowAliasIdentifier(model.flowAliasIdentifier);
            flowIdentifier(model.flowIdentifier);
            flowVersion(model.flowVersion);
        }

        public final String getExecutionArn() {
            return executionArn;
        }

        public final void setExecutionArn(String executionArn) {
            this.executionArn = executionArn;
        }

        @Override
        public final Builder executionArn(String executionArn) {
            this.executionArn = executionArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlowExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final List<FlowExecutionError.Builder> getErrors() {
            List<FlowExecutionError.Builder> result = FlowExecutionErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<FlowExecutionError.BuilderImpl> errors) {
            this.errors = FlowExecutionErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<FlowExecutionError> errors) {
            this.errors = FlowExecutionErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(FlowExecutionError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<FlowExecutionError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> FlowExecutionError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFlowAliasIdentifier() {
            return flowAliasIdentifier;
        }

        public final void setFlowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
        }

        @Override
        public final Builder flowAliasIdentifier(String flowAliasIdentifier) {
            this.flowAliasIdentifier = flowAliasIdentifier;
            return this;
        }

        public final String getFlowIdentifier() {
            return flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final String getFlowVersion() {
            return flowVersion;
        }

        public final void setFlowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
        }

        @Override
        public final Builder flowVersion(String flowVersion) {
            this.flowVersion = flowVersion;
            return this;
        }

        @Override
        public GetFlowExecutionResponse build() {
            return new GetFlowExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
