/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Assessment details of the content analyzed by Guardrails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailAssessment implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailAssessment.Builder, GuardrailAssessment> {
    private static final SdkField<GuardrailTopicPolicyAssessment> TOPIC_POLICY_FIELD = SdkField
            .<GuardrailTopicPolicyAssessment> builder(MarshallingType.SDK_POJO).memberName("topicPolicy")
            .getter(getter(GuardrailAssessment::topicPolicy)).setter(setter(Builder::topicPolicy))
            .constructor(GuardrailTopicPolicyAssessment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPolicy").build()).build();

    private static final SdkField<GuardrailContentPolicyAssessment> CONTENT_POLICY_FIELD = SdkField
            .<GuardrailContentPolicyAssessment> builder(MarshallingType.SDK_POJO).memberName("contentPolicy")
            .getter(getter(GuardrailAssessment::contentPolicy)).setter(setter(Builder::contentPolicy))
            .constructor(GuardrailContentPolicyAssessment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentPolicy").build()).build();

    private static final SdkField<GuardrailWordPolicyAssessment> WORD_POLICY_FIELD = SdkField
            .<GuardrailWordPolicyAssessment> builder(MarshallingType.SDK_POJO).memberName("wordPolicy")
            .getter(getter(GuardrailAssessment::wordPolicy)).setter(setter(Builder::wordPolicy))
            .constructor(GuardrailWordPolicyAssessment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wordPolicy").build()).build();

    private static final SdkField<GuardrailSensitiveInformationPolicyAssessment> SENSITIVE_INFORMATION_POLICY_FIELD = SdkField
            .<GuardrailSensitiveInformationPolicyAssessment> builder(MarshallingType.SDK_POJO)
            .memberName("sensitiveInformationPolicy")
            .getter(getter(GuardrailAssessment::sensitiveInformationPolicy))
            .setter(setter(Builder::sensitiveInformationPolicy))
            .constructor(GuardrailSensitiveInformationPolicyAssessment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveInformationPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_POLICY_FIELD,
            CONTENT_POLICY_FIELD, WORD_POLICY_FIELD, SENSITIVE_INFORMATION_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GuardrailTopicPolicyAssessment topicPolicy;

    private final GuardrailContentPolicyAssessment contentPolicy;

    private final GuardrailWordPolicyAssessment wordPolicy;

    private final GuardrailSensitiveInformationPolicyAssessment sensitiveInformationPolicy;

    private GuardrailAssessment(BuilderImpl builder) {
        this.topicPolicy = builder.topicPolicy;
        this.contentPolicy = builder.contentPolicy;
        this.wordPolicy = builder.wordPolicy;
        this.sensitiveInformationPolicy = builder.sensitiveInformationPolicy;
    }

    /**
     * <p>
     * Topic policy details of the Guardrail.
     * </p>
     * 
     * @return Topic policy details of the Guardrail.
     */
    public final GuardrailTopicPolicyAssessment topicPolicy() {
        return topicPolicy;
    }

    /**
     * <p>
     * Content policy details of the Guardrail.
     * </p>
     * 
     * @return Content policy details of the Guardrail.
     */
    public final GuardrailContentPolicyAssessment contentPolicy() {
        return contentPolicy;
    }

    /**
     * <p>
     * Word policy details of the Guardrail.
     * </p>
     * 
     * @return Word policy details of the Guardrail.
     */
    public final GuardrailWordPolicyAssessment wordPolicy() {
        return wordPolicy;
    }

    /**
     * <p>
     * Sensitive Information policy details of Guardrail.
     * </p>
     * 
     * @return Sensitive Information policy details of Guardrail.
     */
    public final GuardrailSensitiveInformationPolicyAssessment sensitiveInformationPolicy() {
        return sensitiveInformationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(contentPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(wordPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(sensitiveInformationPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAssessment)) {
            return false;
        }
        GuardrailAssessment other = (GuardrailAssessment) obj;
        return Objects.equals(topicPolicy(), other.topicPolicy()) && Objects.equals(contentPolicy(), other.contentPolicy())
                && Objects.equals(wordPolicy(), other.wordPolicy())
                && Objects.equals(sensitiveInformationPolicy(), other.sensitiveInformationPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GuardrailAssessment")
                .add("TopicPolicy", topicPolicy() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContentPolicy", contentPolicy() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WordPolicy", wordPolicy() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SensitiveInformationPolicy",
                        sensitiveInformationPolicy() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topicPolicy":
            return Optional.ofNullable(clazz.cast(topicPolicy()));
        case "contentPolicy":
            return Optional.ofNullable(clazz.cast(contentPolicy()));
        case "wordPolicy":
            return Optional.ofNullable(clazz.cast(wordPolicy()));
        case "sensitiveInformationPolicy":
            return Optional.ofNullable(clazz.cast(sensitiveInformationPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("topicPolicy", TOPIC_POLICY_FIELD);
        map.put("contentPolicy", CONTENT_POLICY_FIELD);
        map.put("wordPolicy", WORD_POLICY_FIELD);
        map.put("sensitiveInformationPolicy", SENSITIVE_INFORMATION_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAssessment, T> g) {
        return obj -> g.apply((GuardrailAssessment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailAssessment> {
        /**
         * <p>
         * Topic policy details of the Guardrail.
         * </p>
         * 
         * @param topicPolicy
         *        Topic policy details of the Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicPolicy(GuardrailTopicPolicyAssessment topicPolicy);

        /**
         * <p>
         * Topic policy details of the Guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailTopicPolicyAssessment.Builder}
         * avoiding the need to create one manually via {@link GuardrailTopicPolicyAssessment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailTopicPolicyAssessment.Builder#build()} is called
         * immediately and its result is passed to {@link #topicPolicy(GuardrailTopicPolicyAssessment)}.
         * 
         * @param topicPolicy
         *        a consumer that will call methods on {@link GuardrailTopicPolicyAssessment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicPolicy(GuardrailTopicPolicyAssessment)
         */
        default Builder topicPolicy(Consumer<GuardrailTopicPolicyAssessment.Builder> topicPolicy) {
            return topicPolicy(GuardrailTopicPolicyAssessment.builder().applyMutation(topicPolicy).build());
        }

        /**
         * <p>
         * Content policy details of the Guardrail.
         * </p>
         * 
         * @param contentPolicy
         *        Content policy details of the Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentPolicy(GuardrailContentPolicyAssessment contentPolicy);

        /**
         * <p>
         * Content policy details of the Guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailContentPolicyAssessment.Builder}
         * avoiding the need to create one manually via {@link GuardrailContentPolicyAssessment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailContentPolicyAssessment.Builder#build()} is called
         * immediately and its result is passed to {@link #contentPolicy(GuardrailContentPolicyAssessment)}.
         * 
         * @param contentPolicy
         *        a consumer that will call methods on {@link GuardrailContentPolicyAssessment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentPolicy(GuardrailContentPolicyAssessment)
         */
        default Builder contentPolicy(Consumer<GuardrailContentPolicyAssessment.Builder> contentPolicy) {
            return contentPolicy(GuardrailContentPolicyAssessment.builder().applyMutation(contentPolicy).build());
        }

        /**
         * <p>
         * Word policy details of the Guardrail.
         * </p>
         * 
         * @param wordPolicy
         *        Word policy details of the Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wordPolicy(GuardrailWordPolicyAssessment wordPolicy);

        /**
         * <p>
         * Word policy details of the Guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailWordPolicyAssessment.Builder}
         * avoiding the need to create one manually via {@link GuardrailWordPolicyAssessment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailWordPolicyAssessment.Builder#build()} is called
         * immediately and its result is passed to {@link #wordPolicy(GuardrailWordPolicyAssessment)}.
         * 
         * @param wordPolicy
         *        a consumer that will call methods on {@link GuardrailWordPolicyAssessment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wordPolicy(GuardrailWordPolicyAssessment)
         */
        default Builder wordPolicy(Consumer<GuardrailWordPolicyAssessment.Builder> wordPolicy) {
            return wordPolicy(GuardrailWordPolicyAssessment.builder().applyMutation(wordPolicy).build());
        }

        /**
         * <p>
         * Sensitive Information policy details of Guardrail.
         * </p>
         * 
         * @param sensitiveInformationPolicy
         *        Sensitive Information policy details of Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitiveInformationPolicy(GuardrailSensitiveInformationPolicyAssessment sensitiveInformationPolicy);

        /**
         * <p>
         * Sensitive Information policy details of Guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailSensitiveInformationPolicyAssessment.Builder} avoiding the need to create one manually via
         * {@link GuardrailSensitiveInformationPolicyAssessment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailSensitiveInformationPolicyAssessment.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #sensitiveInformationPolicy(GuardrailSensitiveInformationPolicyAssessment)}.
         * 
         * @param sensitiveInformationPolicy
         *        a consumer that will call methods on {@link GuardrailSensitiveInformationPolicyAssessment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sensitiveInformationPolicy(GuardrailSensitiveInformationPolicyAssessment)
         */
        default Builder sensitiveInformationPolicy(
                Consumer<GuardrailSensitiveInformationPolicyAssessment.Builder> sensitiveInformationPolicy) {
            return sensitiveInformationPolicy(GuardrailSensitiveInformationPolicyAssessment.builder()
                    .applyMutation(sensitiveInformationPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GuardrailTopicPolicyAssessment topicPolicy;

        private GuardrailContentPolicyAssessment contentPolicy;

        private GuardrailWordPolicyAssessment wordPolicy;

        private GuardrailSensitiveInformationPolicyAssessment sensitiveInformationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAssessment model) {
            topicPolicy(model.topicPolicy);
            contentPolicy(model.contentPolicy);
            wordPolicy(model.wordPolicy);
            sensitiveInformationPolicy(model.sensitiveInformationPolicy);
        }

        public final GuardrailTopicPolicyAssessment.Builder getTopicPolicy() {
            return topicPolicy != null ? topicPolicy.toBuilder() : null;
        }

        public final void setTopicPolicy(GuardrailTopicPolicyAssessment.BuilderImpl topicPolicy) {
            this.topicPolicy = topicPolicy != null ? topicPolicy.build() : null;
        }

        @Override
        public final Builder topicPolicy(GuardrailTopicPolicyAssessment topicPolicy) {
            this.topicPolicy = topicPolicy;
            return this;
        }

        public final GuardrailContentPolicyAssessment.Builder getContentPolicy() {
            return contentPolicy != null ? contentPolicy.toBuilder() : null;
        }

        public final void setContentPolicy(GuardrailContentPolicyAssessment.BuilderImpl contentPolicy) {
            this.contentPolicy = contentPolicy != null ? contentPolicy.build() : null;
        }

        @Override
        public final Builder contentPolicy(GuardrailContentPolicyAssessment contentPolicy) {
            this.contentPolicy = contentPolicy;
            return this;
        }

        public final GuardrailWordPolicyAssessment.Builder getWordPolicy() {
            return wordPolicy != null ? wordPolicy.toBuilder() : null;
        }

        public final void setWordPolicy(GuardrailWordPolicyAssessment.BuilderImpl wordPolicy) {
            this.wordPolicy = wordPolicy != null ? wordPolicy.build() : null;
        }

        @Override
        public final Builder wordPolicy(GuardrailWordPolicyAssessment wordPolicy) {
            this.wordPolicy = wordPolicy;
            return this;
        }

        public final GuardrailSensitiveInformationPolicyAssessment.Builder getSensitiveInformationPolicy() {
            return sensitiveInformationPolicy != null ? sensitiveInformationPolicy.toBuilder() : null;
        }

        public final void setSensitiveInformationPolicy(
                GuardrailSensitiveInformationPolicyAssessment.BuilderImpl sensitiveInformationPolicy) {
            this.sensitiveInformationPolicy = sensitiveInformationPolicy != null ? sensitiveInformationPolicy.build() : null;
        }

        @Override
        public final Builder sensitiveInformationPolicy(GuardrailSensitiveInformationPolicyAssessment sensitiveInformationPolicy) {
            this.sensitiveInformationPolicy = sensitiveInformationPolicy;
            return this;
        }

        @Override
        public GuardrailAssessment build() {
            return new GuardrailAssessment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
