/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Image content for an invocation step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageBlock implements SdkPojo, Serializable, ToCopyableBuilder<ImageBlock.Builder, ImageBlock> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(ImageBlock::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<ImageSource> SOURCE_FIELD = SdkField.<ImageSource> builder(MarshallingType.SDK_POJO)
            .memberName("source").getter(getter(ImageBlock::source)).setter(setter(Builder::source))
            .constructor(ImageSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String format;

    private final ImageSource source;

    private ImageBlock(BuilderImpl builder) {
        this.format = builder.format;
        this.source = builder.source;
    }

    /**
     * <p>
     * The format of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the image.
     * @see ImageFormat
     */
    public final ImageFormat format() {
        return ImageFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the image.
     * @see ImageFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The source for the image.
     * </p>
     * 
     * @return The source for the image.
     */
    public final ImageSource source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageBlock)) {
            return false;
        }
        ImageBlock other = (ImageBlock) obj;
        return Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageBlock").add("Format", formatAsString()).add("Source", source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("format", FORMAT_FIELD);
        map.put("source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageBlock, T> g) {
        return obj -> g.apply((ImageBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageBlock> {
        /**
         * <p>
         * The format of the image.
         * </p>
         * 
         * @param format
         *        The format of the image.
         * @see ImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the image.
         * </p>
         * 
         * @param format
         *        The format of the image.
         * @see ImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageFormat
         */
        Builder format(ImageFormat format);

        /**
         * <p>
         * The source for the image.
         * </p>
         * 
         * @param source
         *        The source for the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ImageSource source);

        /**
         * <p>
         * The source for the image.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageSource.Builder} avoiding the need to
         * create one manually via {@link ImageSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageSource.Builder#build()} is called immediately and its result
         * is passed to {@link #source(ImageSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ImageSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ImageSource)
         */
        default Builder source(Consumer<ImageSource.Builder> source) {
            return source(ImageSource.builder().applyMutation(source).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private ImageSource source;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageBlock model) {
            format(model.format);
            source(model.source);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ImageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final ImageSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(ImageSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ImageSource source) {
            this.source = source;
            return this;
        }

        @Override
        public ImageBlock build() {
            return new ImageBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
