/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler;

/**
 * Response handler for the InvokeInlineAgent API.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface InvokeInlineAgentResponseHandler extends
        EventStreamResponseHandler<InvokeInlineAgentResponse, InlineAgentResponseStream> {
    /**
     * Create a {@link Builder}, used to create a {@link InvokeInlineAgentResponseHandler}.
     */
    static Builder builder() {
        return new DefaultInvokeInlineAgentResponseHandlerBuilder();
    }

    /**
     * Builder for {@link InvokeInlineAgentResponseHandler}. This can be used to create the
     * {@link InvokeInlineAgentResponseHandler} in a more functional way, you may also directly implement the
     * {@link InvokeInlineAgentResponseHandler} interface if preferred.
     */
    @Generated("software.amazon.awssdk:codegen")
    interface Builder extends EventStreamResponseHandler.Builder<InvokeInlineAgentResponse, InlineAgentResponseStream, Builder> {
        /**
         * Sets the subscriber to the {@link org.reactivestreams.Publisher} of events. The given {@link Visitor} will be
         * called for each event received by the publisher. Events are requested sequentially after each event is
         * processed. If you need more control over the backpressure strategy consider using
         * {@link #subscriber(java.util.function.Supplier)} instead.
         *
         * @param visitor
         *        Visitor that will be invoked for each incoming event.
         * @return This builder for method chaining
         */
        Builder subscriber(Visitor visitor);

        /**
         * @return A {@link InvokeInlineAgentResponseHandler} implementation that can be used in the InvokeInlineAgent
         *         API call.
         */
        InvokeInlineAgentResponseHandler build();
    }

    /**
     * Visitor for subtypes of {@link InlineAgentResponseStream}.
     */
    @Generated("software.amazon.awssdk:codegen")
    interface Visitor {
        /**
         * @return A new {@link Builder}.
         */
        static Builder builder() {
            return new DefaultInvokeInlineAgentVisitorBuilder();
        }

        /**
         * A required "else" or "default" block, invoked when no other more-specific "visit" method is appropriate. This
         * is invoked under two circumstances:
         * <ol>
         * <li>The event encountered is newer than the current version of the SDK, so no other more-specific "visit"
         * method could be called. In this case, the provided event will be a generic {@link InlineAgentResponseStream}.
         * These events can be processed by upgrading the SDK.</li>
         * <li>The event is known by the SDK, but the "visit" was not overridden above. In this case, the provided event
         * will be a specific type of {@link InlineAgentResponseStream}.</li>
         * </ol>
         *
         * @param event
         *        The event that was not handled by a more-specific "visit" method.
         */
        default void visitDefault(InlineAgentResponseStream event) {
        }

        /**
         * Invoked when a {@link InlineAgentPayloadPart} is encountered. If this is not overridden, the event will be
         * given to {@link #visitDefault(InlineAgentResponseStream)}.
         *
         * @param event
         *        Event being visited
         */
        default void visitChunk(InlineAgentPayloadPart event) {
            visitDefault(event);
        }

        /**
         * Invoked when a {@link InlineAgentTracePart} is encountered. If this is not overridden, the event will be
         * given to {@link #visitDefault(InlineAgentResponseStream)}.
         *
         * @param event
         *        Event being visited
         */
        default void visitTrace(InlineAgentTracePart event) {
            visitDefault(event);
        }

        /**
         * Invoked when a {@link InlineAgentReturnControlPayload} is encountered. If this is not overridden, the event
         * will be given to {@link #visitDefault(InlineAgentResponseStream)}.
         *
         * @param event
         *        Event being visited
         */
        default void visitReturnControl(InlineAgentReturnControlPayload event) {
            visitDefault(event);
        }

        /**
         * Invoked when a {@link InlineAgentFilePart} is encountered. If this is not overridden, the event will be given
         * to {@link #visitDefault(InlineAgentResponseStream)}.
         *
         * @param event
         *        Event being visited
         */
        default void visitFiles(InlineAgentFilePart event) {
            visitDefault(event);
        }

        /**
         * Builder for {@link Visitor}. The {@link Visitor} class may also be extended for a more traditional style but
         * this builder allows for a more functional way of creating a visitor will callback methods.
         */
        @Generated("software.amazon.awssdk:codegen")
        interface Builder {
            /**
             * Callback to invoke when either an unknown event is visited or an unhandled event is visited.
             *
             * @param c
             *        Callback to process the event.
             * @return This builder for method chaining.
             */
            Builder onDefault(Consumer<InlineAgentResponseStream> c);

            /**
             * @return Visitor implementation.
             */
            Visitor build();

            /**
             * Callback to invoke when a {@link InlineAgentPayloadPart} is visited.
             *
             * @param c
             *        Callback to process the event.
             * @return This builder for method chaining.
             */
            Builder onChunk(Consumer<InlineAgentPayloadPart> c);

            /**
             * Callback to invoke when a {@link InlineAgentTracePart} is visited.
             *
             * @param c
             *        Callback to process the event.
             * @return This builder for method chaining.
             */
            Builder onTrace(Consumer<InlineAgentTracePart> c);

            /**
             * Callback to invoke when a {@link InlineAgentReturnControlPayload} is visited.
             *
             * @param c
             *        Callback to process the event.
             * @return This builder for method chaining.
             */
            Builder onReturnControl(Consumer<InlineAgentReturnControlPayload> c);

            /**
             * Callback to invoke when a {@link InlineAgentFilePart} is visited.
             *
             * @param c
             *        Callback to process the event.
             * @return This builder for method chaining.
             */
            Builder onFiles(Consumer<InlineAgentFilePart> c);
        }
    }
}
