/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the execution process for different types of invocations, such as model invocation,
 * knowledge base invocation, agent collaborator invocation, guardrail invocation, and code interpreter Invocation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Metadata implements SdkPojo, Serializable, ToCopyableBuilder<Metadata.Builder, Metadata> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(Metadata::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(Metadata::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Long> TOTAL_TIME_MS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalTimeMs").getter(getter(Metadata::totalTimeMs)).setter(setter(Builder::totalTimeMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalTimeMs").build()).build();

    private static final SdkField<Long> OPERATION_TOTAL_TIME_MS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("operationTotalTimeMs").getter(getter(Metadata::operationTotalTimeMs))
            .setter(setter(Builder::operationTotalTimeMs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationTotalTimeMs").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientRequestId").getter(getter(Metadata::clientRequestId)).setter(setter(Builder::clientRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestId").build()).build();

    private static final SdkField<Usage> USAGE_FIELD = SdkField.<Usage> builder(MarshallingType.SDK_POJO).memberName("usage")
            .getter(getter(Metadata::usage)).setter(setter(Builder::usage)).constructor(Usage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, TOTAL_TIME_MS_FIELD, OPERATION_TOTAL_TIME_MS_FIELD, CLIENT_REQUEST_ID_FIELD, USAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant startTime;

    private final Instant endTime;

    private final Long totalTimeMs;

    private final Long operationTotalTimeMs;

    private final String clientRequestId;

    private final Usage usage;

    private Metadata(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.totalTimeMs = builder.totalTimeMs;
        this.operationTotalTimeMs = builder.operationTotalTimeMs;
        this.clientRequestId = builder.clientRequestId;
        this.usage = builder.usage;
    }

    /**
     * <p>
     * In the final response, <code>startTime</code> is the start time of the agent invocation operation.
     * </p>
     * 
     * @return In the final response, <code>startTime</code> is the start time of the agent invocation operation.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * In the final response, <code>endTime</code> is the end time of the agent invocation operation.
     * </p>
     * 
     * @return In the final response, <code>endTime</code> is the end time of the agent invocation operation.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The total execution time for the specific invocation being processed (model, knowledge base, guardrail, agent
     * collaborator, or code interpreter). It represents how long the individual invocation took.
     * </p>
     * 
     * @return The total execution time for the specific invocation being processed (model, knowledge base, guardrail,
     *         agent collaborator, or code interpreter). It represents how long the individual invocation took.
     */
    public final Long totalTimeMs() {
        return totalTimeMs;
    }

    /**
     * <p>
     * The total time it took for the agent to complete execution. This field is only set for the final response.
     * </p>
     * 
     * @return The total time it took for the agent to complete execution. This field is only set for the final
     *         response.
     */
    public final Long operationTotalTimeMs() {
        return operationTotalTimeMs;
    }

    /**
     * <p>
     * A unique identifier associated with the downstream invocation. This ID can be used for tracing, debugging, and
     * identifying specific invocations in customer logs or systems.
     * </p>
     * 
     * @return A unique identifier associated with the downstream invocation. This ID can be used for tracing,
     *         debugging, and identifying specific invocations in customer logs or systems.
     */
    public final String clientRequestId() {
        return clientRequestId;
    }

    /**
     * <p>
     * Specific to model invocation and contains details about the usage of a foundation model.
     * </p>
     * 
     * @return Specific to model invocation and contains details about the usage of a foundation model.
     */
    public final Usage usage() {
        return usage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(totalTimeMs());
        hashCode = 31 * hashCode + Objects.hashCode(operationTotalTimeMs());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(usage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metadata)) {
            return false;
        }
        Metadata other = (Metadata) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(totalTimeMs(), other.totalTimeMs())
                && Objects.equals(operationTotalTimeMs(), other.operationTotalTimeMs())
                && Objects.equals(clientRequestId(), other.clientRequestId()) && Objects.equals(usage(), other.usage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Metadata").add("StartTime", startTime()).add("EndTime", endTime())
                .add("TotalTimeMs", totalTimeMs()).add("OperationTotalTimeMs", operationTotalTimeMs())
                .add("ClientRequestId", clientRequestId())
                .add("Usage", usage() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "totalTimeMs":
            return Optional.ofNullable(clazz.cast(totalTimeMs()));
        case "operationTotalTimeMs":
            return Optional.ofNullable(clazz.cast(operationTotalTimeMs()));
        case "clientRequestId":
            return Optional.ofNullable(clazz.cast(clientRequestId()));
        case "usage":
            return Optional.ofNullable(clazz.cast(usage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("totalTimeMs", TOTAL_TIME_MS_FIELD);
        map.put("operationTotalTimeMs", OPERATION_TOTAL_TIME_MS_FIELD);
        map.put("clientRequestId", CLIENT_REQUEST_ID_FIELD);
        map.put("usage", USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Metadata, T> g) {
        return obj -> g.apply((Metadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Metadata> {
        /**
         * <p>
         * In the final response, <code>startTime</code> is the start time of the agent invocation operation.
         * </p>
         * 
         * @param startTime
         *        In the final response, <code>startTime</code> is the start time of the agent invocation operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * In the final response, <code>endTime</code> is the end time of the agent invocation operation.
         * </p>
         * 
         * @param endTime
         *        In the final response, <code>endTime</code> is the end time of the agent invocation operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The total execution time for the specific invocation being processed (model, knowledge base, guardrail, agent
         * collaborator, or code interpreter). It represents how long the individual invocation took.
         * </p>
         * 
         * @param totalTimeMs
         *        The total execution time for the specific invocation being processed (model, knowledge base,
         *        guardrail, agent collaborator, or code interpreter). It represents how long the individual invocation
         *        took.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalTimeMs(Long totalTimeMs);

        /**
         * <p>
         * The total time it took for the agent to complete execution. This field is only set for the final response.
         * </p>
         * 
         * @param operationTotalTimeMs
         *        The total time it took for the agent to complete execution. This field is only set for the final
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationTotalTimeMs(Long operationTotalTimeMs);

        /**
         * <p>
         * A unique identifier associated with the downstream invocation. This ID can be used for tracing, debugging,
         * and identifying specific invocations in customer logs or systems.
         * </p>
         * 
         * @param clientRequestId
         *        A unique identifier associated with the downstream invocation. This ID can be used for tracing,
         *        debugging, and identifying specific invocations in customer logs or systems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestId(String clientRequestId);

        /**
         * <p>
         * Specific to model invocation and contains details about the usage of a foundation model.
         * </p>
         * 
         * @param usage
         *        Specific to model invocation and contains details about the usage of a foundation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(Usage usage);

        /**
         * <p>
         * Specific to model invocation and contains details about the usage of a foundation model.
         * </p>
         * This is a convenience method that creates an instance of the {@link Usage.Builder} avoiding the need to
         * create one manually via {@link Usage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Usage.Builder#build()} is called immediately and its result is
         * passed to {@link #usage(Usage)}.
         * 
         * @param usage
         *        a consumer that will call methods on {@link Usage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usage(Usage)
         */
        default Builder usage(Consumer<Usage.Builder> usage) {
            return usage(Usage.builder().applyMutation(usage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private Long totalTimeMs;

        private Long operationTotalTimeMs;

        private String clientRequestId;

        private Usage usage;

        private BuilderImpl() {
        }

        private BuilderImpl(Metadata model) {
            startTime(model.startTime);
            endTime(model.endTime);
            totalTimeMs(model.totalTimeMs);
            operationTotalTimeMs(model.operationTotalTimeMs);
            clientRequestId(model.clientRequestId);
            usage(model.usage);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Long getTotalTimeMs() {
            return totalTimeMs;
        }

        public final void setTotalTimeMs(Long totalTimeMs) {
            this.totalTimeMs = totalTimeMs;
        }

        @Override
        public final Builder totalTimeMs(Long totalTimeMs) {
            this.totalTimeMs = totalTimeMs;
            return this;
        }

        public final Long getOperationTotalTimeMs() {
            return operationTotalTimeMs;
        }

        public final void setOperationTotalTimeMs(Long operationTotalTimeMs) {
            this.operationTotalTimeMs = operationTotalTimeMs;
        }

        @Override
        public final Builder operationTotalTimeMs(Long operationTotalTimeMs) {
            this.operationTotalTimeMs = operationTotalTimeMs;
            return this;
        }

        public final String getClientRequestId() {
            return clientRequestId;
        }

        public final void setClientRequestId(String clientRequestId) {
            this.clientRequestId = clientRequestId;
        }

        @Override
        public final Builder clientRequestId(String clientRequestId) {
            this.clientRequestId = clientRequestId;
            return this;
        }

        public final Usage.Builder getUsage() {
            return usage != null ? usage.toBuilder() : null;
        }

        public final void setUsage(Usage.BuilderImpl usage) {
            this.usage = usage != null ? usage.build() : null;
        }

        @Override
        public final Builder usage(Usage usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public Metadata build() {
            return new Metadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
