/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an internal trace of a specific node during execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeDependencyEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeDependencyEvent.Builder, NodeDependencyEvent> {
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(NodeDependencyEvent::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp")
            .getter(getter(NodeDependencyEvent::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<NodeTraceElements> TRACE_ELEMENTS_FIELD = SdkField
            .<NodeTraceElements> builder(MarshallingType.SDK_POJO).memberName("traceElements")
            .getter(getter(NodeDependencyEvent::traceElements)).setter(setter(Builder::traceElements))
            .constructor(NodeTraceElements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceElements").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_NAME_FIELD,
            TIMESTAMP_FIELD, TRACE_ELEMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodeName;

    private final Instant timestamp;

    private final NodeTraceElements traceElements;

    private NodeDependencyEvent(BuilderImpl builder) {
        this.nodeName = builder.nodeName;
        this.timestamp = builder.timestamp;
        this.traceElements = builder.traceElements;
    }

    /**
     * <p>
     * The name of the node that generated the dependency trace.
     * </p>
     * 
     * @return The name of the node that generated the dependency trace.
     */
    public final String nodeName() {
        return nodeName;
    }

    /**
     * <p>
     * The date and time that the dependency trace was generated.
     * </p>
     * 
     * @return The date and time that the dependency trace was generated.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The trace elements containing detailed information about the node execution.
     * </p>
     * 
     * @return The trace elements containing detailed information about the node execution.
     */
    public final NodeTraceElements traceElements() {
        return traceElements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(traceElements());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeDependencyEvent)) {
            return false;
        }
        NodeDependencyEvent other = (NodeDependencyEvent) obj;
        return Objects.equals(nodeName(), other.nodeName()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(traceElements(), other.traceElements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeDependencyEvent").add("NodeName", nodeName()).add("Timestamp", timestamp())
                .add("TraceElements", traceElements() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "traceElements":
            return Optional.ofNullable(clazz.cast(traceElements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodeName", NODE_NAME_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("traceElements", TRACE_ELEMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeDependencyEvent, T> g) {
        return obj -> g.apply((NodeDependencyEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeDependencyEvent> {
        /**
         * <p>
         * The name of the node that generated the dependency trace.
         * </p>
         * 
         * @param nodeName
         *        The name of the node that generated the dependency trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);

        /**
         * <p>
         * The date and time that the dependency trace was generated.
         * </p>
         * 
         * @param timestamp
         *        The date and time that the dependency trace was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The trace elements containing detailed information about the node execution.
         * </p>
         * 
         * @param traceElements
         *        The trace elements containing detailed information about the node execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceElements(NodeTraceElements traceElements);

        /**
         * <p>
         * The trace elements containing detailed information about the node execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link NodeTraceElements.Builder} avoiding the
         * need to create one manually via {@link NodeTraceElements#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NodeTraceElements.Builder#build()} is called immediately and its
         * result is passed to {@link #traceElements(NodeTraceElements)}.
         * 
         * @param traceElements
         *        a consumer that will call methods on {@link NodeTraceElements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traceElements(NodeTraceElements)
         */
        default Builder traceElements(Consumer<NodeTraceElements.Builder> traceElements) {
            return traceElements(NodeTraceElements.builder().applyMutation(traceElements).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String nodeName;

        private Instant timestamp;

        private NodeTraceElements traceElements;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeDependencyEvent model) {
            nodeName(model.nodeName);
            timestamp(model.timestamp);
            traceElements(model.traceElements);
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final NodeTraceElements.Builder getTraceElements() {
            return traceElements != null ? traceElements.toBuilder() : null;
        }

        public final void setTraceElements(NodeTraceElements.BuilderImpl traceElements) {
            this.traceElements = traceElements != null ? traceElements.build() : null;
        }

        @Override
        public final Builder traceElements(NodeTraceElements traceElements) {
            this.traceElements = traceElements;
            return this;
        }

        @Override
        public NodeDependencyEvent build() {
            return new NodeDependencyEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
